/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.logging.impl;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeOptionsStep;
import org.hibernate.search.mapper.pojo.common.annotation.impl.SearchProcessingWithContextException;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractor;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.SimpleNameClassFormatter;
import org.hibernate.search.util.common.logging.impl.ToStringTreeAppendableMultilineFormatter;
import org.hibernate.search.util.common.logging.impl.TypeFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void indexingEntities(long count) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntities$str(), (Object)count);
    }

    protected String indexingEntities$str() {
        return "HSEARCH000027: Mass indexing is going to index %d entities.";
    }

    @Override
    public final void indexingEntitiesCompleted(long nbrOfEntities) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntitiesCompleted$str(), (Object)nbrOfEntities);
    }

    protected String indexingEntitiesCompleted$str() {
        return "HSEARCH000028: Mass indexing complete. Indexed %1$d entities.";
    }

    @Override
    public final void indexingProgressRaw(long doneCount, long elapsedMs) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingProgressRaw$str(), (Object)doneCount, (Object)elapsedMs);
    }

    protected String indexingProgressRaw$str() {
        return "HSEARCH000030: Mass indexing progress: indexed %1$d entities in %2$d ms.";
    }

    @Override
    public final void indexingProgressStats(float estimateSpeed, float estimatePercentileComplete) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingProgressStats$str(), (Object)Float.valueOf(estimateSpeed), (Object)Float.valueOf(estimatePercentileComplete));
    }

    protected String indexingProgressStats$str() {
        return "HSEARCH000031: Mass indexing progress: %2$.2f%% [%1$f documents/second].";
    }

    @Override
    public final void interruptedBatchIndexing() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.interruptedBatchIndexing$str(), new Object[0]);
    }

    protected String interruptedBatchIndexing$str() {
        return "HSEARCH000062: Mass indexing received interrupt signal: aborting.";
    }

    protected String unableToResolveDefaultValueBridgeFromSourceType$str() {
        return "HSEARCH000135: No default value bridge implementation for type '%1$s'. Use a custom bridge.";
    }

    @Override
    public final SearchException unableToResolveDefaultValueBridgeFromSourceType(PojoTypeModel<?> sourceType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToResolveDefaultValueBridgeFromSourceType$str(), new PojoTypeModelFormatter(sourceType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String unableToFindLongitudeOrLatitudeProperty$str() {
        return "HSEARCH000159: No property annotated with %1$s(markerSet = \"%3$s\"). There must be exactly one such property in order to map it to geo-point field '%2$s'.";
    }

    @Override
    public final SearchException unableToFindLongitudeOrLatitudeProperty(String annotation, String fieldName, String markerSet) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToFindLongitudeOrLatitudeProperty$str(), annotation, fieldName, markerSet));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleLatitudeOrLongitudeProperties$str() {
        return "HSEARCH000160: Multiple properties annotated with %1$s(markerSet = \"%3$s\"). There must be exactly one such property in order to map it to geo-point field '%2$s'.";
    }

    @Override
    public final SearchException multipleLatitudeOrLongitudeProperties(String annotation, String fieldName, String markerSet) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleLatitudeOrLongitudeProperties$str(), annotation, fieldName, markerSet));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingIdentifierMapping$str() {
        return "HSEARCH000177: Unable to define a document identifier for indexed type '%1$s', The property representing the entity identifier is unknown. Define the document identifier explicitly by annotating a property whose values are unique with @DocumentId.";
    }

    @Override
    public final SearchException missingIdentifierMapping(PojoRawTypeModel<?> typeModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingIdentifierMapping$str(), new PojoTypeModelFormatter(typeModel)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String uselessIncludePathFilters$str() {
        return "HSEARCH000216: An @IndexedEmbedded defines includePaths filters that do not match anything. Non-matching includePaths filters: %1$s. Encountered field paths: %2$s. Check the filters for typos, or remove them if they are not useful.";
    }

    @Override
    public final SearchException uselessIncludePathFilters(Set<String> nonMatchingIncludePaths, Set<String> encounteredFieldPaths, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.uselessIncludePathFilters$str(), nonMatchingIncludePaths, encounteredFieldPaths), eventContext);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String infiniteRecursionForAssociationEmbeddeds$str() {
        return "HSEARCH000221: Infinite embedded recursion involving path '%2$s' on type '%1$s'";
    }

    @Override
    public final SearchException infiniteRecursionForAssociationEmbeddeds(PojoRawTypeModel<?> typeModel, PojoModelPathValueNode path) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.infiniteRecursionForAssociationEmbeddeds$str(), new PojoTypeModelFormatter(typeModel), new PojoModelPathFormatter(path)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidScopeTarget$str() {
        return "HSEARCH000234: Invalid target types: %1$s These types are not indexed, nor is any of their subtypes.";
    }

    @Override
    public final SearchException invalidScopeTarget(Collection<PojoRawTypeIdentifier<?>> nonIndexedTypes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidScopeTarget$str(), nonIndexedTypes));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String parseException$str() {
        return "HSEARCH000295: Invalid value for type '$2%s': '$1%s'. %3$s";
    }

    @Override
    public final SearchException parseException(String text, Class<?> readerClass, String causeMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.parseException$str(), text, new SimpleNameClassFormatter(readerClass), causeMessage), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String valueTooLargeForConversionException$str() {
        return "HSEARCH000297: Unable to convert '%2$s' into type '%1$s': value is too large.";
    }

    @Override
    public final SearchException valueTooLargeForConversionException(Class<?> type, Object duration, Exception ae) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.valueTooLargeForConversionException$str(), new SimpleNameClassFormatter(type), duration), (Throwable)ae);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String conflictingParameterDefined$str() {
        return "HSEARCH000337: Conflicting usage of @Param annotation for parameter name: '%1$s'. Can't assign both value '%2$s' and '%3$s'";
    }

    @Override
    public final SearchException conflictingParameterDefined(String name, Object value1, Object value2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingParameterDefined$str(), name, value1, value2));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToResolveDefaultIdentifierBridgeFromSourceType$str() {
        return "HSEARCH700001: No default identifier bridge implementation for type '%1$s'. Use a custom bridge.";
    }

    @Override
    public final SearchException unableToResolveDefaultIdentifierBridgeFromSourceType(PojoTypeModel<?> sourceType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToResolveDefaultIdentifierBridgeFromSourceType$str(), new PojoTypeModelFormatter(sourceType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingBinderReferenceInBinding$str() {
        return "HSEARCH700003: Empty binder reference.";
    }

    @Override
    public final SearchException missingBinderReferenceInBinding() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingBinderReferenceInBinding$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFieldDefiningBothBridgeReferenceAndBinderReference$str() {
        return "HSEARCH700005: Ambiguous value bridge reference: both 'valueBridge' and 'valueBinder' are set. Only one can be set.";
    }

    @Override
    public final SearchException invalidFieldDefiningBothBridgeReferenceAndBinderReference() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldDefiningBothBridgeReferenceAndBinderReference$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference$str() {
        return "HSEARCH700006: Ambiguous identifier bridge reference: both 'identifierBridge' and 'identifierBinder' are set. Only one can be set.";
    }

    @Override
    public final SearchException invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidEmptyTargetForScope$str() {
        return "HSEARCH700007: Empty scope. If you want to target all indexes, pass 'Object.class' as the target type.";
    }

    @Override
    public final SearchException invalidEmptyTargetForScope() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidEmptyTargetForScope$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidInputTypeForBridge$str() {
        return "HSEARCH700010: Invalid bridge for input type '%2$s': '%1$s'. This bridge expects an input of type '%3$s'.";
    }

    @Override
    public final SearchException invalidInputTypeForBridge(Object bridge, PojoTypeModel<?> typeModel, PojoTypeModel<?> expectedTypeModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidInputTypeForBridge$str(), bridge, new PojoTypeModelFormatter(typeModel), new PojoTypeModelFormatter(expectedTypeModel)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingFieldNameForGeoPointBridgeOnType$str() {
        return "HSEARCH700011: Missing field name for @GeoPointBinding on type %1$s. The field name is mandatory when the bridge is applied to a type, optional when applied to a property.";
    }

    @Override
    public final SearchException missingFieldNameForGeoPointBridgeOnType(String typeName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingFieldNameForGeoPointBridgeOnType$str(), typeName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotInferContainerExtractorClassTypePattern$str() {
        return "HSEARCH700015: Unable to interpret the type arguments to the ContainerExtractor interface in  implementation '%1$s'. Only the following implementations of ContainerExtractor are valid:  1) implementations setting both type parameters to *raw* types, e.g. class MyExtractor implements ContainerExtractor<MyBean, String>; 2) implementations setting the first type parameter to an array of an unbounded type variable, and setting the second parameter to the same type variable, e.g. MyExtractor<T> implements ContainerExtractor<T[], T> 3) implementations setting the first type parameter to a parameterized type with one argument set to an unbounded type variable and the other to unbounded wildcards, and setting the second type parameter to the same type variable, e.g. MyExtractor<T> implements ContainerExtractor<MyParameterizedBean<?, T, ?>, T>";
    }

    @Override
    public final SearchException cannotInferContainerExtractorClassTypePattern(Class<?> extractorClass, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotInferContainerExtractorClassTypePattern$str(), new ClassFormatter(extractorClass)), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidContainerExtractorForType$str() {
        return "HSEARCH700016: Invalid container extractor for type '%3$s': '%1$s' (implementation class: '%2$s')";
    }

    @Override
    public final SearchException invalidContainerExtractorForType(String extractorName, Class<? extends ContainerExtractor> extractorClass, PojoGenericTypeModel<?> extractedType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidContainerExtractorForType$str(), extractorName, new ClassFormatter(extractorClass), new PojoTypeModelFormatter(extractedType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void indexedTypeManager(PojoRawTypeModel<?> typeModel, PojoIndexedTypeManager<?, ?> typeManager) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.indexedTypeManager$str(), (Object)new PojoTypeModelFormatter(typeModel), (Object)new ToStringTreeAppendableMultilineFormatter(typeManager));
    }

    protected String indexedTypeManager$str() {
        return "HSEARCH700017: Type manager for indexed type '%1$s': %2$s";
    }

    @Override
    public final void detectedEntityTypes(Set<PojoRawTypeModel<?>> entityTypes, Set<PojoRawTypeModel<?>> indexedTypes) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.detectedEntityTypes$str(), entityTypes, indexedTypes);
    }

    protected String detectedEntityTypes$str() {
        return "HSEARCH700018: Detected entity types: %1$s, indexed types: %2$s";
    }

    @Override
    public final void containedTypeManager(PojoRawTypeModel<?> typeModel, PojoContainedTypeManager<?, ?> typeManager) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.containedTypeManager$str(), (Object)new PojoTypeModelFormatter(typeModel), (Object)new ToStringTreeAppendableMultilineFormatter(typeManager));
    }

    protected String containedTypeManager$str() {
        return "HSEARCH700019: Type manager for contained type '%1$s': %2$s";
    }

    protected String cannotInvertAssociationForReindexing$str() {
        return "HSEARCH700020: Unable to find the inverse side of the association on type '%2$s' at path '%3$s'. Hibernate Search needs this information in order to reindex '%2$s' when '%1$s' is modified. You can solve this error by defining the inverse side of this association,  either with annotations specific to your integration (@OneToMany(mappedBy = ...) in Hibernate ORM)  or with the Hibernate Search @AssociationInverseSide annotation. Alternatively, if you do not need to reindex '%2$s' when '%1$s' is modified, you can disable automatic reindexing with @IndexingDependency(reindexOnUpdate = ReindexOnUpdate.SHALLOW).";
    }

    @Override
    public final SearchException cannotInvertAssociationForReindexing(PojoRawTypeModel<?> inverseSideTypeModel, PojoRawTypeModel<?> typeModel, PojoModelPathValueNode associationPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotInvertAssociationForReindexing$str(), new PojoTypeModelFormatter(inverseSideTypeModel), new PojoTypeModelFormatter(typeModel), new PojoModelPathFormatter(associationPath)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotApplyImplicitInverseAssociationPath$str() {
        return "HSEARCH700021: Unable to apply path '%2$s' to type '%1$s'. This path was resolved as the inverse side of the association '%4$s' on type '%3$s'. Hibernate Search needs to apply this path in order to reindex '%3$s' when '%1$s' is modified. Nested exception: %5$s";
    }

    @Override
    public final SearchException cannotApplyImplicitInverseAssociationPath(PojoRawTypeModel<?> inverseSideTypeModel, PojoModelPathValueNode inverseSideAssociationPath, PojoRawTypeModel<?> originalSideTypeModel, PojoModelPathValueNode originalSideAssociationPath, String errorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotApplyImplicitInverseAssociationPath$str(), new PojoTypeModelFormatter(inverseSideTypeModel), new PojoModelPathFormatter(inverseSideAssociationPath), new PojoTypeModelFormatter(originalSideTypeModel), new PojoModelPathFormatter(originalSideAssociationPath), errorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String incorrectTargetTypeForInverseAssociation$str() {
        return "HSEARCH700022: The inverse association targets type '%1$s', but a supertype or subtype of '%2$s' was expected.";
    }

    @Override
    public final SearchException incorrectTargetTypeForInverseAssociation(PojoRawTypeModel<?> inverseAssociationTargetType, PojoRawTypeModel<?> entityType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incorrectTargetTypeForInverseAssociation$str(), new PojoTypeModelFormatter(inverseAssociationTargetType), new PojoTypeModelFormatter(entityType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingInversePathInAssociationInverseSideMapping$str() {
        return "HSEARCH700023: @AssociationInverseSide.inversePath is empty.";
    }

    @Override
    public final SearchException missingInversePathInAssociationInverseSideMapping() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingInversePathInAssociationInverseSideMapping$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingEntityTypeMetadata$str() {
        return "HSEARCH700027: Unable to index type '%1$s': this type is not an entity type. If you only expect subtypes to be instantiated, make this type abstract. If you expect this exact type to be instantiated and want it to be indexed, make it an entity type. Otherwise, ensure this type and its subtypes are never indexed by removing the @Indexed annotation or by annotating the type with @Indexed(enabled = false).";
    }

    @Override
    public final SearchException missingEntityTypeMetadata(PojoRawTypeModel<?> typeModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingEntityTypeMetadata$str(), new PojoTypeModelFormatter(typeModel)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingPathInIndexingDependencyDerivedFrom$str() {
        return "HSEARCH700029: @IndexingDependency.derivedFrom contains an empty path.";
    }

    @Override
    public final SearchException missingPathInIndexingDependencyDerivedFrom() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingPathInIndexingDependencyDerivedFrom$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String infiniteRecursionForDerivedFrom$str() {
        return "HSEARCH700030: Unable to resolve dependencies of a derived property: there is a cyclic dependency involving path '%2$s' on type '%1$s'. A derived properties cannot be marked as derived from itself, even indirectly through other  derived properties. If your model actually contains such cyclic dependency,  you should consider disabling automatic reindexing, at least partially  using @IndexingDependency(reindexOnUpdate = ReindexOnUpdate.NO) on one of the properties in the cycle.";
    }

    @Override
    public final SearchException infiniteRecursionForDerivedFrom(PojoRawTypeModel<?> typeModel, PojoModelPathValueNode path) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.infiniteRecursionForDerivedFrom$str(), new PojoTypeModelFormatter(typeModel), new PojoModelPathFormatter(path)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFieldEncodingForStringFieldMapping$str() {
        return "HSEARCH700031: Unable to apply property mapping: this property mapping must target an index field of standard String type, but the resolved field type is non-standard or non-String. This generally means you need to use a different field annotation or to convert property values using a custom ValueBridge or ValueBinder. If you are already using a custom ValueBridge or ValueBinder, check its field type. Details: encountered type DSL step '%1$s', which does not extend the expected interface '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldEncodingForStringFieldMapping(IndexFieldTypeOptionsStep<?, ?> step, Class<?> expectedContextType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldEncodingForStringFieldMapping$str(), step, new ClassFormatter(expectedContextType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nonIndexedNorContainedTypeInIndexingPlan$str() {
        return "HSEARCH700037: Invalid type '%1$s' in an indexing plan: this type is not indexed, neither directly nor as a contained entity in another indexed type.";
    }

    @Override
    public final SearchException nonIndexedNorContainedTypeInIndexingPlan(PojoRawTypeIdentifier<?> targetedType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonIndexedNorContainedTypeInIndexingPlan$str(), targetedType));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullProvidedIdentifier$str() {
        return "HSEARCH700038: The entity identifier must not be null.";
    }

    @Override
    public final SearchException nullProvidedIdentifier() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullProvidedIdentifier$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String incompatibleRequestedType$str() {
        return "HSEARCH700039: '%1$s' cannot be assigned to '%2$s'";
    }

    @Override
    public final SearchException incompatibleRequestedType(PojoModelPathValueNode accessor, Class<?> requestedType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompatibleRequestedType$str(), new PojoModelPathFormatter(accessor), new ClassFormatter(requestedType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nonIndexedTypeInIndexer$str() {
        return "HSEARCH700040: Invalid type '%1$s' in an indexer: this type is not indexed.";
    }

    @Override
    public final SearchException nonIndexedTypeInIndexer(PojoRawTypeIdentifier<?> targetedType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonIndexedTypeInIndexer$str(), targetedType));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseDefaultExtractorsInMultiExtractorChain$str() {
        return "HSEARCH700041: Invalid reference to default extractors: a chain of multiple container extractors must not include the default extractors. Either use only the default extractors, or explicitly reference every single extractor to be applied.";
    }

    @Override
    public final SearchException cannotUseDefaultExtractorsInMultiExtractorChain() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseDefaultExtractorsInMultiExtractorChain$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String malformedURL$str() {
        return "HSEARCH700043: Exception creating URL from String '%1$s'.";
    }

    @Override
    public final SearchException malformedURL(String value, MalformedURLException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.malformedURL$str(), value), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String badURISyntax$str() {
        return "HSEARCH700044: Exception creating URI from String '%1$s'.";
    }

    @Override
    public final SearchException badURISyntax(String value, URISyntaxException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.badURISyntax$str(), value), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotDefinePojoModelPathWithoutProperty$str() {
        return "HSEARCH700045: A PojoModelPath must include at least one property.";
    }

    @Override
    public final SearchException cannotDefinePojoModelPathWithoutProperty() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotDefinePojoModelPathWithoutProperty$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotApplyExplicitInverseAssociationPath$str() {
        return "HSEARCH700046: Unable to apply path '%2$s' to type '%1$s'. This path was declared as a path to collect entities of type '%3$s' to be reindexed. Hibernate Search needs to apply this path in order to reindex '%3$s' when '%1$s' is modified. Nested exception: %4$s";
    }

    @Override
    public final SearchException cannotApplyExplicitInverseAssociationPath(PojoRawTypeModel<?> inverseSideTypeModel, PojoModelPathValueNode inverseSideAssociationPath, PojoRawTypeModel<?> originalSideTypeModel, String errorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotApplyExplicitInverseAssociationPath$str(), new PojoTypeModelFormatter(inverseSideTypeModel), new PojoModelPathFormatter(inverseSideAssociationPath), new PojoTypeModelFormatter(originalSideTypeModel), errorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotDefineOtherEntityDependencyOnNonEntityBridgedType$str() {
        return "HSEARCH700047: Invalid use of 'fromOtherEntity': this method can only be used when the bridged element has an entity type, but the bridged element has type '%1$s', which is not an entity type.";
    }

    @Override
    public final SearchException cannotDefineOtherEntityDependencyOnNonEntityBridgedType(PojoRawTypeModel<?> bridgedTypeModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotDefineOtherEntityDependencyOnNonEntityBridgedType$str(), new PojoTypeModelFormatter(bridgedTypeModel)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotDefineOtherEntityDependencyFromNonEntityType$str() {
        return "HSEARCH700048: Invalid type passed to 'fromOtherEntity': the type must be an entity type. Type '%1$s' is not an entity type.";
    }

    @Override
    public final SearchException cannotDefineOtherEntityDependencyFromNonEntityType(PojoRawTypeModel<?> otherType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotDefineOtherEntityDependencyFromNonEntityType$str(), new PojoTypeModelFormatter(otherType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingBridgeDependencyDeclaration$str() {
        return "HSEARCH700049: Incorrect binder implementation: the binder did not declare any dependency to the entity model during binding. Declare dependencies using context.dependencies().use(...) or, if the bridge really does not depend on the entity model, context.dependencies().useRootOnly().";
    }

    @Override
    public final SearchException missingBridgeDependencyDeclaration() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingBridgeDependencyDeclaration$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String inconsistentBridgeDependencyDeclaration$str() {
        return "HSEARCH700050: Incorrect binder implementation: the binder called context.dependencies().useRootOnly() during binding, but also declared extra dependencies to the entity model.";
    }

    @Override
    public final SearchException inconsistentBridgeDependencyDeclaration() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.inconsistentBridgeDependencyDeclaration$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFieldEncodingForScaledNumberFieldMapping$str() {
        return "HSEARCH700051: Unable to apply property mapping: this property mapping must target an index field of standard, scaled-number type (BigDecimal or BigInteger), but the resolved field type is non-standard or non-scaled. This generally means you need to use a different field annotation or to convert property values using a custom ValueBridge or ValueBinder. If you are already using a custom ValueBridge or ValueBinder, check its field type. Details: encountered type DSL step '%1$s', which does not extend the expected interface '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldEncodingForScaledNumberFieldMapping(IndexFieldTypeOptionsStep<?, ?> step, Class<?> expectedContextType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldEncodingForScaledNumberFieldMapping$str(), step, new ClassFormatter(expectedContextType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotReferenceExtractorsWhenExtractionDisabled$str() {
        return "HSEARCH700052: Unexpected extractor references: extractors cannot be defined explicitly when extract = ContainerExtract.NO. Either leave 'extract' to its default value to define extractors explicitly or leave the 'extractor' list to its default, empty value to disable extraction.";
    }

    @Override
    public final SearchException cannotReferenceExtractorsWhenExtractionDisabled() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotReferenceExtractorsWhenExtractionDisabled$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotResolveContainerExtractorName$str() {
        return "HSEARCH700053: No container extractor with name '%1$s'. Check that this name matches a container extractor, either a builtin one whose name is a constant in '%2$s' or a custom one that was properly registered.";
    }

    @Override
    public final SearchException cannotResolveContainerExtractorName(String extractorName, Class<?> builtinExtractorConstantsClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotResolveContainerExtractorName$str(), extractorName, new ClassFormatter(builtinExtractorConstantsClass)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingBridgeForBinder$str() {
        return "HSEARCH700058: Incorrect binder implementation: binder '%1$s' did not call context.bridge(...).";
    }

    @Override
    public final SearchException missingBridgeForBinder(Object binder) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingBridgeForBinder$str(), binder));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingMarkerForBinder$str() {
        return "HSEARCH700059: Incorrect binder implementation: binder '%1$s' did not call context.marker(...).";
    }

    @Override
    public final SearchException missingMarkerForBinder(Object binder) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingMarkerForBinder$str(), binder));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String recursiveIndexingPlanProcess$str() {
        return "HSEARCH700060: Unable to trigger entity processing while already processing entities. Make sure you do not change entities within an entity getter or a custom bridge used for indexing, and avoid any event that could trigger entity processing. Hibernate ORM flushes, in particular, must be avoided in entity getters and bridges.";
    }

    @Override
    public final SearchException recursiveIndexingPlanProcess() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.recursiveIndexingPlanProcess$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidIndexedEmbedded$str() {
        return "HSEARCH700061: Unable to index-embed type '%1$s': no index mapping (@GenericField, @FullTextField, custom bridges, ...) is defined for that type.";
    }

    @Override
    public final SearchException invalidIndexedEmbedded(PojoTypeModel<?> typeModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexedEmbedded$str(), new PojoTypeModelFormatter(typeModel)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleEntityNames$str() {
        return "HSEARCH700064: Multiple entity names assigned to the same type: '%1$s', '%2$s'.";
    }

    @Override
    public final SearchException multipleEntityNames(String entityName, String otherEntityName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleEntityNames$str(), entityName, otherEntityName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFieldEncodingForStandardFieldMapping$str() {
        return "HSEARCH700065: Unable to apply property mapping: this property mapping must target an index field of standard type, but the resolved field type is non-standard. This generally means you need to use a different field annotation or to convert property values using a custom ValueBridge or ValueBinder. If you are already using a custom ValueBridge or ValueBinder, check its field type. Details: encountered type DSL step '%1$s', which does not extend the expected interface '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldEncodingForStandardFieldMapping(IndexFieldTypeOptionsStep<?, ?> step, Class<?> expectedContextType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldEncodingForStandardFieldMapping$str(), step, new ClassFormatter(expectedContextType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFieldEncodingForNonStandardFieldMapping$str() {
        return "HSEARCH700066: Unable to apply property mapping: this property mapping must target an index field of non-standard type, but the resolved field type is standard. Switch to a standard field annotation such as @GenericField. Details: encountered type DSL step '%1$s', which does extend the interface '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldEncodingForNonStandardFieldMapping(IndexFieldTypeOptionsStep<?, ?> step, Class<?> expectedContextType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldEncodingForNonStandardFieldMapping$str(), step, new ClassFormatter(expectedContextType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidAnnotationTypeForAnnotationProcessor$str() {
        return "HSEARCH700067: Invalid annotation processor: '%1$s'. This processor expects annotations of a different type: '%2$s'.";
    }

    @Override
    public final SearchException invalidAnnotationTypeForAnnotationProcessor(Object annotationProcessor, Class<?> processorAnnotationType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAnnotationTypeForAnnotationProcessor$str(), annotationProcessor, new ClassFormatter(processorAnnotationType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingProcessorReferenceInMappingAnnotation$str() {
        return "HSEARCH700068: Empty annotation processor reference in meta-annotation '%1$s'.";
    }

    @Override
    public final SearchException missingProcessorReferenceInMappingAnnotation(Class<? extends Annotation> metaAnnotationType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingProcessorReferenceInMappingAnnotation$str(), new ClassFormatter(metaAnnotationType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotSetBothIndexedEmbeddedNameAndPrefix$str() {
        return "HSEARCH700069: Ambiguous @IndexedEmbedded name: both 'name' and 'prefix' are set. Only one can be set. Name is '%1$s', prefix is '%2$s'.";
    }

    @Override
    public final SearchException cannotSetBothIndexedEmbeddedNameAndPrefix(String relativeFieldName, String prefix) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotSetBothIndexedEmbeddedNameAndPrefix$str(), relativeFieldName, prefix));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFieldNameDotNotAllowed$str() {
        return "HSEARCH700070: Invalid index field name '%1$s': field names cannot contain a dot ('.').";
    }

    @Override
    public final SearchException invalidFieldNameDotNotAllowed(String relativeFieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldNameDotNotAllowed$str(), relativeFieldName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotFindAlternativeDiscriminator$str() {
        return "HSEARCH700071: No property annotated with @Alternative(id = %1$s). There must be exactly one such property in order to map property '%2$s' to multi-alternative fields.";
    }

    @Override
    public final SearchException cannotFindAlternativeDiscriminator(String alternativeId, String fieldValueSourcePropertyName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFindAlternativeDiscriminator$str(), alternativeId, fieldValueSourcePropertyName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String conflictingAlternativeDiscriminators$str() {
        return "HSEARCH700072: Multiple properties annotated with @Alternative(id = %1$s). There must be exactly one such property in order to map property '%2$s' to multi-alternative fields.";
    }

    @Override
    public final SearchException conflictingAlternativeDiscriminators(String alternativeId, String fieldValueSourcePropertyName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingAlternativeDiscriminators$str(), alternativeId, fieldValueSourcePropertyName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidInputTypeForRoutingBridge$str() {
        return "HSEARCH700073: Invalid routing bridge for entity type '%2$s': '%1$s' This bridge expects an entity type extending '%3$s'.";
    }

    @Override
    public final SearchException invalidInputTypeForRoutingBridge(Object routingBridge, PojoTypeModel<?> typeModel, PojoTypeModel<?> expectedTypeModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidInputTypeForRoutingBridge$str(), routingBridge, new PojoTypeModelFormatter(typeModel), new PojoTypeModelFormatter(expectedTypeModel)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noCurrentRoute$str() {
        return "HSEARCH700075: Incorrect routing bridge implementation: routing bridge '%1$s' did not define any current route. In the implementation of RoutingBridge.route(...), define exactly one current route by calling 'routes.addRoute()', or explicitly indicate indexing is not required by calling 'routes.notIndexed()'.";
    }

    @Override
    public final SearchException noCurrentRoute(Object routingBridge) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noCurrentRoute$str(), routingBridge));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleCurrentRoutes$str() {
        return "HSEARCH700076: Incorrect routing bridge implementation: routing bridge '%1$s' defined multiple current routes. In the implementation of RoutingBridge.route(...), define at most one current route by calling 'routes.addRoute()' at most once.";
    }

    @Override
    public final SearchException multipleCurrentRoutes(Object routingBridge) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleCurrentRoutes$str(), routingBridge));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noPreviousRoute$str() {
        return "HSEARCH700077: Incorrect routing bridge implementation: routing bridge '%1$s' did not define any previous route. In the implementation of RoutingBridge.previousRoutes(...), define at least one previous route by calling 'routes.addRoute()' at least once, or explicitly indicate no prior indexing was performed by calling 'routes.notIndexed()'.";
    }

    @Override
    public final SearchException noPreviousRoute(Object routingBridge) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noPreviousRoute$str(), routingBridge));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotFindReadableProperty$str() {
        return "HSEARCH700078: No readable property named '%2$s' on type '%1$s'.";
    }

    @Override
    public final SearchException cannotFindReadableProperty(PojoRawTypeModel<?> typeModel, String propertyName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFindReadableProperty$str(), new PojoTypeModelFormatter(typeModel), propertyName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorRetrievingPropertyTypeModel$str() {
        return "HSEARCH700079: Exception while retrieving property type model for '%1$s' on '%2$s'.";
    }

    @Override
    public final SearchException errorRetrievingPropertyTypeModel(String propertyModelName, PojoRawTypeModel<?> parentTypeModel, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorRetrievingPropertyTypeModel$str(), propertyModelName, new PojoTypeModelFormatter(parentTypeModel)), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidGenericParameterToInferFieldType$str() {
        return "HSEARCH700080: Unable to infer index field type for value bridge '%1$s': this bridge implements ValueBridge<V, F>, but sets the generic type parameter F to '%2$s'. The index field type can only be inferred automatically when this type parameter is set to a raw class. Use a ValueBinder to set the index field type explicitly, or set the type parameter F to a definite, raw type.";
    }

    @Override
    public final SearchException invalidGenericParameterToInferFieldType(Object bridge, Type type) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidGenericParameterToInferFieldType$str(), bridge, new TypeFormatter(type)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidGenericParameterToInferIdentifierType$str() {
        return "HSEARCH700081: Unable to infer expected identifier type for identifier bridge '%1$s': this bridge implements IdentifierBridge<I>, but sets the generic type parameter I to '%2$s'. The expected identifier type can only be inferred automatically when this type parameter is set to a raw class. Use an IdentifierBinder to set the expected identifier type explicitly, or set the type parameter I to a definite, raw type.";
    }

    @Override
    public final SearchException invalidGenericParameterToInferIdentifierType(Object bridge, Type type) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidGenericParameterToInferIdentifierType$str(), bridge, new TypeFormatter(type)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidGenericParameterToInferValueType$str() {
        return "HSEARCH700082: Unable to infer expected value type for value bridge '%1$s': this bridge implements ValueBridge<V, F>, but sets the generic type parameter V to '%2$s'. The expected value type can only be inferred automatically when this type parameter is set to a raw class. Use a ValueBinder to set the expected value type explicitly, or set the type parameter V to a definite, raw type.";
    }

    @Override
    public final SearchException invalidGenericParameterToInferValueType(Object bridge, Type type) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidGenericParameterToInferValueType$str(), bridge, new TypeFormatter(type)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorBuildingDocument$str() {
        return "HSEARCH700083: Exception while building document for entity '%1$s': %2$s";
    }

    @Override
    public final SearchException errorBuildingDocument(Object entityReference, String message, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorBuildingDocument$str(), entityReference, message), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorResolvingEntitiesToReindex$str() {
        return "HSEARCH700084: Exception while resolving other entities to reindex as a result of changes on entity '%1$s': %2$s";
    }

    @Override
    public final SearchException errorResolvingEntitiesToReindex(Object entityReference, String message, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorResolvingEntitiesToReindex$str(), entityReference, message), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void arbitraryMemberSelection(PojoRawTypeModel<?> typeModel, String propertyName, Member selectedMember, List<Member> otherMembers) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.arbitraryMemberSelection$str(), new Object[]{new PojoTypeModelFormatter(typeModel), propertyName, selectedMember, otherMembers});
    }

    protected String arbitraryMemberSelection$str() {
        return "HSEARCH700085: Multiple getters exist for property named '%2$s' on type '%1$s'. Hibernate Search will use '%3$s' and ignore %4$s. The selected getter may change from one startup to the next. To get rid of this warning, either remove the extra getters or configure the access type for this property to 'FIELD'.";
    }

    protected String unexpectedEntityNameForEntityLoading$str() {
        return "HSEARCH700086: Unexpected entity name for entity loading: '%1$s'. Expected one of %2$s.";
    }

    @Override
    public final SearchException unexpectedEntityNameForEntityLoading(String entityName, Collection<String> expectedNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedEntityNameForEntityLoading$str(), entityName, expectedNames));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullProvidedIdentifierAndEntity$str() {
        return "HSEARCH700087: Invalid indexing request: if the entity is null, the identifier must be provided explicitly.";
    }

    @Override
    public final SearchException nullProvidedIdentifierAndEntity() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullProvidedIdentifierAndEntity$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullEntityForIndexerAddOrUpdate$str() {
        return "HSEARCH700088: Invalid indexing request: the add and update operations require a non-null entity.";
    }

    @Override
    public final SearchException nullEntityForIndexerAddOrUpdate() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullEntityForIndexerAddOrUpdate$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nonIndexedTypeInIndexingEvent$str() {
        return "HSEARCH700089: Invalid entity name '%1$s' in an indexing event: this entity does not exist or is not indexed.";
    }

    @Override
    public final SearchException nonIndexedTypeInIndexingEvent(String entityName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonIndexedTypeInIndexingEvent$str(), entityName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String wrongRequiredIdentifierType$str() {
        return "HSEARCH700090: The required identifier type '%1$s' does not match the actual identifier type '%2$s': the required identifier must be a superclass of the actual identifier.";
    }

    @Override
    public final SearchException wrongRequiredIdentifierType(Class<?> requiredIdentifierType, Class<?> actualIdentifierType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.wrongRequiredIdentifierType$str(), new ClassFormatter(requiredIdentifierType), new ClassFormatter(actualIdentifierType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String massIndexerOperation$str() {
        return "MassIndexer operation";
    }

    @Override
    public final String massIndexerOperation() {
        return String.format(this.getLoggingLocale(), this.massIndexerOperation$str(), new Object[0]);
    }

    protected String massIndexerIndexingInstance$str() {
        return "Indexing instance of entity '%s' during mass indexing";
    }

    @Override
    public final String massIndexerIndexingInstance(String entityName) {
        return String.format(this.getLoggingLocale(), this.massIndexerIndexingInstance$str(), entityName);
    }

    protected String massIndexerFetchingIds$str() {
        return "Fetching identifiers of entities to index for entity '%s' during mass indexing";
    }

    @Override
    public final String massIndexerFetchingIds(String entityName) {
        return String.format(this.getLoggingLocale(), this.massIndexerFetchingIds$str(), entityName);
    }

    protected String massIndexingLoadingAndExtractingEntityData$str() {
        return "Loading and extracting entity data for entity '%s' during mass indexing";
    }

    @Override
    public final String massIndexingLoadingAndExtractingEntityData(String entityName) {
        return String.format(this.getLoggingLocale(), this.massIndexingLoadingAndExtractingEntityData$str(), entityName);
    }

    protected String massIndexingFirstFailureOnEntity$str() {
        return "HSEARCH700101: %1$s failure(s) occurred during mass indexing. See the logs for details. First failure on entity '%2$s': %3$s";
    }

    @Override
    public final SearchException massIndexingFirstFailureOnEntity(long finalFailureCount, Object firstFailureEntity, String firstFailureMessage, Throwable firstFailure) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.massIndexingFirstFailureOnEntity$str(), finalFailureCount, firstFailureEntity, firstFailureMessage), firstFailure);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void failureInMassIndexingFailureHandler(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failureInMassIndexingFailureHandler$str(), new Object[0]);
    }

    protected String failureInMassIndexingFailureHandler$str() {
        return "HSEARCH700102: The mass indexing failure handler threw an exception while handling a previous failure. The failure may not have been reported.";
    }

    protected String massIndexingThreadInterrupted$str() {
        return "HSEARCH700103: Mass indexing received interrupt signal. The index is left in an unknown state!";
    }

    @Override
    public final SearchException massIndexingThreadInterrupted(InterruptedException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.massIndexingThreadInterrupted$str(), new Object[0]), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String paramNotDefined$str() {
        return "HSEARCH700104: Param with name '%1$s' has not been defined for the binder.";
    }

    @Override
    public final SearchException paramNotDefined(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.paramNotDefined$str(), name));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotWorkWithIdentifierBecauseUnconfiguredIdentifierMapping$str() {
        return "HSEARCH700105: Cannot work with the identifier of entities of type '%1$s': identifier mapping (@DocumentId, ...) is not configured for this type.";
    }

    @Override
    public final SearchException cannotWorkWithIdentifierBecauseUnconfiguredIdentifierMapping(PojoRawTypeIdentifier<?> typeIdentifier) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotWorkWithIdentifierBecauseUnconfiguredIdentifierMapping$str(), typeIdentifier));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String massIndexingFirstFailure$str() {
        return "HSEARCH700042: %1$s failure(s) occurred during mass indexing. See the logs for details. First failure: %2$s";
    }

    @Override
    public final SearchException massIndexingFirstFailure(long finalFailureCount, String firstFailureMessage, Throwable firstFailure) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.massIndexingFirstFailure$str(), finalFailureCount, firstFailureMessage), firstFailure);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String searchProcessingFailure$str() {
        return "%1$s";
    }

    @Override
    public final SearchProcessingWithContextException searchProcessingFailure(Throwable cause, String causeMessage, EventContext context) {
        SearchProcessingWithContextException result = new SearchProcessingWithContextException(String.format(this.getLoggingLocale(), this.searchProcessingFailure$str(), causeMessage), cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }
}

