/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.runtime.impl;

import java.util.Optional;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.types.converter.FromDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContextExtension;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentValueConvertContextExtension;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeFromDocumentIdentifierContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeToDocumentIdentifierContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeMappingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeSessionContext;

public final class PojoIdentifierBridgeDocumentValueConverter<I>
implements ToDocumentValueConverter<I, String>,
FromDocumentValueConverter<String, I> {
    private final IdentifierBridge<I> bridge;

    public PojoIdentifierBridgeDocumentValueConverter(IdentifierBridge<I> bridge) {
        this.bridge = bridge;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.bridge + "]";
    }

    public String toDocumentValue(I value, ToDocumentValueConvertContext context) {
        return this.bridge.toDocumentIdentifier(value, (IdentifierBridgeToDocumentIdentifierContext)context.extension((ToDocumentValueConvertContextExtension)ContextExtension.INSTANCE));
    }

    public I fromDocumentValue(String value, FromDocumentValueConvertContext context) {
        return this.bridge.fromDocumentIdentifier(value, (IdentifierBridgeFromDocumentIdentifierContext)context.extension((FromDocumentValueConvertContextExtension)ContextExtension.INSTANCE));
    }

    public boolean isCompatibleWith(ToDocumentValueConverter<?, ?> other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        PojoIdentifierBridgeDocumentValueConverter castedOther = (PojoIdentifierBridgeDocumentValueConverter)other;
        return this.bridge.isCompatibleWith(castedOther.bridge);
    }

    public boolean isCompatibleWith(FromDocumentValueConverter<?, ?> other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        PojoIdentifierBridgeDocumentValueConverter castedOther = (PojoIdentifierBridgeDocumentValueConverter)other;
        return this.bridge.isCompatibleWith(castedOther.bridge);
    }

    private static class ContextExtension
    implements ToDocumentValueConvertContextExtension<IdentifierBridgeToDocumentIdentifierContext>,
    FromDocumentValueConvertContextExtension<IdentifierBridgeFromDocumentIdentifierContext> {
        private static final ContextExtension INSTANCE = new ContextExtension();

        private ContextExtension() {
        }

        public Optional<IdentifierBridgeToDocumentIdentifierContext> extendOptional(ToDocumentValueConvertContext original, BackendMappingContext mappingContext) {
            if (mappingContext instanceof BridgeMappingContext) {
                BridgeMappingContext pojoMappingContext = (BridgeMappingContext)mappingContext;
                return Optional.of(pojoMappingContext.identifierBridgeToDocumentIdentifierContext());
            }
            return Optional.empty();
        }

        public Optional<IdentifierBridgeFromDocumentIdentifierContext> extendOptional(FromDocumentValueConvertContext original, BackendSessionContext sessionContext) {
            if (sessionContext instanceof BridgeSessionContext) {
                BridgeSessionContext pojoSessionContext = (BridgeSessionContext)sessionContext;
                return Optional.of(pojoSessionContext.identifierBridgeFromDocumentIdentifierContext());
            }
            return Optional.empty();
        }
    }
}

