/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMapping;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessorRef;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.TypeMapping;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.TypeMappingAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.TypeMappingAnnotationProcessorRef;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.impl.MappingAnnotationProcessorUtils;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.impl.GenericTypeContext;
import org.hibernate.search.util.common.reflect.impl.ReflectionUtils;

public class AnnotationProcessorProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanResolver beanResolver;
    private final FailureCollector rootFailureCollector;
    private final Map<Class<? extends Annotation>, Optional<BeanReference<? extends TypeMappingAnnotationProcessor>>> typeAnnotationProcessorReferenceCache = new HashMap<Class<? extends Annotation>, Optional<BeanReference<? extends TypeMappingAnnotationProcessor>>>();
    private final Map<Class<? extends Annotation>, Optional<BeanReference<? extends PropertyMappingAnnotationProcessor>>> propertyAnnotationProcessorReferenceCache = new HashMap<Class<? extends Annotation>, Optional<BeanReference<? extends PropertyMappingAnnotationProcessor>>>();

    public AnnotationProcessorProvider(BeanResolver beanResolver, FailureCollector rootFailureCollector) {
        this.beanResolver = beanResolver;
        this.rootFailureCollector = rootFailureCollector;
    }

    public <A extends Annotation> Optional<BeanHolder<? extends TypeMappingAnnotationProcessor<? super A>>> createTypeAnnotationProcessor(A annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        BeanHolder<? extends TypeMappingAnnotationProcessor> processor = null;
        try {
            Optional<BeanReference<? extends TypeMappingAnnotationProcessor>> processorReference = this.getTypeAnnotationProcessorReference(annotationType);
            if (!processorReference.isPresent()) {
                return Optional.empty();
            }
            processor = this.createProcessorBean(TypeMappingAnnotationProcessor.class, annotationType, processorReference.get());
        }
        catch (RuntimeException e) {
            this.rootFailureCollector.withContext(PojoEventContexts.fromAnnotationType(annotationType)).add((Throwable)e);
            this.typeAnnotationProcessorReferenceCache.put(annotationType, Optional.empty());
        }
        return Optional.ofNullable(processor);
    }

    public <A extends Annotation> Optional<BeanHolder<? extends PropertyMappingAnnotationProcessor<? super A>>> createPropertyAnnotationProcessor(A annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        BeanHolder<? extends PropertyMappingAnnotationProcessor> processor = null;
        try {
            Optional<BeanReference<? extends PropertyMappingAnnotationProcessor>> processorReference = this.getPropertyAnnotationProcessorReference(annotationType);
            if (!processorReference.isPresent()) {
                return Optional.empty();
            }
            processor = this.createProcessorBean(PropertyMappingAnnotationProcessor.class, annotationType, processorReference.get());
        }
        catch (RuntimeException e) {
            this.rootFailureCollector.withContext(PojoEventContexts.fromAnnotationType(annotationType)).add((Throwable)e);
            this.typeAnnotationProcessorReferenceCache.put(annotationType, Optional.empty());
        }
        return Optional.ofNullable(processor);
    }

    private Optional<BeanReference<? extends TypeMappingAnnotationProcessor>> getTypeAnnotationProcessorReference(Class<? extends Annotation> annotationType) {
        Optional<BeanReference<? extends TypeMappingAnnotationProcessor>> processorReference = this.typeAnnotationProcessorReferenceCache.get(annotationType);
        if (processorReference == null) {
            processorReference = this.createTypeAnnotationProcessorReference(annotationType);
            this.typeAnnotationProcessorReferenceCache.put(annotationType, processorReference);
        }
        return processorReference;
    }

    private Optional<BeanReference<? extends PropertyMappingAnnotationProcessor>> getPropertyAnnotationProcessorReference(Class<? extends Annotation> annotationType) {
        Optional<BeanReference<? extends PropertyMappingAnnotationProcessor>> processorReference = this.propertyAnnotationProcessorReferenceCache.get(annotationType);
        if (processorReference == null) {
            processorReference = this.createPropertyAnnotationProcessorReference(annotationType);
            this.propertyAnnotationProcessorReferenceCache.put(annotationType, processorReference);
        }
        return processorReference;
    }

    private Optional<BeanReference<? extends TypeMappingAnnotationProcessor>> createTypeAnnotationProcessorReference(Class<? extends Annotation> annotationType) {
        TypeMapping mapping = annotationType.getAnnotation(TypeMapping.class);
        if (mapping == null) {
            return Optional.empty();
        }
        TypeMappingAnnotationProcessorRef referenceAnnotation = mapping.processor();
        Optional<BeanReference<? extends TypeMappingAnnotationProcessor>> processorReference = MappingAnnotationProcessorUtils.toBeanReference(TypeMappingAnnotationProcessor.class, TypeMappingAnnotationProcessorRef.UndefinedProcessorImplementationType.class, referenceAnnotation.type(), referenceAnnotation.name(), referenceAnnotation.retrieval());
        if (!processorReference.isPresent()) {
            throw log.missingProcessorReferenceInMappingAnnotation(TypeMapping.class);
        }
        return processorReference;
    }

    private <A extends Annotation> Optional<BeanReference<? extends PropertyMappingAnnotationProcessor>> createPropertyAnnotationProcessorReference(Class<? extends A> annotationType) {
        PropertyMapping mapping = annotationType.getAnnotation(PropertyMapping.class);
        if (mapping == null) {
            return Optional.empty();
        }
        PropertyMappingAnnotationProcessorRef referenceAnnotation = mapping.processor();
        Optional<BeanReference<? extends PropertyMappingAnnotationProcessor>> processorReference = MappingAnnotationProcessorUtils.toBeanReference(PropertyMappingAnnotationProcessor.class, PropertyMappingAnnotationProcessorRef.UndefinedProcessorImplementationType.class, referenceAnnotation.type(), referenceAnnotation.name(), referenceAnnotation.retrieval());
        if (!processorReference.isPresent()) {
            throw log.missingProcessorReferenceInMappingAnnotation(PropertyMapping.class);
        }
        return processorReference;
    }

    private <B, A extends Annotation> BeanHolder<? extends B> createProcessorBean(Class<B> expectedType, Class<A> encounteredAnnotationType, BeanReference<? extends B> processorReference) {
        BeanHolder delegateHolder = processorReference.resolve(this.beanResolver);
        try {
            Object processor = delegateHolder.get();
            GenericTypeContext bridgeTypeContext = new GenericTypeContext(processor.getClass());
            Class processorAnnotationType = bridgeTypeContext.resolveTypeArgument(expectedType, 0).map(ReflectionUtils::getRawType).orElseThrow(() -> new AssertionFailure("Could not auto-detect the annotation type accepted by processor '" + processor + "'."));
            if (!processorAnnotationType.isAssignableFrom(encounteredAnnotationType)) {
                throw log.invalidAnnotationTypeForAnnotationProcessor(processor, processorAnnotationType);
            }
            return delegateHolder;
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)delegateHolder);
            throw e;
        }
    }
}

