/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.identity.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEntityBindingContext;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.identity.impl.IdentifierMappingImplementor;
import org.hibernate.search.mapper.pojo.identity.impl.IdentityMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.identity.impl.IdentityMappingMode;
import org.hibernate.search.mapper.pojo.identity.impl.PojoIdentityMappingCollector;
import org.hibernate.search.mapper.pojo.identity.impl.PropertyIdentifierMapping;
import org.hibernate.search.mapper.pojo.identity.impl.ProvidedIdentifierMapping;
import org.hibernate.search.mapper.pojo.identity.impl.UnconfiguredIdentifierMapping;
import org.hibernate.search.mapper.pojo.identity.impl.UnmappedPropertyIdentifierMapping;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class PojoRootIdentityMappingCollector<E>
implements PojoIdentityMappingCollector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoRawTypeModel<E> typeModel;
    private final PojoMappingHelper mappingHelper;
    private final Optional<IndexedEntityBindingContext> bindingContext;
    private final BeanReference<? extends IdentifierBridge<Object>> providedIdentifierBridge;
    private final BeanResolver beanResolver;
    private IdentifierMappingImplementor<?, E> identifierMapping;
    private PojoPropertyModel<?> documentIdSourceProperty;

    public PojoRootIdentityMappingCollector(PojoRawTypeModel<E> typeModel, PojoMappingHelper mappingHelper, Optional<IndexedEntityBindingContext> bindingContext, BeanReference<? extends IdentifierBridge<Object>> providedIdentifierBridge, BeanResolver beanResolver) {
        this.typeModel = typeModel;
        this.mappingHelper = mappingHelper;
        this.bindingContext = bindingContext;
        this.providedIdentifierBridge = providedIdentifierBridge;
        this.beanResolver = beanResolver;
    }

    public void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.push(IdentifierMappingImplementor::close, this.identifierMapping);
        }
    }

    public PojoIndexMappingCollectorTypeNode toMappingCollectorRootNode() {
        return new IdentityMappingCollectorTypeNode<E>(BoundPojoModelPath.root(this.typeModel), this.mappingHelper, this);
    }

    @Override
    public <T> void identifierBridge(BoundPojoModelPathPropertyNode<?, T> modelPath, IdentifierBinder binder, Map<String, Object> params) {
        BoundIdentifierBridge<T> boundIdentifierBridge = this.mappingHelper.indexModelBinder().bindIdentifier(this.bindingContext, modelPath, binder, params);
        PojoPropertyModel<T> propertyModel = modelPath.getPropertyModel();
        this.identifierMapping = new PropertyIdentifierMapping(propertyModel.typeModel().rawType().caster(), propertyModel.handle(), boundIdentifierBridge.getBridgeHolder());
        this.documentIdSourceProperty = propertyModel;
    }

    public IdentifierMappingImplementor<?, E> buildAndContributeTo(PojoTypeExtendedMappingCollector extendedMappingCollector, IdentityMappingMode mode) {
        this.applyDefaults(mode);
        if (this.documentIdSourceProperty != null) {
            extendedMappingCollector.documentIdSourceProperty(this.documentIdSourceProperty);
        }
        extendedMappingCollector.identifierMapping(this.identifierMapping);
        return this.identifierMapping;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyDefaults(IdentityMappingMode mode) {
        if (this.identifierMapping != null) {
            return;
        }
        if (this.providedIdentifierBridge != null) {
            this.identifierMapping = ProvidedIdentifierMapping.get((BeanHolder<? extends IdentifierBridge<Object>>)this.beanResolver.resolve(this.providedIdentifierBridge));
            this.documentIdSourceProperty = null;
            return;
        }
        Optional<BoundPojoModelPathPropertyNode<E, ?>> entityIdPropertyPath = this.mappingHelper.indexModelBinder().createEntityIdPropertyPath(this.typeModel);
        if (IdentityMappingMode.REQUIRED.equals((Object)mode)) {
            if (!entityIdPropertyPath.isPresent()) throw log.missingIdentifierMapping(this.typeModel);
            this.identifierBridge(entityIdPropertyPath.get(), null, Collections.emptyMap());
            return;
        } else {
            this.identifierMapping = entityIdPropertyPath.isPresent() ? this.unmappedIdentifier(entityIdPropertyPath.get()) : new UnconfiguredIdentifierMapping<E>(this.typeModel.typeIdentifier());
        }
    }

    private <T> IdentifierMappingImplementor<T, E> unmappedIdentifier(BoundPojoModelPathPropertyNode<?, T> modelPath) {
        PojoPropertyModel<T> propertyModel = modelPath.getPropertyModel();
        return new UnmappedPropertyIdentifierMapping<T, E>(this.typeModel.typeIdentifier(), propertyModel.typeModel().rawType().caster(), propertyModel.handle());
    }
}

