/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.hcann.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.mapper.pojo.model.hcann.spi.AbstractPojoHCAnnBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.hcann.spi.PojoCommonsAnnotationsHelper;
import org.hibernate.search.mapper.pojo.model.hcann.spi.PojoHCAnnConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.AbstractPojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;

public abstract class AbstractPojoHCAnnRawTypeModel<T, I extends AbstractPojoHCAnnBootstrapIntrospector>
extends AbstractPojoRawTypeModel<T, I> {
    protected final XClass xClass;
    final GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext;
    private Map<String, XProperty> declaredFieldAccessXPropertiesByName;
    private Map<String, List<XProperty>> declaredMethodAccessXPropertiesByName;

    public AbstractPojoHCAnnRawTypeModel(I introspector, PojoRawTypeIdentifier<T> typeIdentifier, GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext) {
        super(introspector, typeIdentifier);
        this.xClass = ((AbstractPojoHCAnnBootstrapIntrospector)introspector).toXClass(typeIdentifier.javaClass());
        this.rawTypeDeclaringContext = rawTypeDeclaringContext;
    }

    public boolean isAbstract() {
        return this.xClass.isAbstract();
    }

    public final boolean isSubTypeOf(MappableTypeModel other) {
        return other instanceof AbstractPojoHCAnnRawTypeModel && ((AbstractPojoHCAnnRawTypeModel)other).xClass.isAssignableFrom(this.xClass);
    }

    @Override
    public Optional<PojoTypeModel<?>> typeArgument(Class<?> rawSuperType, int typeParameterIndex) {
        return this.rawTypeDeclaringContext.typeArgument(rawSuperType, typeParameterIndex);
    }

    @Override
    public Optional<PojoTypeModel<?>> arrayElementType() {
        return this.rawTypeDeclaringContext.arrayElementType();
    }

    @Override
    public Stream<Annotation> annotations() {
        return ((AbstractPojoHCAnnBootstrapIntrospector)this.introspector).annotations((XAnnotatedElement)this.xClass);
    }

    @Override
    protected List<PojoConstructorModel<T>> createDeclaredConstructors() {
        return Arrays.stream(this.toClass().getDeclaredConstructors()).map(constructor -> new PojoHCAnnConstructorModel((AbstractPojoHCAnnBootstrapIntrospector)this.introspector, this, constructor)).collect(Collectors.toList());
    }

    private Class<T> toClass() {
        return ((AbstractPojoHCAnnBootstrapIntrospector)this.introspector).toClass(this.xClass);
    }

    @Override
    public PojoTypeModel<? extends T> cast(PojoTypeModel<?> other) {
        if (other.rawType().isSubTypeOf(this)) {
            return other;
        }
        return other.castTo(this.typeIdentifier.javaClass()).orElse(this);
    }

    @Override
    protected final Stream<String> declaredPropertyNames() {
        return Stream.concat(this.declaredFieldAccessXPropertiesByName().keySet().stream(), this.declaredMethodAccessXPropertiesByName().keySet().stream()).distinct();
    }

    protected final Map<String, XProperty> declaredFieldAccessXPropertiesByName() {
        if (this.declaredFieldAccessXPropertiesByName == null) {
            this.declaredFieldAccessXPropertiesByName = ((AbstractPojoHCAnnBootstrapIntrospector)this.introspector).declaredFieldAccessXPropertiesByName(this.xClass);
        }
        return this.declaredFieldAccessXPropertiesByName;
    }

    protected final Map<String, List<XProperty>> declaredMethodAccessXPropertiesByName() {
        if (this.declaredMethodAccessXPropertiesByName == null) {
            this.declaredMethodAccessXPropertiesByName = ((AbstractPojoHCAnnBootstrapIntrospector)this.introspector).declaredMethodAccessXPropertiesByName(this.xClass);
        }
        return this.declaredMethodAccessXPropertiesByName;
    }

    protected final List<Member> declaredPropertyGetters(String propertyName) {
        List<XProperty> methodAccessXProperties = this.declaredMethodAccessXPropertiesByName().get(propertyName);
        if (methodAccessXProperties != null) {
            return methodAccessXProperties.stream().map(PojoCommonsAnnotationsHelper::extractUnderlyingMember).collect(Collectors.toList());
        }
        return null;
    }

    protected final Member declaredPropertyField(String propertyName) {
        XProperty fieldAccessXProperty = this.declaredFieldAccessXPropertiesByName().get(propertyName);
        if (fieldAccessXProperty != null) {
            return PojoCommonsAnnotationsHelper.extractUnderlyingMember(fieldAccessXProperty);
        }
        return null;
    }
}

