/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.NoOpDocumentRouter;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeSessionContext;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorRootContext;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorSessionContext;
import org.hibernate.search.mapper.pojo.route.DocumentRouteDescriptor;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.work.impl.PojoDocumentReferenceProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;

public class PojoTypeIndexer<I, E>
implements PojoIndexingProcessorRootContext {
    private final PojoWorkSessionContext sessionContext;
    private final PojoWorkIndexedTypeContext<I, E> typeContext;
    private final IndexIndexer delegate;

    public PojoTypeIndexer(PojoWorkIndexedTypeContext<I, E> typeContext, PojoWorkSessionContext sessionContext, IndexIndexer delegate) {
        this.sessionContext = sessionContext;
        this.typeContext = typeContext;
        this.delegate = delegate;
    }

    @Override
    public PojoIndexingProcessorSessionContext sessionContext() {
        return this.sessionContext;
    }

    @Override
    public boolean isDeleted(Object unproxiedObject) {
        return false;
    }

    CompletableFuture<?> add(Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        Supplier entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        Object identifier = this.typeContext.identifierMapping().getIdentifier(providedId, entitySupplier);
        DocumentRouteDescriptor currentRoute = this.typeContext.router().currentRoute(identifier, entitySupplier, providedRoutes, this.sessionContext);
        if (currentRoute == null) {
            return CompletableFuture.completedFuture(null);
        }
        String documentIdentifier = this.typeContext.toDocumentIdentifier(this.sessionContext, identifier);
        PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, currentRoute.routingKey(), identifier);
        return this.delegate.add((DocumentReferenceProvider)referenceProvider, this.typeContext.toDocumentContributor(this.sessionContext, this, identifier, entitySupplier), commitStrategy, refreshStrategy);
    }

    CompletableFuture<?> addOrUpdate(Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        Supplier entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        Object identifier = this.typeContext.identifierMapping().getIdentifier(providedId, entitySupplier);
        DocumentRoutesDescriptor routes = this.typeContext.router().routes(identifier, entitySupplier, providedRoutes, this.sessionContext);
        String documentIdentifier = this.typeContext.toDocumentIdentifier(this.sessionContext, identifier);
        CompletableFuture<?> deletePreviousFuture = this.deletePrevious(documentIdentifier, routes.previousRoutes(), identifier, commitStrategy, refreshStrategy);
        if (routes.currentRoute() == null) {
            return deletePreviousFuture;
        }
        PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, routes.currentRoute().routingKey(), identifier);
        return deletePreviousFuture.thenCombine((CompletionStage)this.delegate.addOrUpdate((DocumentReferenceProvider)referenceProvider, this.typeContext.toDocumentContributor(this.sessionContext, this, identifier, entitySupplier), commitStrategy, refreshStrategy), (deletePreviousResult, updateResult) -> updateResult);
    }

    CompletableFuture<?> delete(Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        Supplier entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        Object identifier = this.typeContext.identifierMapping().getIdentifier(providedId, entitySupplier);
        DocumentRoutesDescriptor routes = this.typeContext.router().routes(identifier, entitySupplier, providedRoutes, this.sessionContext);
        String documentIdentifier = this.typeContext.toDocumentIdentifier(this.sessionContext, identifier);
        CompletableFuture<?> deletePreviousFuture = this.deletePrevious(documentIdentifier, routes.previousRoutes(), identifier, commitStrategy, refreshStrategy);
        if (routes.currentRoute() == null) {
            return deletePreviousFuture;
        }
        PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, routes.currentRoute().routingKey(), identifier);
        return deletePreviousFuture.thenCombine((CompletionStage)this.delegate.delete((DocumentReferenceProvider)referenceProvider, commitStrategy, refreshStrategy), (deletePreviousResult, deleteResult) -> deleteResult);
    }

    CompletableFuture<?> delete(Object providedId, DocumentRoutesDescriptor providedRoutes, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        Object identifier = this.typeContext.identifierMapping().getIdentifier(providedId, null);
        DocumentRoutesDescriptor routes = NoOpDocumentRouter.INSTANCE.routes(identifier, (Supplier<?>)null, providedRoutes, (BridgeSessionContext)this.sessionContext);
        String documentIdentifier = this.typeContext.toDocumentIdentifier(this.sessionContext, identifier);
        CompletableFuture<?> deletePreviousFuture = this.deletePrevious(documentIdentifier, routes.previousRoutes(), identifier, commitStrategy, refreshStrategy);
        PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, routes.currentRoute().routingKey(), identifier);
        return deletePreviousFuture.thenCombine((CompletionStage)this.delegate.delete((DocumentReferenceProvider)referenceProvider, commitStrategy, refreshStrategy), (deletePreviousResult, deleteResult) -> deleteResult);
    }

    private CompletableFuture<?> deletePrevious(String documentIdentifier, Collection<DocumentRouteDescriptor> previousRoutes, I identifier, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        if (previousRoutes.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture[] futures = new CompletableFuture[previousRoutes.size()];
        int i = 0;
        for (DocumentRouteDescriptor route : previousRoutes) {
            PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, route.routingKey(), identifier);
            futures[i++] = this.delegate.delete((DocumentReferenceProvider)referenceProvider, commitStrategy, refreshStrategy);
        }
        return CompletableFuture.allOf(futures);
    }
}

