/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.spi;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.spi.BuiltinAnnotations;
import org.hibernate.search.util.common.jar.impl.JandexUtils;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public final class AnnotationScanning {
    private AnnotationScanning() {
    }

    public static Set<DotName> scanForRootMappingAnnotatedTypes(IndexView jandexIndex) {
        HashSet<DotName> rootMappingAnnotations = new HashSet<DotName>(BuiltinAnnotations.ROOT_MAPPING_ANNOTATIONS);
        rootMappingAnnotations.addAll(JandexUtils.findAnnotatedAnnotationsAndContaining((IndexView)jandexIndex, (DotName)BuiltinAnnotations.ROOT_MAPPING));
        HashSet<DotName> rootMappingAnnotatedTypes = new HashSet<DotName>();
        for (DotName annotationName : rootMappingAnnotations) {
            for (AnnotationInstance annotation : jandexIndex.getAnnotations(annotationName)) {
                ClassInfo annotatedClassInfo = JandexUtils.extractDeclaringClass((AnnotationTarget)annotation.target());
                rootMappingAnnotatedTypes.add(annotatedClassInfo.name());
            }
        }
        return rootMappingAnnotatedTypes;
    }
}

