/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.reporting.spi;

import java.lang.annotation.Annotation;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoMethodParameterModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContextMessages;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.util.common.reporting.EventContextElement;
import org.hibernate.search.util.common.reporting.impl.AbstractSimpleEventContextElement;

public final class PojoEventContexts {
    private static final PojoEventContextMessages MESSAGES = PojoEventContextMessages.INSTANCE;

    private PojoEventContexts() {
    }

    public static EventContext fromType(PojoRawTypeModel<?> typeModel) {
        return EventContexts.fromType(typeModel);
    }

    public static EventContext fromType(PojoRawTypeIdentifier<?> typeIdentifier) {
        return EventContexts.fromType(typeIdentifier);
    }

    public static EventContext fromConstructor(PojoConstructorModel<?> constructor) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<PojoConstructorModel<?>>(constructor){

            public String render(PojoConstructorModel<?> constructor) {
                return MESSAGES.constructor(constructor.parametersJavaTypes());
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromMethodParameter(PojoMethodParameterModel<?> parameter) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<PojoMethodParameterModel<?>>(parameter){

            public String render(PojoMethodParameterModel<?> parameter) {
                return MESSAGES.methodParameter(parameter.index(), parameter.name().orElse(MESSAGES.unknownName()));
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromPath(PojoModelPath unboundPath) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<PojoModelPath>(unboundPath){

            public String render(PojoModelPath param) {
                String pathString = param == null ? "" : param.toPathString();
                return MESSAGES.path(pathString);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromAnnotation(Annotation annotation) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<Annotation>(annotation){

            public String render(Annotation annotation) {
                String annotationString = annotation.toString();
                return MESSAGES.annotation(annotationString);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromAnnotationType(Class<? extends Annotation> annotationType) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<Class<? extends Annotation>>(annotationType){

            public String render(Class<? extends Annotation> annotationType) {
                return MESSAGES.annotationType(annotationType);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }
}

