/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.search.projection.definition.spi.CompositeProjectionDefinition;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoSearchMappingCollectorConstructorNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoSearchMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.mapper.pojo.search.definition.impl.PojoConstructorProjectionDefinition;
import org.hibernate.search.mapper.pojo.search.definition.impl.PojoSearchQueryElementRegistry;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class PojoSearchQueryElementRegistryBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoMappingHelper mappingHelper;
    private final Map<Class<?>, CompositeProjectionDefinition<?>> projectionDefinitions = new LinkedHashMap();

    public PojoSearchQueryElementRegistryBuilder(PojoMappingHelper mappingHelper) {
        this.mappingHelper = mappingHelper;
    }

    public <T> PojoSearchMappingCollectorTypeNode type(PojoRawTypeModel<T> type) {
        return new TypeNode<T>(type);
    }

    public PojoSearchQueryElementRegistry build() {
        return new PojoSearchQueryElementRegistry(this.projectionDefinitions);
    }

    private class TypeNode<T>
    implements PojoSearchMappingCollectorTypeNode {
        private final PojoRawTypeModel<T> type;

        public TypeNode(PojoRawTypeModel<T> type) {
            this.type = type;
        }

        @Override
        public ContextualFailureCollector failureCollector() {
            return PojoSearchQueryElementRegistryBuilder.this.mappingHelper.failureCollector().withContext(PojoEventContexts.fromType(this.type));
        }

        @Override
        public PojoRawTypeIdentifier<?> typeIdentifier() {
            return this.type.typeIdentifier();
        }

        @Override
        public PojoSearchMappingCollectorConstructorNode constructor(Class<?>[] parameterTypes) {
            return new ConstructorNode<T>(this.type.constructor(parameterTypes));
        }
    }

    private class ConstructorNode<T>
    implements PojoSearchMappingCollectorConstructorNode {
        private final PojoConstructorModel<T> constructor;

        public ConstructorNode(PojoConstructorModel<T> constructor) {
            this.constructor = constructor;
        }

        @Override
        public ContextualFailureCollector failureCollector() {
            return PojoSearchQueryElementRegistryBuilder.this.mappingHelper.failureCollector().withContext(PojoEventContexts.fromType(this.constructor.typeModel().rawType())).withContext(PojoEventContexts.fromConstructor(this.constructor));
        }

        @Override
        public void projectionConstructor() {
            new PojoConstructorProjectionDefinition.ConstructorNode<T>(PojoSearchQueryElementRegistryBuilder.this.mappingHelper, this.constructor, definition -> {
                PojoRawTypeModel<T> typeModel = this.constructor.typeModel();
                Class<T> instantiatedJavaClass = typeModel.typeIdentifier().javaClass();
                CompositeProjectionDefinition existing = PojoSearchQueryElementRegistryBuilder.this.projectionDefinitions.putIfAbsent(instantiatedJavaClass, definition);
                log.constructorProjection(typeModel, (PojoConstructorProjectionDefinition<?>)definition);
                if (existing != null) {
                    throw log.multipleProjectionConstructorsForType(instantiatedJavaClass);
                }
            }).projectionConstructor();
        }
    }
}

