/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingAssociationInverseSideCollector;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.loading.impl.PojoLoadingPlan;
import org.hibernate.search.mapper.pojo.loading.impl.PojoMultiLoaderLoadingPlan;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorRootContext;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorSessionContext;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.work.impl.AbstractPojoTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoContainedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexingPlanStrategy;
import org.hibernate.search.mapper.pojo.work.impl.PojoLoadingPlanProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoIndexingPlanImpl
implements PojoIndexingPlan,
PojoLoadingPlanProvider,
PojoReindexingCollector,
PojoReindexingAssociationInverseSideCollector,
PojoIndexingProcessorRootContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoWorkTypeContextProvider typeContextProvider;
    private final PojoWorkSessionContext sessionContext;
    private final PojoRuntimeIntrospector introspector;
    private final PojoIndexingPlanStrategy strategy;
    protected final Map<PojoRawTypeIdentifier<?>, PojoIndexedTypeIndexingPlan<?, ?>> indexedTypeDelegates = new LinkedHashMap();
    protected final Map<PojoRawTypeIdentifier<?>, PojoContainedTypeIndexingPlan<?, ?>> containedTypeDelegates = new LinkedHashMap();
    private boolean isProcessing = false;
    private boolean mayRequireLoading = false;
    private PojoLoadingPlan<Object> loadingPlan = null;

    public PojoIndexingPlanImpl(PojoWorkTypeContextProvider typeContextProvider, PojoWorkSessionContext sessionContext, PojoIndexingPlanStrategy strategy) {
        this.typeContextProvider = typeContextProvider;
        this.sessionContext = sessionContext;
        this.introspector = sessionContext.runtimeIntrospector();
        this.strategy = strategy;
    }

    @Override
    public void add(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity) {
        AbstractPojoTypeIndexingPlan<?, ?, ?> delegate = this.getDelegate(typeIdentifier);
        if (!this.mayRequireLoading && entity == null) {
            this.mayRequireLoading = true;
        }
        delegate.add(providedId, providedRoutes, entity);
    }

    @Override
    public void addOrUpdate(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity, boolean forceSelfDirty, boolean forceContainingDirty, BitSet dirtyPaths) {
        AbstractPojoTypeIndexingPlan<?, ?, ?> delegate = this.getDelegate(typeIdentifier);
        if (!this.mayRequireLoading && entity == null) {
            this.mayRequireLoading = true;
        }
        delegate.addOrUpdate(providedId, providedRoutes, entity, dirtyPaths, forceSelfDirty, forceContainingDirty);
    }

    @Override
    public void delete(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity) {
        AbstractPojoTypeIndexingPlan<?, ?, ?> delegate = this.getDelegate(typeIdentifier);
        delegate.delete(providedId, providedRoutes, entity);
    }

    @Override
    public void addOrUpdateOrDelete(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, DocumentRoutesDescriptor providedRoutes, boolean forceSelfDirty, boolean forceContainingDirty, BitSet dirtyPaths) {
        AbstractPojoTypeIndexingPlan<?, ?, ?> delegate = this.getDelegate(typeIdentifier);
        if (!this.mayRequireLoading) {
            this.mayRequireLoading = true;
        }
        delegate.addOrUpdateOrDelete(providedId, providedRoutes, dirtyPaths, forceSelfDirty, forceContainingDirty);
    }

    @Override
    public void updateAssociationInverseSide(PojoRawTypeIdentifier<?> typeIdentifier, BitSet dirtyAssociationPaths, Object[] oldState, Object[] newState) {
        AbstractPojoTypeIndexingPlan<?, ?, ?> delegate = this.getDelegate(typeIdentifier);
        delegate.resolveDirtyAssociationInverseSide(this, dirtyAssociationPaths, oldState, newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        if (this.isProcessing) {
            throw log.recursiveIndexingPlanProcess();
        }
        this.isProcessing = true;
        try {
            if (this.mayRequireLoading) {
                for (PojoContainedTypeIndexingPlan<?, ?> pojoContainedTypeIndexingPlan : this.containedTypeDelegates.values()) {
                    pojoContainedTypeIndexingPlan.planLoading(this);
                }
                for (PojoIndexedTypeIndexingPlan pojoIndexedTypeIndexingPlan : this.indexedTypeDelegates.values()) {
                    pojoIndexedTypeIndexingPlan.planLoading(this);
                }
            }
            if (this.loadingPlan != null) {
                this.loadingPlan.loadBlocking(null);
            }
            boolean shouldResolveDirtyForDeleteOnly = this.strategy.shouldResolveDirtyForDeleteOnly();
            for (PojoContainedTypeIndexingPlan<?, ?> pojoContainedTypeIndexingPlan : this.containedTypeDelegates.values()) {
                pojoContainedTypeIndexingPlan.resolveDirty(this, this, shouldResolveDirtyForDeleteOnly);
            }
            ArrayList arrayList = new ArrayList(this.indexedTypeDelegates.values());
            for (PojoIndexedTypeIndexingPlan pojoIndexedTypeIndexingPlan : arrayList) {
                pojoIndexedTypeIndexingPlan.resolveDirty(this, this, shouldResolveDirtyForDeleteOnly);
            }
            for (PojoContainedTypeIndexingPlan<?, ?> pojoContainedTypeIndexingPlan : this.containedTypeDelegates.values()) {
                pojoContainedTypeIndexingPlan.process(this);
            }
            for (PojoIndexedTypeIndexingPlan<?, ?> pojoIndexedTypeIndexingPlan : this.indexedTypeDelegates.values()) {
                pojoIndexedTypeIndexingPlan.process(this);
            }
        }
        finally {
            this.isProcessing = false;
            this.mayRequireLoading = false;
            this.loadingPlan = null;
            this.clearStates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> CompletableFuture<MultiEntityOperationExecutionReport<R>> executeAndReport(EntityReferenceFactory<R> entityReferenceFactory, OperationSubmitter operationSubmitter) {
        try {
            this.process();
            CompletableFuture<MultiEntityOperationExecutionReport<R>> completableFuture = this.strategy.doExecuteAndReport(this.indexedTypeDelegates.values(), this, entityReferenceFactory, operationSubmitter);
            return completableFuture;
        }
        finally {
            this.indexedTypeDelegates.clear();
        }
    }

    @Override
    public void discard() {
        try {
            this.strategy.doDiscard(this.indexedTypeDelegates.values());
        }
        finally {
            this.indexedTypeDelegates.clear();
            this.containedTypeDelegates.clear();
        }
    }

    @Override
    public void discardNotProcessed() {
        this.clearStates();
    }

    private void clearStates() {
        for (PojoIndexedTypeIndexingPlan<?, ?> pojoIndexedTypeIndexingPlan : this.indexedTypeDelegates.values()) {
            pojoIndexedTypeIndexingPlan.clearStates();
        }
        for (PojoContainedTypeIndexingPlan pojoContainedTypeIndexingPlan : this.containedTypeDelegates.values()) {
            pojoContainedTypeIndexingPlan.clearStates();
        }
    }

    @Override
    public void updateBecauseOfContained(PojoRawTypeIdentifier<?> typeIdentifier, Object containingEntity) {
        PojoIndexedTypeIndexingPlan<?, ?> delegate = this.getOrCreateIndexedDelegateForContainedUpdate(typeIdentifier);
        delegate.updateBecauseOfContained(containingEntity);
    }

    @Override
    public void updateBecauseOfContainedAssociation(PojoRawTypeIdentifier<?> typeIdentifier, Object containingEntity, int dirtyAssociationPathOrdinal) {
        AbstractPojoTypeIndexingPlan<?, ?, ?> delegate = this.getDelegate(typeIdentifier);
        delegate.updateBecauseOfContainedAssociation(containingEntity, dirtyAssociationPathOrdinal);
    }

    @Override
    public PojoIndexingProcessorSessionContext sessionContext() {
        return this.sessionContext;
    }

    @Override
    public boolean isDeleted(Object unproxiedObject) {
        PojoRawTypeIdentifier<Object> typeIdentifier = this.introspector.detectEntityType(unproxiedObject);
        if (typeIdentifier == null) {
            return false;
        }
        AbstractPojoTypeIndexingPlan<?, ?, ?> delegate = this.getDelegateOrNull(typeIdentifier);
        if (delegate == null) {
            return false;
        }
        return delegate.isDeleted(unproxiedObject);
    }

    private AbstractPojoTypeIndexingPlan<?, ?, ?> getDelegate(PojoRawTypeIdentifier<?> typeIdentifier) {
        AbstractPojoTypeIndexingPlan<?, ?, ?> delegate = this.getDelegateOrNull(typeIdentifier);
        if (delegate == null) {
            delegate = this.createDelegate(typeIdentifier);
        }
        return delegate;
    }

    private AbstractPojoTypeIndexingPlan<?, ?, ?> getDelegateOrNull(PojoRawTypeIdentifier<?> typeIdentifier) {
        AbstractPojoTypeIndexingPlan delegate = this.indexedTypeDelegates.get(typeIdentifier);
        if (delegate == null) {
            delegate = this.containedTypeDelegates.get(typeIdentifier);
        }
        return delegate;
    }

    private AbstractPojoTypeIndexingPlan<?, ?, ?> createDelegate(PojoRawTypeIdentifier<?> typeIdentifier) {
        PojoWorkTypeContext<?, ?> typeContext = this.typeContextProvider.forExactType(typeIdentifier);
        Optional<PojoWorkIndexedTypeContext<?, ?>> indexedTypeContextOptional = typeContext.asIndexed();
        if (indexedTypeContextOptional.isPresent()) {
            PojoWorkIndexedTypeContext<?, ?> indexedTypeContext = indexedTypeContextOptional.get();
            PojoIndexedTypeIndexingPlan<?, ?> delegate = this.createDelegate(indexedTypeContext);
            this.indexedTypeDelegates.put(typeIdentifier, delegate);
            return delegate;
        }
        PojoWorkContainedTypeContext<?, ?> containedTypeContext = typeContext.asContained().orElseThrow(() -> new AssertionFailure("Type is neither indexed nor contained"));
        PojoContainedTypeIndexingPlan<?, ?> delegate = this.createDelegate(containedTypeContext);
        this.containedTypeDelegates.put(typeIdentifier, delegate);
        return delegate;
    }

    private PojoIndexedTypeIndexingPlan<?, ?> getOrCreateIndexedDelegateForContainedUpdate(PojoRawTypeIdentifier<?> typeIdentifier) {
        PojoIndexedTypeIndexingPlan<?, ?> delegate = this.indexedTypeDelegates.get(typeIdentifier);
        if (delegate != null) {
            return delegate;
        }
        PojoWorkIndexedTypeContext<?, ?> typeContext = this.typeContextProvider.indexedForExactType(typeIdentifier);
        delegate = this.createDelegate(typeContext);
        this.indexedTypeDelegates.put(typeIdentifier, delegate);
        return delegate;
    }

    @Override
    public PojoLoadingPlan<Object> loadingPlan() {
        if (this.loadingPlan == null) {
            this.loadingPlan = new PojoMultiLoaderLoadingPlan<Object>(this.sessionContext.defaultLoadingContext());
        }
        return this.loadingPlan;
    }

    private <I, E> PojoIndexedTypeIndexingPlan<I, E> createDelegate(PojoWorkIndexedTypeContext<I, E> typeContext) {
        return this.strategy.createIndexedDelegate(typeContext, this.sessionContext, this);
    }

    private PojoContainedTypeIndexingPlan<?, ?> createDelegate(PojoWorkContainedTypeContext<?, ?> typeContext) {
        return this.strategy.createDelegate(typeContext, this.sessionContext);
    }
}

