/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeMappingContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkspace;

public class PojoScopeWorkspaceImpl
implements PojoScopeWorkspace {
    private final List<IndexWorkspace> delegates = new ArrayList<IndexWorkspace>();

    public PojoScopeWorkspaceImpl(PojoScopeMappingContext mappingContext, Set<? extends PojoWorkIndexedTypeContext<?, ?>> targetedTypeContexts, String tenantId) {
        for (PojoWorkIndexedTypeContext<?, ?> targetedTypeContext : targetedTypeContexts) {
            this.delegates.add(targetedTypeContext.createWorkspace(mappingContext, tenantId));
        }
    }

    @Override
    public CompletableFuture<?> mergeSegments(OperationSubmitter operationSubmitter) {
        return this.doOperationOnTypes(IndexWorkspace::mergeSegments, operationSubmitter);
    }

    @Override
    public CompletableFuture<?> purge(Set<String> routingKeys, OperationSubmitter operationSubmitter) {
        return this.doOperationOnTypes((indexWorkspace, submitter) -> indexWorkspace.purge(routingKeys, submitter), operationSubmitter);
    }

    @Override
    public CompletableFuture<?> flush(OperationSubmitter operationSubmitter) {
        return this.doOperationOnTypes(IndexWorkspace::flush, operationSubmitter);
    }

    @Override
    public CompletableFuture<?> refresh(OperationSubmitter operationSubmitter) {
        return this.doOperationOnTypes(IndexWorkspace::refresh, operationSubmitter);
    }

    private CompletableFuture<?> doOperationOnTypes(BiFunction<IndexWorkspace, OperationSubmitter, CompletableFuture<?>> operation, OperationSubmitter operationSubmitter) {
        CompletableFuture[] futures = new CompletableFuture[this.delegates.size()];
        int typeCounter = 0;
        for (IndexWorkspace delegate : this.delegates) {
            futures[typeCounter++] = operation.apply(delegate, operationSubmitter);
        }
        return CompletableFuture.allOf(futures);
    }
}

