/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.spi;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategyConfigurationContext;
import org.hibernate.search.mapper.pojo.work.SearchIndexingPlanExecutionReport;
import org.hibernate.search.mapper.pojo.work.impl.DelegatingSearchIndexingPlanExecutionReport;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.impl.Contracts;

@Incubating
public class ConfiguredIndexingPlanSynchronizationStrategy<E> {
    private final DocumentCommitStrategy documentCommitStrategy;
    private final DocumentRefreshStrategy documentRefreshStrategy;
    private final Consumer<? super CompletableFuture<? extends SearchIndexingPlanExecutionReport>> indexingFutureHandler;
    private final OperationSubmitter operationSubmitter;
    private final EntityReferenceFactory<E> entityReferenceFactory;

    protected ConfiguredIndexingPlanSynchronizationStrategy(Builder<E> configurationContext) {
        this.documentCommitStrategy = ((Builder)configurationContext).documentCommitStrategy;
        this.documentRefreshStrategy = ((Builder)configurationContext).documentRefreshStrategy;
        this.indexingFutureHandler = ((Builder)configurationContext).indexingFutureHandler;
        this.operationSubmitter = ((Builder)configurationContext).operationSubmitter;
        this.entityReferenceFactory = ((Builder)configurationContext).entityReferenceFactory;
    }

    public DocumentCommitStrategy documentCommitStrategy() {
        return this.documentCommitStrategy;
    }

    public DocumentRefreshStrategy documentRefreshStrategy() {
        return this.documentRefreshStrategy;
    }

    public void executeAndSynchronize(PojoIndexingPlan indexingPlan) {
        CompletionStage reportFuture = indexingPlan.executeAndReport(this.entityReferenceFactory, this.operationSubmitter).thenApply(DelegatingSearchIndexingPlanExecutionReport::new);
        this.indexingFutureHandler.accept((CompletableFuture<? extends SearchIndexingPlanExecutionReport>)reportFuture);
    }

    public static final class Builder<E>
    implements IndexingPlanSynchronizationStrategyConfigurationContext {
        private final FailureHandler failureHandler;
        private DocumentCommitStrategy documentCommitStrategy = DocumentCommitStrategy.NONE;
        private DocumentRefreshStrategy documentRefreshStrategy = DocumentRefreshStrategy.NONE;
        private Consumer<? super CompletableFuture<? extends SearchIndexingPlanExecutionReport>> indexingFutureHandler = future -> {};
        private OperationSubmitter operationSubmitter = OperationSubmitter.blocking();
        private final EntityReferenceFactory<E> entityReferenceFactory;

        public Builder(FailureHandler failureHandler, EntityReferenceFactory<E> entityReferenceFactory) {
            this.failureHandler = failureHandler;
            this.entityReferenceFactory = entityReferenceFactory;
        }

        @Override
        public void documentCommitStrategy(DocumentCommitStrategy strategy) {
            Contracts.assertNotNull((Object)strategy, (String)"strategy");
            this.documentCommitStrategy = strategy;
        }

        @Override
        public void documentRefreshStrategy(DocumentRefreshStrategy strategy) {
            Contracts.assertNotNull((Object)strategy, (String)"strategy");
            this.documentRefreshStrategy = strategy;
        }

        @Override
        public void indexingFutureHandler(Consumer<? super CompletableFuture<? extends SearchIndexingPlanExecutionReport>> handler) {
            Contracts.assertNotNull(handler, (String)"handler");
            this.indexingFutureHandler = handler;
        }

        @Override
        public FailureHandler failureHandler() {
            return this.failureHandler;
        }

        @Override
        public void operationSubmitter(OperationSubmitter operationSubmitter) {
            this.operationSubmitter = operationSubmitter;
        }

        public ConfiguredIndexingPlanSynchronizationStrategy<E> build() {
            return new ConfiguredIndexingPlanSynchronizationStrategy(this);
        }
    }
}

