/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.IndexedEmbedded;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessorContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStep;

public class IndexedEmbeddedProcessor
implements PropertyMappingAnnotationProcessor<IndexedEmbedded> {
    @Override
    public void process(PropertyMappingStep mappingContext, IndexedEmbedded annotation, PropertyMappingAnnotationProcessorContext context) {
        Set<String> cleanedUpIncludePaths;
        String cleanedUpPrefix = context.toNullIfDefault(annotation.prefix(), "");
        String cleanedUpName = context.toNullIfDefault(annotation.name(), "");
        Integer cleanedUpIncludeDepth = context.toNullIfDefault(annotation.includeDepth(), -1);
        String[] includePathsArray = annotation.includePaths();
        if (includePathsArray.length > 0) {
            cleanedUpIncludePaths = new HashSet();
            Collections.addAll(cleanedUpIncludePaths, includePathsArray);
        } else {
            cleanedUpIncludePaths = Collections.emptySet();
        }
        ContainerExtractorPath extractorPath = context.toContainerExtractorPath(annotation.extraction());
        Class<Void> cleanedUpTargetType = context.toNullIfDefault(annotation.targetType(), Void.TYPE);
        ObjectStructure structure = annotation.structure();
        mappingContext.indexedEmbedded(cleanedUpName).extractors(extractorPath).prefix(cleanedUpPrefix).structure(structure).includeDepth(cleanedUpIncludeDepth).includePaths(cleanedUpIncludePaths).includeEmbeddedObjectId(annotation.includeEmbeddedObjectId()).targetType(cleanedUpTargetType);
    }
}

