/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.search.projection.definition.ProjectionDefinition;
import org.hibernate.search.engine.search.projection.definition.spi.CompositeProjectionDefinition;
import org.hibernate.search.engine.search.projection.definition.spi.ObjectProjectionDefinition;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.model.PojoModelConstructorParameter;
import org.hibernate.search.mapper.pojo.model.PojoModelValue;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelConstructorParameterRootElement;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelValueElement;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingContext;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingMultiContext;
import org.hibernate.search.mapper.pojo.search.definition.binding.impl.ProjectionConstructorParameterBinder;
import org.hibernate.search.mapper.pojo.search.definition.impl.PojoConstructorProjectionDefinition;
import org.hibernate.search.util.common.impl.AbstractCloser;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ProjectionBindingContextImpl<P>
implements ProjectionBindingContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoMappingHelper mappingHelper;
    private final ProjectionConstructorParameterBinder<P> parameterBinder;
    private final Map<String, Object> params;
    private final PojoTypeModel<?> parameterTypeModel;
    private final PojoModelConstructorParameterRootElement<P> parameterRootElement;
    private PartialBinding<P> partialBinding;

    public ProjectionBindingContextImpl(ProjectionConstructorParameterBinder<P> parameterBinder, Map<String, Object> params) {
        this.mappingHelper = parameterBinder.mappingHelper;
        this.parameterBinder = parameterBinder;
        this.params = params;
        this.parameterTypeModel = parameterBinder.parameter.typeModel();
        this.parameterRootElement = parameterBinder.parameterRootElement;
    }

    @Override
    public BeanResolver beanResolver() {
        return this.mappingHelper.beanResolver();
    }

    @Override
    public Object param(String name) {
        Object value = this.params.get(name);
        if (value == null) {
            throw log.paramNotDefined(name);
        }
        return value;
    }

    @Override
    public Optional<Object> paramOptional(String name) {
        return Optional.ofNullable(this.params.get(name));
    }

    public <P2> void definition(Class<P2> expectedValueType, ProjectionDefinition<? extends P2> definition) {
        this.definition(expectedValueType, (BeanHolder<? extends ProjectionDefinition<? extends P2>>)BeanHolder.of(definition));
    }

    public <P2> void definition(Class<P2> expectedValueType, BeanHolder<? extends ProjectionDefinition<? extends P2>> definitionHolder) {
        this.checkAndBind(definitionHolder, this.mappingHelper.introspector().typeModel(expectedValueType));
    }

    public Optional<MultiContextImpl<?>> multi() {
        BoundContainerExtractorPath<?, ?> boundParameterElementPath = this.mappingHelper.indexModelBinder().bindExtractorPath(this.parameterTypeModel, ContainerExtractorPath.defaultExtractors());
        List<String> boundParameterElementExtractorNames = boundParameterElementPath.getExtractorPath().explicitExtractorNames();
        if (boundParameterElementExtractorNames.isEmpty()) {
            return Optional.empty();
        }
        if (boundParameterElementExtractorNames.size() > 1 || !"collection".equals(boundParameterElementExtractorNames.get(0)) && !"iterable".equals(boundParameterElementExtractorNames.get(0)) || !this.mappingHelper.introspector().typeModel(List.class).isSubTypeOf(this.parameterTypeModel.rawType())) {
            throw log.invalidMultiValuedParameterTypeForProjectionConstructor(this.parameterTypeModel);
        }
        return Optional.of(new MultiContextImpl(boundParameterElementPath.getExtractedType()));
    }

    @Override
    public PojoModelConstructorParameter constructorParameter() {
        return this.parameterRootElement;
    }

    @Override
    public <T> BeanHolder<? extends ProjectionDefinition<T>> createObjectDefinition(String fieldPath, Class<T> projectedType) {
        CompositeProjectionDefinition<T> composite = this.createCompositeProjectionDefinition(projectedType);
        try {
            return BeanHolder.ofCloseable((AutoCloseable)new ObjectProjectionDefinition.SingleValued(fieldPath, composite));
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(composite);
            throw e;
        }
    }

    @Override
    public <T> BeanHolder<? extends ProjectionDefinition<List<T>>> createObjectDefinitionMulti(String fieldPath, Class<T> projectedType) {
        CompositeProjectionDefinition<T> composite = this.createCompositeProjectionDefinition(projectedType);
        try {
            return BeanHolder.ofCloseable((AutoCloseable)new ObjectProjectionDefinition.MultiValued(fieldPath, composite));
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(composite);
            throw e;
        }
    }

    @Override
    public <T> BeanHolder<? extends ProjectionDefinition<T>> createCompositeDefinition(Class<T> projectedType) {
        return BeanHolder.ofCloseable(this.createCompositeProjectionDefinition(projectedType));
    }

    private <T> CompositeProjectionDefinition<T> createCompositeProjectionDefinition(Class<T> projectedType) {
        PojoConstructorProjectionDefinition<T> composite = this.parameterBinder.createConstructorProjectionDefinitionOrNull(this.mappingHelper.introspector().typeModel(projectedType));
        if (composite == null) {
            throw log.invalidObjectClassForProjection(projectedType);
        }
        return composite;
    }

    public BeanHolder<? extends ProjectionDefinition<? extends P>> applyBinder(ProjectionBinder binder) {
        try {
            binder.bind(this);
            if (this.partialBinding == null) {
                throw log.missingProjectionDefinitionForBinder(binder);
            }
            BeanHolder<ProjectionDefinition<P>> beanHolder = this.partialBinding.complete();
            return beanHolder;
        }
        catch (RuntimeException e) {
            if (this.partialBinding != null) {
                this.partialBinding.abort((AbstractCloser<?, ?>)new SuppressingCloser((Throwable)e));
            }
            throw e;
        }
        finally {
            this.partialBinding = null;
        }
    }

    private <P2> void checkAndBind(BeanHolder<? extends ProjectionDefinition<? extends P2>> definitionHolder, PojoRawTypeModel<P2> expectedValueType) {
        if (!expectedValueType.isSubTypeOf(this.parameterTypeModel.rawType())) {
            throw log.invalidOutputTypeForProjectionDefinition(definitionHolder.get(), this.parameterTypeModel, expectedValueType);
        }
        BeanHolder<? extends ProjectionDefinition<? extends P2>> castDefinitionHolder = definitionHolder;
        this.partialBinding = new PartialBinding(castDefinitionHolder);
    }

    private static class PartialBinding<P> {
        private final BeanHolder<? extends ProjectionDefinition<? extends P>> definitionHolder;

        private PartialBinding(BeanHolder<? extends ProjectionDefinition<? extends P>> definitionHolder) {
            this.definitionHolder = definitionHolder;
        }

        void abort(AbstractCloser<?, ?> closer) {
            closer.push(BeanHolder::close, this.definitionHolder);
        }

        BeanHolder<? extends ProjectionDefinition<? extends P>> complete() {
            return this.definitionHolder;
        }
    }

    public class MultiContextImpl<PV>
    implements ProjectionBindingMultiContext {
        public final PojoTypeModel<PV> parameterContainerElementTypeModel;
        private final PojoModelValue<PV> parameterContainerElementRootElement;

        public MultiContextImpl(PojoTypeModel<PV> parameterContainerElementTypeModel) {
            this.parameterContainerElementTypeModel = parameterContainerElementTypeModel;
            this.parameterContainerElementRootElement = new PojoModelValueElement<PV>(ProjectionBindingContextImpl.this.mappingHelper.introspector(), parameterContainerElementTypeModel);
        }

        public <P2> void definition(Class<P2> expectedValueType, ProjectionDefinition<? extends List<? extends P2>> definition) {
            this.definition(expectedValueType, (BeanHolder<? extends ProjectionDefinition<? extends List<? extends P2>>>)BeanHolder.of(definition));
        }

        public <P2> void definition(Class<P2> expectedValueType, BeanHolder<? extends ProjectionDefinition<? extends List<? extends P2>>> definitionHolder) {
            this.checkAndBind(definitionHolder, ProjectionBindingContextImpl.this.mappingHelper.introspector().typeModel(expectedValueType));
        }

        @Override
        public PojoModelValue<?> containerElement() {
            return this.parameterContainerElementRootElement;
        }

        private <P2> void checkAndBind(BeanHolder<? extends ProjectionDefinition<? extends List<? extends P2>>> definitionHolder, PojoRawTypeModel<P2> expectedValueType) {
            if (!expectedValueType.isSubTypeOf(this.parameterContainerElementTypeModel.rawType())) {
                throw log.invalidOutputTypeForMultiValuedProjectionDefinition(definitionHolder.get(), ProjectionBindingContextImpl.this.parameterTypeModel, expectedValueType);
            }
            BeanHolder<? extends ProjectionDefinition<? extends List<? extends P2>>> castDefinitionHolder = definitionHolder;
            ProjectionBindingContextImpl.this.partialBinding = new PartialBinding(castDefinitionHolder);
        }
    }
}

