/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.hcann.spi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaXMember;
import org.hibernate.search.util.common.AssertionFailure;

public class PojoCommonsAnnotationsHelper {
    private static final Method getMemberMethod;

    private PojoCommonsAnnotationsHelper() {
    }

    public static Member extractUnderlyingMember(XProperty xProperty) {
        try {
            return (Member)getMemberMethod.invoke((Object)xProperty, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new AssertionFailure("Could not resolve member signature from XProperty reference", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionFailure("Could not resolve member signature from XProperty reference", e.getCause());
        }
    }

    static {
        Class<JavaXMember> javaXMemberClass = JavaXMember.class;
        try {
            getMemberMethod = javaXMemberClass.getDeclaredMethod("getMember", new Class[0]);
            getMemberMethod.setAccessible(true);
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not resolve JavaXMember#getMember method in order to extract Java Member from XProperty", (Throwable)e);
        }
    }
}

