/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.extractor.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractor;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.ChainingContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.extractor.impl.SingleContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.spi.ContainerExtractorDefinition;
import org.hibernate.search.mapper.pojo.extractor.spi.ContainerExtractorRegistry;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.ExtractingTypePatternMatcher;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcherFactory;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.impl.GenericTypeContext;

public class ContainerExtractorBinder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanResolver beanResolver;
    private final ContainerExtractorRegistry containerExtractorRegistry;
    private final TypePatternMatcherFactory typePatternMatcherFactory;
    private final FirstMatchingExtractorContributor firstMatchingExtractorContributor = new FirstMatchingExtractorContributor();
    private final Map<String, SingleExtractorContributor> extractorContributorCache = new HashMap<String, SingleExtractorContributor>();

    public ContainerExtractorBinder(BeanResolver beanResolver, ContainerExtractorRegistry containerExtractorRegistry, TypePatternMatcherFactory typePatternMatcherFactory) {
        this.beanResolver = beanResolver;
        this.containerExtractorRegistry = containerExtractorRegistry;
        this.typePatternMatcherFactory = typePatternMatcherFactory;
        for (String extractorName : containerExtractorRegistry.defaults()) {
            this.addDefaultExtractor(extractorName);
        }
    }

    public <C> Optional<BoundContainerExtractorPath<C, ?>> tryBindPath(PojoTypeModel<C> sourceType, ContainerExtractorPath extractorPath) {
        ExtractorResolutionState<C> state = new ExtractorResolutionState<C>(sourceType);
        if (extractorPath.isDefault()) {
            this.firstMatchingExtractorContributor.tryAppend(state);
        } else {
            for (String extractorName : extractorPath.explicitExtractorNames()) {
                SingleExtractorContributor extractorContributor = this.getExtractorContributorForName(extractorName);
                if (extractorContributor.tryAppend(state)) continue;
                return Optional.empty();
            }
        }
        return Optional.of(state.build());
    }

    public <C> BoundContainerExtractorPath<C, ?> bindPath(PojoTypeModel<C> sourceType, ContainerExtractorPath extractorPath) {
        ExtractorResolutionState<C> state = new ExtractorResolutionState<C>(sourceType);
        if (extractorPath.isDefault()) {
            this.firstMatchingExtractorContributor.tryAppend(state);
        } else {
            for (String extractorName : extractorPath.explicitExtractorNames()) {
                SingleExtractorContributor extractorContributor = this.getExtractorContributorForName(extractorName);
                extractorContributor.append(state);
            }
        }
        return state.build();
    }

    public <C, V> ContainerExtractorHolder<C, V> create(BoundContainerExtractorPath<C, V> boundPath) {
        if (boundPath.getExtractorPath().isEmpty()) {
            throw new AssertionFailure("Received a request to create extractors, but the extractor path was empty.");
        }
        ContainerExtractorHolder extractorHolder = null;
        ArrayList<BeanHolder> beanHolders = new ArrayList<BeanHolder>();
        try {
            for (String extractorName : boundPath.getExtractorPath().explicitExtractorNames()) {
                ContainerExtractorDefinition<?> extractorDefinition = this.containerExtractorRegistry.forName(extractorName);
                BeanHolder newExtractorHolder = extractorDefinition.reference().resolve(this.beanResolver);
                beanHolders.add(newExtractorHolder);
                if (extractorHolder == null) {
                    extractorHolder = new SingleContainerExtractorHolder(newExtractorHolder);
                    continue;
                }
                extractorHolder = new ChainingContainerExtractorHolder(extractorHolder, newExtractorHolder);
            }
            return extractorHolder;
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(BeanHolder::close, beanHolders);
            throw e;
        }
    }

    public boolean isDefaultExtractorPath(PojoTypeModel<?> sourceType, ContainerExtractorPath extractorPath) {
        Optional<BoundContainerExtractorPath<?, ?>> boundDefaultExtractorPathOptional = this.tryBindPath(sourceType, ContainerExtractorPath.defaultExtractors());
        return boundDefaultExtractorPathOptional.isPresent() && extractorPath.equals(boundDefaultExtractorPathOptional.get().getExtractorPath());
    }

    private void addDefaultExtractor(String extractorName) {
        SingleExtractorContributor extractorContributor = this.getExtractorContributorForName(extractorName);
        this.firstMatchingExtractorContributor.addCandidate(extractorContributor);
    }

    private SingleExtractorContributor getExtractorContributorForName(String extractorName) {
        return this.extractorContributorCache.computeIfAbsent(extractorName, this::createExtractorContributorForName);
    }

    private SingleExtractorContributor createExtractorContributorForName(String extractorName) {
        ExtractingTypePatternMatcher typePatternMatcher;
        Class<?> extractorClass = this.containerExtractorRegistry.forName(extractorName).type();
        GenericTypeContext typeContext = new GenericTypeContext(extractorClass);
        Type typePattern = (Type)typeContext.resolveTypeArgument(ContainerExtractor.class, 0).orElseThrow(() -> log.cannotInferContainerExtractorClassTypePattern(extractorClass, null));
        Type typeToExtract = (Type)typeContext.resolveTypeArgument(ContainerExtractor.class, 1).orElseThrow(() -> log.cannotInferContainerExtractorClassTypePattern(extractorClass, null));
        try {
            typePatternMatcher = this.typePatternMatcherFactory.createExtractingMatcher(typePattern, typeToExtract);
        }
        catch (UnsupportedOperationException e) {
            throw log.cannotInferContainerExtractorClassTypePattern(extractorClass, e);
        }
        return new SingleExtractorContributor(typePatternMatcher, extractorName, extractorClass);
    }

    private static class FirstMatchingExtractorContributor
    implements ExtractorContributor {
        private final List<ExtractorContributor> candidates = new ArrayList<ExtractorContributor>();

        private FirstMatchingExtractorContributor() {
        }

        void addCandidate(ExtractorContributor contributor) {
            this.candidates.add(contributor);
        }

        @Override
        public boolean tryAppend(ExtractorResolutionState<?> state) {
            for (ExtractorContributor extractorContributor : this.candidates) {
                if (!extractorContributor.tryAppend(state)) continue;
                this.tryAppend(state);
                return true;
            }
            return false;
        }
    }

    private static class ExtractorResolutionState<C> {
        private final List<String> extractorNames = new ArrayList<String>();
        private PojoTypeModel<?> extractedType;

        ExtractorResolutionState(PojoTypeModel<C> sourceType) {
            this.extractedType = sourceType;
        }

        void append(String extractorName, PojoTypeModel<?> extractedType) {
            this.extractorNames.add(extractorName);
            this.extractedType = extractedType;
        }

        BoundContainerExtractorPath<C, ?> build() {
            return new BoundContainerExtractorPath(ContainerExtractorPath.explicitExtractors(this.extractorNames), this.extractedType);
        }
    }

    private static class SingleExtractorContributor
    implements ExtractorContributor {
        private final ExtractingTypePatternMatcher typePatternMatcher;
        private final String extractorName;
        private final Class<? extends ContainerExtractor> extractorClass;

        SingleExtractorContributor(ExtractingTypePatternMatcher typePatternMatcher, String extractorName, Class<? extends ContainerExtractor> extractorClass) {
            this.typePatternMatcher = typePatternMatcher;
            this.extractorName = extractorName;
            this.extractorClass = extractorClass;
        }

        @Override
        public boolean tryAppend(ExtractorResolutionState<?> state) {
            Optional<PojoTypeModel<?>> resultTypeOptional = this.typePatternMatcher.extract(state.extractedType);
            if (resultTypeOptional.isPresent()) {
                state.append(this.extractorName, resultTypeOptional.get());
                return true;
            }
            return false;
        }

        void append(ExtractorResolutionState<?> state) {
            if (!this.tryAppend(state)) {
                throw log.invalidContainerExtractorForType(this.extractorName, this.extractorClass, state.extractedType);
            }
        }
    }

    private static interface ExtractorContributor {
        public boolean tryAppend(ExtractorResolutionState<?> var1);
    }
}

