/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.binding.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.mapper.pojo.bridge.binding.BindingContext;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractBindingContext
implements BindingContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanResolver beanResolver;
    private final Map<String, Object> params;

    AbstractBindingContext(BeanResolver beanResolver, Map<String, Object> params) {
        this.beanResolver = beanResolver;
        this.params = params;
    }

    @Override
    public BeanResolver beanResolver() {
        return this.beanResolver;
    }

    @Override
    public <T> T param(String name, Class<T> paramType) {
        Contracts.assertNotNull((Object)name, (String)"name");
        Contracts.assertNotNull(paramType, (String)"paramType");
        Object value = this.params.get(name);
        if (value == null) {
            throw log.paramNotDefined(name);
        }
        return paramType.cast(value);
    }

    @Override
    public <T> Optional<T> paramOptional(String name, Class<T> paramType) {
        Contracts.assertNotNull((Object)name, (String)"name");
        Contracts.assertNotNull(paramType, (String)"paramType");
        return Optional.ofNullable(this.params.get(name)).map(paramType::cast);
    }
}

