/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.binding.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEntityBindingContext;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.IdentifierBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.AbstractBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.PojoIdentifierBridgeDocumentValueConverter;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.PojoIdentifierBridgeParseConverter;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.PojoModelValue;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelValueElement;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.impl.AbstractCloser;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class DefaultIdentifierBindingContext<I>
extends AbstractBindingContext
implements IdentifierBindingContext<I> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoBootstrapIntrospector introspector;
    private final Optional<IndexedEntityBindingContext> indexedEntityBindingContext;
    private final PojoTypeModel<I> identifierTypeModel;
    private final PojoModelValue<I> bridgedElement;
    private PartialBinding<I> partialBinding;

    public DefaultIdentifierBindingContext(BeanResolver beanResolver, PojoBootstrapIntrospector introspector, Optional<IndexedEntityBindingContext> indexedEntityBindingContext, PojoTypeModel<I> valueTypeModel, Map<String, Object> params) {
        super(beanResolver, params);
        this.introspector = introspector;
        this.indexedEntityBindingContext = indexedEntityBindingContext;
        this.identifierTypeModel = valueTypeModel;
        this.bridgedElement = new PojoModelValueElement<I>(introspector, valueTypeModel);
    }

    @Override
    public <I2> void bridge(Class<I2> expectedValueType, IdentifierBridge<I2> bridge) {
        this.bridge(expectedValueType, BeanHolder.of(bridge));
    }

    @Override
    public <I2> void bridge(Class<I2> expectedValueType, BeanHolder<? extends IdentifierBridge<I2>> bridgeHolder) {
        PojoRawTypeModel<I2> expectedValueTypeModel = this.introspector.typeModel(expectedValueType);
        try {
            if (!this.identifierTypeModel.rawType().equals(expectedValueTypeModel)) {
                throw log.invalidInputTypeForBridge(bridgeHolder.get(), this.identifierTypeModel, expectedValueTypeModel);
            }
            BeanHolder<? extends IdentifierBridge<I2>> castedBridgeHolder = bridgeHolder;
            Class<I2> castedExpectedType = expectedValueType;
            this.partialBinding = new PartialBinding<I2>(castedBridgeHolder, castedExpectedType);
        }
        catch (RuntimeException e) {
            DefaultIdentifierBindingContext.abortBridge(new SuppressingCloser((Throwable)e), bridgeHolder);
            throw e;
        }
    }

    @Override
    public PojoModelValue<I> bridgedElement() {
        return this.bridgedElement;
    }

    public BoundIdentifierBridge<I> applyBinder(IdentifierBinder binder) {
        try {
            binder.bind(this);
            if (this.partialBinding == null) {
                throw log.missingBridgeForBinder(binder);
            }
            BoundIdentifierBridge<I> boundIdentifierBridge = this.partialBinding.complete(this.indexedEntityBindingContext);
            return boundIdentifierBridge;
        }
        catch (RuntimeException e) {
            if (this.partialBinding != null) {
                this.partialBinding.abort((AbstractCloser<?, ?>)new SuppressingCloser((Throwable)e));
            }
            throw e;
        }
        finally {
            this.partialBinding = null;
        }
    }

    private static void abortBridge(AbstractCloser<?, ?> closer, BeanHolder<? extends IdentifierBridge<?>> bridgeHolder) {
        closer.push(IdentifierBridge::close, bridgeHolder, BeanHolder::get);
        closer.push(BeanHolder::close, bridgeHolder);
    }

    private static class PartialBinding<I> {
        private final BeanHolder<? extends IdentifierBridge<I>> bridgeHolder;
        private final Class<I> expectedValueType;

        private PartialBinding(BeanHolder<? extends IdentifierBridge<I>> bridgeHolder, Class<I> expectedValueType) {
            this.bridgeHolder = bridgeHolder;
            this.expectedValueType = expectedValueType;
        }

        void abort(AbstractCloser<?, ?> closer) {
            DefaultIdentifierBindingContext.abortBridge(closer, this.bridgeHolder);
        }

        BoundIdentifierBridge<I> complete(Optional<IndexedEntityBindingContext> indexedEntityBindingContext) {
            if (indexedEntityBindingContext.isPresent()) {
                PojoIdentifierBridgeDocumentValueConverter converter = new PojoIdentifierBridgeDocumentValueConverter((IdentifierBridge)this.bridgeHolder.get());
                indexedEntityBindingContext.get().idDslConverter(this.expectedValueType, converter);
                indexedEntityBindingContext.get().idProjectionConverter(this.expectedValueType, converter);
                indexedEntityBindingContext.get().idParser(new PojoIdentifierBridgeParseConverter((IdentifierBridge)this.bridgeHolder.get()));
            }
            return new BoundIdentifierBridge(this.bridgeHolder);
        }
    }
}

