/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl;

import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.mapper.model.spi.TypeMetadataDiscoverer;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.AnnotationPojoTypeMetadataContributorFactory;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.spi.BuiltinAnnotations;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.reporting.spi.MapperHints;
import org.hibernate.search.util.common.jar.impl.JandexUtils;
import org.hibernate.search.util.common.jar.impl.JarUtils;
import org.hibernate.search.util.common.jar.spi.JandexBehavior;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.AnnotationHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;

public class AnnotationMappingConfigurationContextImpl
implements AnnotationMappingConfigurationContext,
PojoMappingConfigurationContributor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoBootstrapIntrospector introspector;
    private final MapperHints mapperHints;
    private boolean discoverAnnotatedTypesFromRootMappingAnnotations = false;
    private boolean discoverJandexIndexesFromAddedTypes = false;
    private boolean buildMissingJandexIndexes = false;
    private boolean discoverAnnotationsFromReferencedTypes = false;
    private final Set<Class<?>> explicitAnnotatedTypes = new LinkedHashSet();
    private final List<IndexView> explicitJandexIndexes = new ArrayList<IndexView>();

    public AnnotationMappingConfigurationContextImpl(PojoBootstrapIntrospector introspector, MapperHints mapperHints) {
        this.introspector = introspector;
        this.mapperHints = mapperHints;
    }

    @Override
    public AnnotationMappingConfigurationContext discoverAnnotatedTypesFromRootMappingAnnotations(boolean enabled) {
        this.discoverAnnotatedTypesFromRootMappingAnnotations = enabled;
        return this;
    }

    @Override
    public AnnotationMappingConfigurationContext discoverJandexIndexesFromAddedTypes(boolean enabled) {
        this.discoverJandexIndexesFromAddedTypes = enabled;
        return this;
    }

    @Override
    public AnnotationMappingConfigurationContext buildMissingDiscoveredJandexIndexes(boolean enabled) {
        this.buildMissingJandexIndexes = enabled;
        return this;
    }

    @Override
    public AnnotationMappingConfigurationContext discoverAnnotationsFromReferencedTypes(boolean enabled) {
        this.discoverAnnotationsFromReferencedTypes = enabled;
        return this;
    }

    @Override
    public AnnotationMappingConfigurationContext add(Class<?> annotatedType) {
        this.explicitAnnotatedTypes.add(annotatedType);
        return this;
    }

    @Override
    public AnnotationMappingConfigurationContext add(Set<Class<?>> annotatedTypes) {
        this.explicitAnnotatedTypes.addAll(annotatedTypes);
        return this;
    }

    @Override
    public AnnotationMappingConfigurationContext addJandexIndex(IndexView jandexIndex) {
        this.explicitJandexIndexes.add(jandexIndex);
        return this;
    }

    @Override
    public void configure(MappingBuildContext buildContext, PojoMappingConfigurationContext configurationContext, MappingConfigurationCollector<PojoTypeMetadataContributor> collector) {
        BeanResolver beanResolver = buildContext.beanResolver();
        ContextualFailureCollector failureCollector = buildContext.failureCollector();
        AnnotationHelper annotationHelper = new AnnotationHelper(this.introspector.annotationValueHandleFactory());
        AnnotationPojoTypeMetadataContributorFactory contributorFactory = new AnnotationPojoTypeMetadataContributorFactory(beanResolver, (FailureCollector)failureCollector, configurationContext, annotationHelper);
        LinkedHashSet typesToProcess = new LinkedHashSet();
        for (Class<?> clazz : this.explicitAnnotatedTypes) {
            this.introspector.typeModel(clazz).ascendingSuperTypes().forEach(typesToProcess::add);
        }
        if (this.discoverAnnotatedTypesFromRootMappingAnnotations) {
            JandexBehavior.doWithJandex(() -> {
                IndexView jandexIndex = this.buildJandexIndex();
                if (jandexIndex == null) {
                    return;
                }
                this.discoverAnnotatedTypesFromRootMappingAnnotation(typesToProcess, jandexIndex, buildContext.classResolver());
            });
        }
        HashSet alreadyContributedTypes = new HashSet();
        for (PojoRawTypeModel typeModel : typesToProcess) {
            Optional<PojoTypeMetadataContributor> contributorOptional;
            boolean neverContributed = alreadyContributedTypes.add(typeModel);
            if (!neverContributed || !(contributorOptional = contributorFactory.createIfAnnotated(typeModel)).isPresent()) continue;
            collector.collectContributor((MappableTypeModel)typeModel, (Object)contributorOptional.get());
        }
        if (this.discoverAnnotationsFromReferencedTypes) {
            PojoAnnotationTypeMetadataDiscoverer pojoAnnotationTypeMetadataDiscoverer = new PojoAnnotationTypeMetadataDiscoverer(contributorFactory, alreadyContributedTypes);
            collector.collectDiscoverer((TypeMetadataDiscoverer)pojoAnnotationTypeMetadataDiscoverer);
        }
    }

    private void discoverAnnotatedTypesFromRootMappingAnnotation(Set<PojoRawTypeModel<?>> annotatedTypes, IndexView jandexIndex, ClassResolver classResolver) {
        HashSet<DotName> rootMappingAnnotations = new HashSet<DotName>(BuiltinAnnotations.ROOT_MAPPING_ANNOTATIONS);
        rootMappingAnnotations.addAll(JandexUtils.findAnnotatedAnnotationsAndContaining((IndexView)jandexIndex, (DotName)BuiltinAnnotations.ROOT_MAPPING));
        HashSet<DotName> rootMappingAnnotatedTypes = new HashSet<DotName>();
        for (DotName annotationName : rootMappingAnnotations) {
            for (AnnotationInstance annotation : jandexIndex.getAnnotations(annotationName)) {
                ClassInfo annotatedClassInfo = JandexUtils.extractDeclaringClass((AnnotationTarget)annotation.target());
                rootMappingAnnotatedTypes.add(annotatedClassInfo.name());
            }
        }
        for (DotName rootMappingAnnotatedType : rootMappingAnnotatedTypes) {
            Class annotatedClass = classResolver.classForName(rootMappingAnnotatedType.toString());
            this.introspector.typeModel(annotatedClass).ascendingSuperTypes().forEach(annotatedTypes::add);
        }
    }

    private IndexView buildJandexIndex() {
        ArrayList<IndexView> jandexIndexes = new ArrayList<IndexView>(this.explicitJandexIndexes);
        if (this.discoverJandexIndexesFromAddedTypes) {
            IndexView compositeOfExplicitJandexIndexes = JandexUtils.compositeIndex(jandexIndexes);
            LinkedHashSet discoveredBuildingAllowedCodeSourceLocations = new LinkedHashSet();
            LinkedHashSet discoveredBuildingForbiddenCodeSourceLocations = new LinkedHashSet();
            for (Class<?> annotatedType : this.explicitAnnotatedTypes) {
                DotName dotName = DotName.createSimple((String)annotatedType.getName());
                if (compositeOfExplicitJandexIndexes.getClassByName(dotName) != null) continue;
                LinkedHashSet targetSet = this.isJandexBuildingAllowed(annotatedType) ? discoveredBuildingAllowedCodeSourceLocations : discoveredBuildingForbiddenCodeSourceLocations;
                JarUtils.codeSourceLocation(annotatedType).ifPresent(targetSet::add);
            }
            for (URL codeSourceLocation : discoveredBuildingAllowedCodeSourceLocations) {
                this.jandexIndexForCodeSourceLocation(codeSourceLocation, true).ifPresent(jandexIndexes::add);
            }
            for (URL codeSourceLocation : discoveredBuildingForbiddenCodeSourceLocations) {
                this.jandexIndexForCodeSourceLocation(codeSourceLocation, false).ifPresent(jandexIndexes::add);
            }
        }
        return jandexIndexes.isEmpty() ? null : JandexUtils.compositeIndex(jandexIndexes);
    }

    private boolean isJandexBuildingAllowed(Class<?> annotatedType) {
        if (this.buildMissingJandexIndexes) {
            Package pakkage = annotatedType.getPackage();
            return pakkage != null && !pakkage.getName().equals("org.hibernate") && !pakkage.getName().startsWith("org.hibernate.");
        }
        return false;
    }

    private Optional<Index> jandexIndexForCodeSourceLocation(URL codeSourceLocation, boolean buildIfMissing) {
        try {
            if (buildIfMissing) {
                return Optional.of(JandexUtils.readOrBuildIndex((URL)codeSourceLocation));
            }
            return JandexUtils.readIndex((URL)codeSourceLocation);
        }
        catch (RuntimeException e) {
            throw log.errorDiscoveringJandexIndex(codeSourceLocation, e.getMessage(), this.mapperHints.cannotReadJandexRootMapping(), e);
        }
    }

    private static class PojoAnnotationTypeMetadataDiscoverer
    implements TypeMetadataDiscoverer<PojoTypeMetadataContributor> {
        private final AnnotationPojoTypeMetadataContributorFactory contributorFactory;
        private final Set<PojoRawTypeModel<?>> alreadyContributedTypes;

        PojoAnnotationTypeMetadataDiscoverer(AnnotationPojoTypeMetadataContributorFactory contributorFactory, Set<PojoRawTypeModel<?>> alreadyContributedTypes) {
            this.contributorFactory = contributorFactory;
            this.alreadyContributedTypes = alreadyContributedTypes;
        }

        public Optional<PojoTypeMetadataContributor> discover(MappableTypeModel typeModel) {
            PojoRawTypeModel pojoTypeModel = (PojoRawTypeModel)typeModel;
            boolean neverContributed = this.alreadyContributedTypes.add(pojoTypeModel);
            if (neverContributed) {
                return this.contributorFactory.createIfAnnotated(pojoTypeModel);
            }
            return Optional.empty();
        }
    }
}

