/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.hibernate.search.engine.common.tree.spi.TreeNestingContext;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.search.projection.definition.spi.ConstantProjectionDefinition;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoMethodParameterModel;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.mapper.pojo.search.definition.binding.impl.ProjectionBindingContextImpl;
import org.hibernate.search.mapper.pojo.search.definition.binding.impl.ProjectionConstructorParameterBinder;
import org.hibernate.search.mapper.pojo.search.definition.impl.PojoConstructorProjectionDefinition;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

public class ProjectionConstructorBinder<T>
implements EventContextProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoMappingHelper mappingHelper;
    private final ProjectionBindingContextImpl<?> parentBindingContext;
    final TreeNestingContext nestingContext;
    final PojoConstructorModel<T> constructor;
    final PojoConstructorIdentifier constructorIdentifier;

    public ProjectionConstructorBinder(PojoMappingHelper mappingHelper, PojoConstructorModel<T> constructor) {
        this(mappingHelper, constructor, null, TreeNestingContext.root());
    }

    public ProjectionConstructorBinder(PojoMappingHelper mappingHelper, PojoConstructorModel<T> constructor, ProjectionBindingContextImpl<?> parentBindingContext, TreeNestingContext nestingContext) {
        this.mappingHelper = mappingHelper;
        this.parentBindingContext = parentBindingContext;
        this.nestingContext = nestingContext;
        this.constructor = constructor;
        this.constructorIdentifier = new PojoConstructorIdentifier(constructor);
    }

    public EventContext eventContext() {
        return EventContext.concat((EventContext)(this.parentBindingContext == null ? null : this.parentBindingContext.parameterBinder.eventContext()), (EventContext[])new EventContext[]{PojoEventContexts.fromType(this.constructor.typeModel()), PojoEventContexts.fromConstructor(this.constructor)});
    }

    public PojoConstructorProjectionDefinition<T> bind() {
        if (this.constructor.typeModel().isAbstract()) {
            throw log.invalidAbstractTypeForProjectionConstructor(this.constructor.typeModel());
        }
        ArrayList parameterDefinitions = new ArrayList();
        for (PojoMethodParameterModel<?> parameter : this.constructor.declaredParameters()) {
            BeanHolder parameterDefinition;
            ProjectionConstructorParameterBinder parameterBinder = new ProjectionConstructorParameterBinder(this.mappingHelper, this, parameter);
            try {
                parameterDefinition = parameterBinder.bind();
            }
            catch (RuntimeException e) {
                this.mappingHelper.failureCollector().withContext(parameterBinder.eventContext()).add((Throwable)e);
                parameterDefinition = ConstantProjectionDefinition.nullValue();
            }
            parameterDefinitions.add(parameterDefinition);
        }
        return new PojoConstructorProjectionDefinition<T>(this.constructorIdentifier, this.constructor.handle(), parameterDefinitions);
    }
}

