/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.logging.impl;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import org.hibernate.search.mapper.pojo.massindexing.impl.MassIndexingOperationHandledFailureException;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@CategorizedLogger(category="org.hibernate.search.mapper.massindexing", description="Logs related to various mass indexing operations.\n")
@MessageLogger(projectCode="HSEARCH")
public interface MassIndexingLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.mapper.massindexing";
    public static final MassIndexingLog INSTANCE = (MassIndexingLog)LoggerFactory.make(MassIndexingLog.class, (String)"org.hibernate.search.mapper.massindexing", (MethodHandles.Lookup)MethodHandles.lookup());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=27, value="Mass indexing is going to index %d entities.")
    public void indexingEntities(long var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=62, value="Mass indexing received interrupt signal: aborting.")
    public void interruptedBatchIndexing();

    @Message(id=700042, value="%1$s failure(s) occurred during mass indexing. See the logs for details. First failure: %2$s")
    public SearchException massIndexingFirstFailure(long var1, String var3, @Cause Throwable var4);

    @Message(id=700101, value="%1$s failure(s) occurred during mass indexing. See the logs for details. First failure on entity '%2$s': %3$s")
    public SearchException massIndexingFirstFailureOnEntity(long var1, Object var3, String var4, @Cause Throwable var5);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=700102, value="The mass indexing failure handler threw an exception while handling a previous failure. The failure may not have been reported.")
    public void failureInMassIndexingFailureHandler(@Cause Throwable var1);

    @Message(id=700103, value="Mass indexing received interrupt signal. The index is left in an unknown state!")
    public SearchException massIndexingThreadInterrupted(@Cause InterruptedException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=700120, value="Both \"dropAndCreateSchemaOnStart()\" and \"purgeAllOnStart()\" are enabled. Consider having just one setting enabled as after the index is recreated there is nothing to purge.")
    public void redundantPurgeAfterDrop();

    @Message(id=700125, value="%1$s failures went unreported for this operation to avoid flooding. To disable flooding protection, use 'massIndexer.failureFloodingThreshold(Long.MAX_VALUE)'.")
    public SearchException notReportedFailures(long var1);

    @Message(id=700160, value="Requesting a schema drop-create on start is not allowed when multitenancy is enabled. Schema would be dropped for all tenants, but data will only be indexed for tenant ids '%1$s'. Do not use the schema drop-create on start when providing tenant ids. If schema drop is actually required, do it through an SearchSchemaManager.")
    public SearchException schemaDropNotAllowedWithMultitenancy(Set<String> var1);

    @Message(id=700161, value="Invalid mass indexing default clean operation name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidMassIndexingDefaultCleanOperation(String var1, List<String> var2);

    @Message(id=700163, value="Mass indexer running in a fail fast mode encountered a problem. Stopping the process.")
    public MassIndexingOperationHandledFailureException massIndexerFailFast();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=700164, value="Mass indexed %1$d. Speed: %3$.2f/s instant, %4$.2f/s since start. Remaining: unknown, %2$d type(s) pending.")
    public void indexingProgress(long var1, long var3, float var5, float var6);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=700165, value="Mass indexed %1$d. Speed: %2$.2f/s instant, %3$.2f/s since start. Remaining: unknown.")
    public void indexingProgress(long var1, float var3, float var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=700166, value="Mass indexed %1$.2f%% %2$d/%3$d. Speed: %4$.2f/s instant, %5$.2f/s since start. Remaining: %6$d, %7$d type(s) pending.")
    public void indexingProgress(float var1, long var2, long var4, float var6, float var7, long var8, long var10);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=700167, value="Mass indexed %1$.2f%% %2$d/%3$d. Speed: %4$.2f/s instant, %5$.2f/s since start. Remaining: %6$d, approx. %7$s.")
    public void indexingProgressWithRemainingTime(float var1, long var2, long var4, float var6, float var7, long var8, Duration var10);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=700168, value="Mass indexing complete in %3$s. Indexed %1$d/%2$d entities.")
    public void indexingEntitiesCompleted(long var1, long var3, Duration var5);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=700169, value="Mass indexing is going to index approx. %1$d entities (%2$s). Actual number may change once the indexing starts.")
    public void indexingEntitiesApprox(long var1, String var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=700172, value="Indexing for %s is done.")
    public void indexingForTypeGroupDone(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=700173, value="Identifier loading for %s started.")
    public void identifierLoadingStarted(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=700174, value="Identifier loading for %s finished.")
    public void identifierLoadingFinished(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=700175, value="Identifier loading produced a list of ids: %s.")
    public void identifierLoadingLoadedIds(List<?> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=700176, value="Entity loading for %s started.")
    public void entityLoadingStarted(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=700177, value="Entity loading for %s finished.")
    public void entityLoadingFinished(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=700178, value="Entity loading will attempt to load entities for ids: %s.")
    public void entityLoadingAttemptToLoadIds(List<?> var1);
}

