/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.logging.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.path.spi.ProjectionConstructorPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.search.definition.impl.ConstructorProjectionApplicationException;
import org.hibernate.search.mapper.pojo.search.definition.impl.PojoConstructorProjectionDefinition;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.logging.impl.ToStringTreeMultilineFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@CategorizedLogger(category="org.hibernate.search.mapper.projection", description="Logs related to projection operations.\n")
@MessageLogger(projectCode="HSEARCH")
public interface ProjectionLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.mapper.projection";
    public static final ProjectionLog INSTANCE = (ProjectionLog)LoggerFactory.make(ProjectionLog.class, (String)"org.hibernate.search.mapper.projection", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=700112, value="Invalid object class for projection: %1$s. Make sure that this class is mapped correctly, either through annotations (@ProjectionConstructor) or programmatic mapping. If it is, make sure the class is included in a Jandex index made available to Hibernate Search.")
    public SearchException invalidObjectClassForProjection(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=700113, value="Invalid declaring type for projection constructor: type '%1$s' is abstract. Projection constructors can only be declared on concrete types.")
    public SearchException invalidAbstractTypeForProjectionConstructor(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1);

    @Message(id=700114, value="Missing parameter names in Java metadata for projection constructor. When inferring inner projections from constructor parameters, constructor parameter names must be known. Either make sure this class was compiled with the '-parameters' compiler flag, or set the path explicitly with '@FieldProjection(path = ...)' or '@ObjectProjection(path = ...)'.")
    public SearchException missingParameterNameForInferredProjection();

    @Message(id=700115, value="Invalid parameter type for projection constructor: %1$s. When inferring the cardinality of inner projections from constructor parameters, multi-valued constructor parameters must be lists/sets (java.util.List<...>/java.util.Set<...>/java.util.SortedSet<...>), their supertypes (java.lang.Iterable<...>, java.util.Collection<...>) or arrays")
    public SearchException invalidMultiValuedParameterTypeForProjectionConstructor(@FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var1);

    @Message(id=700116, value="Multiple projection constructor are mapped for type '%1$s'. At most one projection constructor is allowed for each type.")
    public SearchException multipleProjectionConstructorsForType(Class<?> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=700117, value="Constructor projection for type '%1$s': %2$s")
    public void constructorProjection(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=ToStringTreeMultilineFormatter.class) PojoConstructorProjectionDefinition<?> var2);

    @Message(id=700118, value="Cyclic recursion starting from '%1$s' on %2$s. Index field path starting from that location and ending with a cycle: '%3$s'. A projection constructor cannot declare an unrestricted @ObjectProjection to itself, even indirectly. To break the cycle, you should consider adding filters to your @ObjectProjection: includePaths, includeDepth, excludePaths, ...")
    public SearchException objectProjectionCyclicRecursion(MappingElement var1, @FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var2, String var3);

    @Message(id=700123, value="Could not apply projection constructor: %1$s")
    public ConstructorProjectionApplicationException errorApplyingProjectionConstructor(String var1, @Cause Exception var2, @Param ProjectionConstructorPath var3);

    @Message(id=700134, value="Multiple projections are mapped for this parameter. At most one projection is allowed for each parameter.")
    public SearchException multipleProjectionMappingsForParameter();

    @Message(id=700135, value="Incorrect binder implementation: binder '%1$s' did not call context.definition(...).")
    public SearchException missingProjectionDefinitionForBinder(Object var1);

    @Message(id=700136, value="Invalid projection definition for constructor parameter type '%2$s': '%1$s'. This projection results in values of type '%3$s'.")
    public SearchException invalidOutputTypeForProjectionDefinition(Object var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var2, @FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var3);

    @Message(id=700137, value="Invalid multi-valued projection definition for constructor parameter type '%2$s': '%1$s'. This projection results in values of type '%3$s'.")
    public SearchException invalidOutputTypeForMultiValuedProjectionDefinition(Object var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var2, @FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var3);

    @Message(id=700138, value="Missing parameter names in Java metadata for projection constructor. When mapping a projection constructor parameter to a field projection without providing a field path, constructor parameter names must be known. Either make sure this class was compiled with the '-parameters' compiler flag, or set the path explicitly with '@FieldProjection(path = ...)'.")
    public SearchException missingParameterNameForFieldProjectionInProjectionConstructor();

    @Message(id=700139, value="Missing parameter names in Java metadata for projection constructor. When mapping a projection constructor parameter to an object projection without providing a field path, constructor parameter names must be known. Either make sure this class was compiled with the '-parameters' compiler flag, or set the path explicitly with '@ObjectProjection(path = ...)'.")
    public SearchException missingParameterNameForObjectProjectionInProjectionConstructor();

    @Message(id=700140, value="Missing parameter names in Java metadata for projection constructor. When mapping a projection constructor parameter to a highlight projection without providing a field path, constructor parameter names must be known. Either make sure this class was compiled with the '-parameters' compiler flag, or set the path explicitly with '@HighlightProjection(path = ...)'.")
    public SearchException missingParameterNameForHighlightProjectionInProjectionConstructor();

    @Message(id=700141, value="Invalid constructor parameter type: '%1$s'. The highlight projection results in values of type '%2$s'.")
    public SearchException invalidParameterTypeForHighlightProjectionInProjectionConstructor(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2);

    @Message(id=700159, value="Invalid constructor parameter type: '%1$s'. The distance projection results in values of type '%2$s'.")
    public SearchException invalidParameterTypeForDistanceProjectionInProjectionConstructor(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2);

    @Message(id=700171, value="Implicit binding of a java.util.SortedSet<%1$s> constructor parameter is not possible since %1$s is not implementing java.lang.Comparable. Either make %1$s implement java.lang.Comparable or create a custom @ProjectionBinding and use the ProjectionCollector.sortedSet(comparator) collector provider in it.")
    public SearchException cannotBindSortedSetWithNonComparableElements(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Param EventContext var2);
}

