/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.models.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Stream;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.model.models.spi.AbstractPojoModelsBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.models.spi.AbstractPojoModelsRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public abstract class AbstractPojoModelsPropertyModel<T, I extends AbstractPojoModelsBootstrapIntrospector>
implements PojoPropertyModel<T> {
    protected final I introspector;
    protected final AbstractPojoModelsRawTypeModel<?, I> holderTypeModel;
    protected final String name;
    protected final List<MemberDetails> declaredProperties;
    private final List<Member> members;
    private ValueReadHandle<T> handleCache;
    private PojoTypeModel<T> typeModelCache;
    private Member memberCache;

    public AbstractPojoModelsPropertyModel(I introspector, AbstractPojoModelsRawTypeModel<?, I> holderTypeModel, String name, List<MemberDetails> declaredProperties, List<Member> members) {
        Contracts.assertNotNullNorEmpty(members, (String)"members");
        this.introspector = introspector;
        this.holderTypeModel = holderTypeModel;
        this.name = name;
        this.declaredProperties = declaredProperties;
        this.members = members;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final Stream<Annotation> annotations() {
        return this.declaredProperties.stream().flatMap(arg_0 -> this.introspector.annotations(arg_0));
    }

    @Override
    public final PojoTypeModel<T> typeModel() {
        if (this.typeModelCache == null) {
            try {
                this.typeModelCache = this.holderTypeModel.rawTypeDeclaringContext.memberTypeReference(this.getterGenericReturnType());
            }
            catch (RuntimeException e) {
                throw MappingLog.INSTANCE.errorRetrievingPropertyTypeModel(this.name(), this.holderTypeModel, e);
            }
        }
        return this.typeModelCache;
    }

    @Override
    public final ValueReadHandle<T> handle() {
        if (this.handleCache == null) {
            try {
                this.handleCache = this.createHandle(this.member());
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                throw MappingLog.INSTANCE.errorRetrievingPropertyTypeModel(this.name(), this.holderTypeModel, e);
            }
        }
        return this.handleCache;
    }

    protected final Member member() {
        if (this.memberCache == null) {
            this.memberCache = this.members.get(0);
            if (this.members.size() > 1) {
                MappingLog.INSTANCE.arbitraryMemberSelection(this.holderTypeModel, this.name, this.memberCache, this.members.subList(1, this.members.size()));
            }
        }
        return this.memberCache;
    }

    protected abstract ValueReadHandle<T> createHandle(Member var1) throws ReflectiveOperationException;

    final Type getterGenericReturnType() {
        Member member = this.member();
        if (member instanceof Method) {
            return ((Method)member).getGenericReturnType();
        }
        if (member instanceof Field) {
            return ((Field)member).getGenericType();
        }
        throw new AssertionFailure("Unexpected type for a " + Member.class.getName() + ": " + String.valueOf(member) + " has type " + String.valueOf(member == null ? null : member.getClass()));
    }
}

