/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.builtin;

import java.util.Optional;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.definition.ProjectionDefinitionContext;
import org.hibernate.search.engine.search.projection.definition.spi.AbstractProjectionDefinition;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.mapper.pojo.logging.impl.ProjectionLog;
import org.hibernate.search.mapper.pojo.model.PojoModelValue;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingContext;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

public final class HighlightProjectionBinder
implements ProjectionBinder {
    private final String fieldPathOrNull;
    private String highlighterName;

    public static HighlightProjectionBinder create() {
        return HighlightProjectionBinder.create(null);
    }

    public static HighlightProjectionBinder create(String fieldPath) {
        return new HighlightProjectionBinder(fieldPath);
    }

    private HighlightProjectionBinder(String fieldPathOrNull) {
        this.fieldPathOrNull = fieldPathOrNull;
    }

    public HighlightProjectionBinder highlighter(String highlighterName) {
        this.highlighterName = highlighterName;
        return this;
    }

    @Override
    public void bind(ProjectionBindingContext context) {
        String fieldPath = this.fieldPathOrFail(context);
        Optional<PojoModelValue<?>> containerElementOptional = context.containerElement();
        ProjectionCollector.Provider collector = context.projectionCollectorProviderFactory().projectionCollectorProvider(containerElementOptional.isPresent() ? context.constructorParameter().rawType() : null, String.class);
        context.definition(String.class, new Definition(fieldPath, this.highlighterName, collector));
    }

    private String fieldPathOrFail(ProjectionBindingContext context) {
        if (this.fieldPathOrNull != null) {
            return this.fieldPathOrNull;
        }
        Optional<String> paramName = context.constructorParameter().name();
        if (paramName.isEmpty()) {
            throw ProjectionLog.INSTANCE.missingParameterNameForHighlightProjectionInProjectionConstructor();
        }
        return paramName.get();
    }

    private static class Definition<T>
    extends AbstractProjectionDefinition<T> {
        private final String fieldPath;
        private final String highlighterName;
        private final ProjectionCollector.Provider<String, T> collector;

        private Definition(String fieldPath, String highlighterName, ProjectionCollector.Provider<String, T> collector) {
            this.fieldPath = fieldPath;
            this.highlighterName = highlighterName;
            this.collector = collector;
        }

        protected String type() {
            return "highlight";
        }

        public SearchProjection<T> create(SearchProjectionFactory<?, ?> factory, ProjectionDefinitionContext context) {
            return factory.highlight(this.fieldPath).highlighter(this.highlighterName).collector(this.collector).toProjection();
        }

        public void appendTo(ToStringTreeAppender appender) {
            super.appendTo(appender);
            appender.attribute("fieldPath", (Object)this.fieldPath);
            appender.attribute("highlighter", (Object)this.highlighterName);
        }
    }
}

