package org.hibernate.search.mapper.pojo.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import org.hibernate.search.mapper.pojo.massindexing.impl.MassIndexingOperationHandledFailureException;
import java.util.Set;
import org.hibernate.search.util.common.SearchException;
import java.time.Duration;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.InterruptedException;
import java.lang.Throwable;
import java.lang.Object;
import java.util.List;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class MassIndexingLog_$logger implements MassIndexingLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MassIndexingLog_$logger.class.getName();
    public MassIndexingLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void indexingEntities(final long count) {
        log.logf(FQCN, INFO, null, indexingEntities$str(), count);
    }
    protected String indexingEntities$str() {
        return "HSEARCH000027: Mass indexing is going to index %d entities.";
    }
    @Override
    public final void interruptedBatchIndexing() {
        log.logf(FQCN, ERROR, null, interruptedBatchIndexing$str());
    }
    protected String interruptedBatchIndexing$str() {
        return "HSEARCH000062: Mass indexing received interrupt signal: aborting.";
    }
    protected String massIndexingFirstFailure$str() {
        return "HSEARCH700042: %1$s failure(s) occurred during mass indexing. See the logs for details. First failure: %2$s";
    }
    @Override
    public final SearchException massIndexingFirstFailure(final long finalFailureCount, final String firstFailureMessage, final Throwable firstFailure) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), massIndexingFirstFailure$str(), finalFailureCount, firstFailureMessage), firstFailure);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String massIndexingFirstFailureOnEntity$str() {
        return "HSEARCH700101: %1$s failure(s) occurred during mass indexing. See the logs for details. First failure on entity '%2$s': %3$s";
    }
    @Override
    public final SearchException massIndexingFirstFailureOnEntity(final long finalFailureCount, final Object firstFailureEntity, final String firstFailureMessage, final Throwable firstFailure) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), massIndexingFirstFailureOnEntity$str(), finalFailureCount, firstFailureEntity, firstFailureMessage), firstFailure);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failureInMassIndexingFailureHandler(final Throwable t) {
        log.logf(FQCN, ERROR, t, failureInMassIndexingFailureHandler$str());
    }
    protected String failureInMassIndexingFailureHandler$str() {
        return "HSEARCH700102: The mass indexing failure handler threw an exception while handling a previous failure. The failure may not have been reported.";
    }
    protected String massIndexingThreadInterrupted$str() {
        return "HSEARCH700103: Mass indexing received interrupt signal. The index is left in an unknown state!";
    }
    @Override
    public final SearchException massIndexingThreadInterrupted(final InterruptedException e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), massIndexingThreadInterrupted$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void redundantPurgeAfterDrop() {
        log.logf(FQCN, WARN, null, redundantPurgeAfterDrop$str());
    }
    protected String redundantPurgeAfterDrop$str() {
        return "HSEARCH700120: Both \"dropAndCreateSchemaOnStart()\" and \"purgeAllOnStart()\" are enabled. Consider having just one setting enabled as after the index is recreated there is nothing to purge.";
    }
    protected String notReportedFailures$str() {
        return "HSEARCH700125: %1$s failures went unreported for this operation to avoid flooding. To disable flooding protection, use 'massIndexer.failureFloodingThreshold(Long.MAX_VALUE)'.";
    }
    @Override
    public final SearchException notReportedFailures(final long count) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), notReportedFailures$str(), count));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String schemaDropNotAllowedWithMultitenancy$str() {
        return "HSEARCH700160: Requesting a schema drop-create on start is not allowed when multitenancy is enabled. Schema would be dropped for all tenants, but data will only be indexed for tenant ids '%1$s'. Do not use the schema drop-create on start when providing tenant ids. If schema drop is actually required, do it through an SearchSchemaManager.";
    }
    @Override
    public final SearchException schemaDropNotAllowedWithMultitenancy(final Set<String> tenantIds) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), schemaDropNotAllowedWithMultitenancy$str(), tenantIds));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMassIndexingDefaultCleanOperation$str() {
        return "HSEARCH700161: Invalid mass indexing default clean operation name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidMassIndexingDefaultCleanOperation(final String name, final List<String> names) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidMassIndexingDefaultCleanOperation$str(), name, names));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String massIndexerFailFast$str() {
        return "HSEARCH700163: Mass indexer running in a fail fast mode encountered a problem. Stopping the process.";
    }
    @Override
    public final MassIndexingOperationHandledFailureException massIndexerFailFast() {
        final MassIndexingOperationHandledFailureException result = new MassIndexingOperationHandledFailureException(String.format(getLoggingLocale(), massIndexerFailFast$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void indexingProgress(final long doneCount, final long typesToIndex, final float currentSpeed, final float estimateSpeed) {
        log.logf(FQCN, INFO, null, indexingProgress4$str(), doneCount, typesToIndex, currentSpeed, estimateSpeed);
    }
    protected String indexingProgress4$str() {
        return "HSEARCH700164: Mass indexed %1$d. Speed: %3$.2f/s instant, %4$.2f/s since start. Remaining: unknown, %2$d type(s) pending.";
    }
    @Override
    public final void indexingProgress(final long doneCount, final float currentSpeed, final float estimateSpeed) {
        log.logf(FQCN, INFO, null, indexingProgress3$str(), doneCount, currentSpeed, estimateSpeed);
    }
    protected String indexingProgress3$str() {
        return "HSEARCH700165: Mass indexed %1$d. Speed: %2$.2f/s instant, %3$.2f/s since start. Remaining: unknown.";
    }
    @Override
    public final void indexingProgress(final float estimatePercentileComplete, final long doneCount, final long totalCount, final float currentSpeed, final float estimateSpeed, final long remainingCount, final long typesToIndex) {
        log.logf(FQCN, INFO, null, indexingProgress7$str(), estimatePercentileComplete, doneCount, totalCount, currentSpeed, estimateSpeed, remainingCount, typesToIndex);
    }
    protected String indexingProgress7$str() {
        return "HSEARCH700166: Mass indexed %1$.2f%% %2$d/%3$d. Speed: %4$.2f/s instant, %5$.2f/s since start. Remaining: %6$d, %7$d type(s) pending.";
    }
    @Override
    public final void indexingProgressWithRemainingTime(final float estimatePercentileComplete, final long doneCount, final long totalCount, final float currentSpeed, final float estimateSpeed, final long remainingCount, final Duration timeToFinish) {
        log.logf(FQCN, INFO, null, indexingProgressWithRemainingTime$str(), estimatePercentileComplete, doneCount, totalCount, currentSpeed, estimateSpeed, remainingCount, timeToFinish);
    }
    protected String indexingProgressWithRemainingTime$str() {
        return "HSEARCH700167: Mass indexed %1$.2f%% %2$d/%3$d. Speed: %4$.2f/s instant, %5$.2f/s since start. Remaining: %6$d, approx. %7$s.";
    }
    @Override
    public final void indexingEntitiesCompleted(final long indexed, final long total, final Duration indexingTime) {
        log.logf(FQCN, INFO, null, indexingEntitiesCompleted$str(), indexed, total, indexingTime);
    }
    protected String indexingEntitiesCompleted$str() {
        return "HSEARCH700168: Mass indexing complete in %3$s. Indexed %1$d/%2$d entities.";
    }
    @Override
    public final void indexingEntitiesApprox(final long count, final String types) {
        log.logf(FQCN, INFO, null, indexingEntitiesApprox$str(), count, types);
    }
    protected String indexingEntitiesApprox$str() {
        return "HSEARCH700169: Mass indexing is going to index approx. %1$d entities (%2$s). Actual number may change once the indexing starts.";
    }
    @Override
    public final void indexingForTypeGroupDone(final String typeGroup) {
        log.logf(FQCN, DEBUG, null, indexingForTypeGroupDone$str(), typeGroup);
    }
    protected String indexingForTypeGroupDone$str() {
        return "HSEARCH700172: Indexing for %s is done.";
    }
    @Override
    public final void identifierLoadingStarted(final String typeGroup) {
        log.logf(FQCN, DEBUG, null, identifierLoadingStarted$str(), typeGroup);
    }
    protected String identifierLoadingStarted$str() {
        return "HSEARCH700173: Identifier loading for %s started.";
    }
    @Override
    public final void identifierLoadingFinished(final String typeGroup) {
        log.logf(FQCN, DEBUG, null, identifierLoadingFinished$str(), typeGroup);
    }
    protected String identifierLoadingFinished$str() {
        return "HSEARCH700174: Identifier loading for %s finished.";
    }
    @Override
    public final void identifierLoadingLoadedIds(final List<?> ids) {
        log.logf(FQCN, DEBUG, null, identifierLoadingLoadedIds$str(), ids);
    }
    protected String identifierLoadingLoadedIds$str() {
        return "HSEARCH700175: Identifier loading produced a list of ids: %s.";
    }
    @Override
    public final void entityLoadingStarted(final String typeGroup) {
        log.logf(FQCN, DEBUG, null, entityLoadingStarted$str(), typeGroup);
    }
    protected String entityLoadingStarted$str() {
        return "HSEARCH700176: Entity loading for %s started.";
    }
    @Override
    public final void entityLoadingFinished(final String typeGroup) {
        log.logf(FQCN, DEBUG, null, entityLoadingFinished$str(), typeGroup);
    }
    protected String entityLoadingFinished$str() {
        return "HSEARCH700177: Entity loading for %s finished.";
    }
    @Override
    public final void entityLoadingAttemptToLoadIds(final List<?> ids) {
        log.logf(FQCN, DEBUG, null, entityLoadingAttemptToLoadIds$str(), ids);
    }
    protected String entityLoadingAttemptToLoadIds$str() {
        return "HSEARCH700178: Entity loading will attempt to load entities for ids: %s.";
    }
}
