/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.logging.impl;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.hibernate.search.mapper.pojo.logging.impl.MassIndexingLog;
import org.hibernate.search.mapper.pojo.massindexing.impl.MassIndexingOperationHandledFailureException;
import org.hibernate.search.util.common.SearchException;
import org.jboss.logging.Logger;

public class MassIndexingLog_$logger
implements MassIndexingLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MassIndexingLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public MassIndexingLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void indexingEntities(long count) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntities$str(), (Object)count);
    }

    protected String indexingEntities$str() {
        return "HSEARCH000027: Mass indexing is going to index %d entities.";
    }

    @Override
    public final void interruptedBatchIndexing() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.interruptedBatchIndexing$str(), new Object[0]);
    }

    protected String interruptedBatchIndexing$str() {
        return "HSEARCH000062: Mass indexing received interrupt signal: aborting.";
    }

    protected String massIndexingFirstFailure$str() {
        return "HSEARCH700042: %1$s failure(s) occurred during mass indexing. See the logs for details. First failure: %2$s";
    }

    @Override
    public final SearchException massIndexingFirstFailure(long finalFailureCount, String firstFailureMessage, Throwable firstFailure) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.massIndexingFirstFailure$str(), finalFailureCount, firstFailureMessage), firstFailure);
        MassIndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String massIndexingFirstFailureOnEntity$str() {
        return "HSEARCH700101: %1$s failure(s) occurred during mass indexing. See the logs for details. First failure on entity '%2$s': %3$s";
    }

    @Override
    public final SearchException massIndexingFirstFailureOnEntity(long finalFailureCount, Object firstFailureEntity, String firstFailureMessage, Throwable firstFailure) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.massIndexingFirstFailureOnEntity$str(), finalFailureCount, firstFailureEntity, firstFailureMessage), firstFailure);
        MassIndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void failureInMassIndexingFailureHandler(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failureInMassIndexingFailureHandler$str(), new Object[0]);
    }

    protected String failureInMassIndexingFailureHandler$str() {
        return "HSEARCH700102: The mass indexing failure handler threw an exception while handling a previous failure. The failure may not have been reported.";
    }

    protected String massIndexingThreadInterrupted$str() {
        return "HSEARCH700103: Mass indexing received interrupt signal. The index is left in an unknown state!";
    }

    @Override
    public final SearchException massIndexingThreadInterrupted(InterruptedException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.massIndexingThreadInterrupted$str(), new Object[0]), (Throwable)e);
        MassIndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void redundantPurgeAfterDrop() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.redundantPurgeAfterDrop$str(), new Object[0]);
    }

    protected String redundantPurgeAfterDrop$str() {
        return "HSEARCH700120: Both \"dropAndCreateSchemaOnStart()\" and \"purgeAllOnStart()\" are enabled. Consider having just one setting enabled as after the index is recreated there is nothing to purge.";
    }

    protected String notReportedFailures$str() {
        return "HSEARCH700125: %1$s failures went unreported for this operation to avoid flooding. To disable flooding protection, use 'massIndexer.failureFloodingThreshold(Long.MAX_VALUE)'.";
    }

    @Override
    public final SearchException notReportedFailures(long count) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.notReportedFailures$str(), count));
        MassIndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String schemaDropNotAllowedWithMultitenancy$str() {
        return "HSEARCH700160: Requesting a schema drop-create on start is not allowed when multitenancy is enabled. Schema would be dropped for all tenants, but data will only be indexed for tenant ids '%1$s'. Do not use the schema drop-create on start when providing tenant ids. If schema drop is actually required, do it through an SearchSchemaManager.";
    }

    @Override
    public final SearchException schemaDropNotAllowedWithMultitenancy(Set<String> tenantIds) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.schemaDropNotAllowedWithMultitenancy$str(), tenantIds));
        MassIndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidMassIndexingDefaultCleanOperation$str() {
        return "HSEARCH700161: Invalid mass indexing default clean operation name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidMassIndexingDefaultCleanOperation(String name, List<String> names) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidMassIndexingDefaultCleanOperation$str(), name, names));
        MassIndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String massIndexerFailFast$str() {
        return "HSEARCH700163: Mass indexer running in a fail fast mode encountered a problem. Stopping the process.";
    }

    @Override
    public final MassIndexingOperationHandledFailureException massIndexerFailFast() {
        MassIndexingOperationHandledFailureException result = new MassIndexingOperationHandledFailureException(String.format(this.getLoggingLocale(), this.massIndexerFailFast$str(), new Object[0]));
        MassIndexingLog_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    @Override
    public final void indexingProgress(long doneCount, long typesToIndex, float currentSpeed, float estimateSpeed) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingProgress4$str(), new Object[]{doneCount, typesToIndex, Float.valueOf(currentSpeed), Float.valueOf(estimateSpeed)});
    }

    protected String indexingProgress4$str() {
        return "HSEARCH700164: Mass indexed %1$d. Speed: %3$.2f/s instant, %4$.2f/s since start. Remaining: unknown, %2$d type(s) pending.";
    }

    @Override
    public final void indexingProgress(long doneCount, float currentSpeed, float estimateSpeed) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingProgress3$str(), (Object)doneCount, (Object)Float.valueOf(currentSpeed), (Object)Float.valueOf(estimateSpeed));
    }

    protected String indexingProgress3$str() {
        return "HSEARCH700165: Mass indexed %1$d. Speed: %2$.2f/s instant, %3$.2f/s since start. Remaining: unknown.";
    }

    @Override
    public final void indexingProgress(float estimatePercentileComplete, long doneCount, long totalCount, float currentSpeed, float estimateSpeed, long remainingCount, long typesToIndex) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingProgress7$str(), new Object[]{Float.valueOf(estimatePercentileComplete), doneCount, totalCount, Float.valueOf(currentSpeed), Float.valueOf(estimateSpeed), remainingCount, typesToIndex});
    }

    protected String indexingProgress7$str() {
        return "HSEARCH700166: Mass indexed %1$.2f%% %2$d/%3$d. Speed: %4$.2f/s instant, %5$.2f/s since start. Remaining: %6$d, %7$d type(s) pending.";
    }

    @Override
    public final void indexingProgressWithRemainingTime(float estimatePercentileComplete, long doneCount, long totalCount, float currentSpeed, float estimateSpeed, long remainingCount, Duration timeToFinish) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingProgressWithRemainingTime$str(), new Object[]{Float.valueOf(estimatePercentileComplete), doneCount, totalCount, Float.valueOf(currentSpeed), Float.valueOf(estimateSpeed), remainingCount, timeToFinish});
    }

    protected String indexingProgressWithRemainingTime$str() {
        return "HSEARCH700167: Mass indexed %1$.2f%% %2$d/%3$d. Speed: %4$.2f/s instant, %5$.2f/s since start. Remaining: %6$d, approx. %7$s.";
    }

    @Override
    public final void indexingEntitiesCompleted(long indexed, long total, Duration indexingTime) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntitiesCompleted$str(), (Object)indexed, (Object)total, (Object)indexingTime);
    }

    protected String indexingEntitiesCompleted$str() {
        return "HSEARCH700168: Mass indexing complete in %3$s. Indexed %1$d/%2$d entities.";
    }

    @Override
    public final void indexingEntitiesApprox(long count, String types) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntitiesApprox$str(), (Object)count, (Object)types);
    }

    protected String indexingEntitiesApprox$str() {
        return "HSEARCH700169: Mass indexing is going to index approx. %1$d entities (%2$s). Actual number may change once the indexing starts.";
    }

    @Override
    public final void indexingForTypeGroupDone(String typeGroup) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.indexingForTypeGroupDone$str(), (Object)typeGroup);
    }

    protected String indexingForTypeGroupDone$str() {
        return "HSEARCH700172: Indexing for %s is done.";
    }

    @Override
    public final void identifierLoadingStarted(String typeGroup) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.identifierLoadingStarted$str(), (Object)typeGroup);
    }

    protected String identifierLoadingStarted$str() {
        return "HSEARCH700173: Identifier loading for %s started.";
    }

    @Override
    public final void identifierLoadingFinished(String typeGroup) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.identifierLoadingFinished$str(), (Object)typeGroup);
    }

    protected String identifierLoadingFinished$str() {
        return "HSEARCH700174: Identifier loading for %s finished.";
    }

    @Override
    public final void identifierLoadingLoadedIds(List<?> ids) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.identifierLoadingLoadedIds$str(), ids);
    }

    protected String identifierLoadingLoadedIds$str() {
        return "HSEARCH700175: Identifier loading produced a list of ids: %s.";
    }

    @Override
    public final void entityLoadingStarted(String typeGroup) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.entityLoadingStarted$str(), (Object)typeGroup);
    }

    protected String entityLoadingStarted$str() {
        return "HSEARCH700176: Entity loading for %s started.";
    }

    @Override
    public final void entityLoadingFinished(String typeGroup) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.entityLoadingFinished$str(), (Object)typeGroup);
    }

    protected String entityLoadingFinished$str() {
        return "HSEARCH700177: Entity loading for %s finished.";
    }

    @Override
    public final void entityLoadingAttemptToLoadIds(List<?> ids) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.entityLoadingAttemptToLoadIds$str(), ids);
    }

    protected String entityLoadingAttemptToLoadIds$str() {
        return "HSEARCH700178: Entity loading will attempt to load entities for ids: %s.";
    }
}

