/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.builtin;

import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.engine.search.projection.definition.spi.ConstantProjectionDefinition;
import org.hibernate.search.engine.search.projection.definition.spi.FieldProjectionDefinition;
import org.hibernate.search.mapper.pojo.logging.impl.ProjectionLog;
import org.hibernate.search.mapper.pojo.model.PojoModelValue;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingContext;

public final class FieldProjectionBinder
implements ProjectionBinder {
    private final String fieldPathOrNull;
    private ValueModel valueModel = ValueModel.MAPPING;

    public static FieldProjectionBinder create() {
        return FieldProjectionBinder.create(null);
    }

    public static FieldProjectionBinder create(String fieldPath) {
        return new FieldProjectionBinder(fieldPath);
    }

    private FieldProjectionBinder(String fieldPathOrNull) {
        this.fieldPathOrNull = fieldPathOrNull;
    }

    @Deprecated
    public FieldProjectionBinder valueConvert(ValueConvert valueConvert) {
        return this.valueModel(ValueConvert.toValueModel((ValueConvert)valueConvert));
    }

    public FieldProjectionBinder valueModel(ValueModel valueModel) {
        this.valueModel = valueModel;
        return this;
    }

    @Override
    public void bind(ProjectionBindingContext context) {
        Class<?> containerClass;
        Class<?> containerElementClass;
        Optional<PojoModelValue<?>> containerElementOptional = context.containerElement();
        String fieldPath = this.fieldPathOrFail(context);
        if (containerElementOptional.isPresent()) {
            PojoModelValue<?> containerElement = containerElementOptional.get();
            containerElementClass = containerElement.rawType();
            containerClass = context.constructorParameter().rawType();
        } else {
            containerElementClass = context.constructorParameter().rawType();
            containerClass = null;
        }
        this.bind(context, fieldPath, containerClass, containerElementClass);
    }

    private <T, C> void bind(ProjectionBindingContext context, String fieldPath, Class<C> containerType, Class<T> containerElementType) {
        ProjectionCollector.Provider collector = context.projectionCollectorProviderFactory().projectionCollectorProvider(containerType, containerElementType);
        context.definition(containerElementType, context.isIncluded(fieldPath) ? BeanHolder.of((Object)new FieldProjectionDefinition.AccumulatedValued(fieldPath, containerElementType, collector, this.valueModel)) : ConstantProjectionDefinition.empty((ProjectionCollector.Provider)collector));
    }

    private String fieldPathOrFail(ProjectionBindingContext context) {
        if (this.fieldPathOrNull != null) {
            return this.fieldPathOrNull;
        }
        Optional<String> paramName = context.constructorParameter().name();
        if (!paramName.isPresent()) {
            throw ProjectionLog.INSTANCE.missingParameterNameForFieldProjectionInProjectionConstructor();
        }
        return paramName.get();
    }
}

