/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.search.projection.definition.ProjectionDefinition;
import org.hibernate.search.engine.search.projection.definition.spi.ConstantProjectionDefinition;
import org.hibernate.search.mapper.pojo.logging.impl.ProjectionLog;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoSearchMappingConstructorNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoSearchMappingMethodParameterNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelConstructorParameterRootElement;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoMethodParameterModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.impl.ProjectionBindingContextImpl;
import org.hibernate.search.mapper.pojo.search.definition.binding.impl.ProjectionConstructorBinder;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

class ProjectionConstructorParameterBinder<P>
implements EventContextProvider {
    final PojoMappingHelper mappingHelper;
    final ProjectionConstructorBinder<?> parent;
    final PojoMethodParameterModel<P> parameter;
    final PojoModelConstructorParameterRootElement<P> parameterRootElement;

    ProjectionConstructorParameterBinder(PojoMappingHelper mappingHelper, ProjectionConstructorBinder<?> parent, PojoMethodParameterModel<P> parameter) {
        this.mappingHelper = mappingHelper;
        this.parent = parent;
        this.parameter = parameter;
        this.parameterRootElement = new PojoModelConstructorParameterRootElement<P>(mappingHelper.introspector(), parameter);
    }

    public EventContext eventContext() {
        return this.parent.eventContext().append(PojoEventContexts.fromMethodParameter(this.parameter));
    }

    BeanHolder<? extends ProjectionDefinition<?>> bind() {
        if (this.parameter.isEnclosingInstance()) {
            return ConstantProjectionDefinition.nullValue();
        }
        BeanHolder result = null;
        for (PojoTypeMetadataContributor contributor : this.mappingHelper.contributorProvider().getIgnoringInheritance(this.parent.constructor.typeModel())) {
            Optional<PojoSearchMappingMethodParameterNode> parameterMapping;
            PojoSearchMappingConstructorNode constructorMapping = contributor.constructors().get(Arrays.asList(this.parent.constructor.parametersJavaTypes()));
            if (constructorMapping == null || !(parameterMapping = constructorMapping.parameterNode(this.parameter.index())).isPresent()) continue;
            for (PojoSearchMappingMethodParameterNode.ProjectionBindingData projectionDefinition : parameterMapping.get().projectionBindings()) {
                if (result != null) {
                    throw ProjectionLog.INSTANCE.multipleProjectionMappingsForParameter();
                }
                ProjectionBindingContextImpl bindingContext = new ProjectionBindingContextImpl(this, projectionDefinition.params);
                result = this.applyBinder(bindingContext, projectionDefinition.reference);
            }
        }
        if (result != null) {
            return result;
        }
        ProjectionBindingContextImpl bindingContext = new ProjectionBindingContextImpl(this, Collections.emptyMap());
        return bindingContext.applyDefaultProjection();
    }

    private BeanHolder<? extends ProjectionDefinition<?>> applyBinder(ProjectionBindingContextImpl<?> context, BeanReference<? extends ProjectionBinder> binderReference) {
        BeanHolder<ProjectionDefinition<?>> beanHolder;
        block8: {
            BeanHolder<ProjectionDefinition<?>> definitionHolder = null;
            BeanHolder binderHolder = this.mappingHelper.beanResolver().resolve(binderReference);
            try {
                beanHolder = definitionHolder = context.applyBinder((ProjectionBinder)binderHolder.get());
                if (binderHolder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (binderHolder != null) {
                        try {
                            binderHolder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    new SuppressingCloser((Throwable)e).push(definitionHolder);
                    throw e;
                }
            }
            binderHolder.close();
        }
        return beanHolder;
    }

    <T> PojoConstructorModel<T> findProjectionConstructorOrNull(PojoRawTypeModel<T> projectedType) {
        PojoSearchMappingConstructorNode result = null;
        for (PojoTypeMetadataContributor contributor : this.mappingHelper.contributorProvider().getIgnoringInheritance(projectedType)) {
            for (PojoSearchMappingConstructorNode pojoSearchMappingConstructorNode : contributor.constructors().values()) {
                if (!pojoSearchMappingConstructorNode.isProjectionConstructor()) continue;
                if (result != null) {
                    throw ProjectionLog.INSTANCE.multipleProjectionConstructorsForType(projectedType.typeIdentifier().javaClass());
                }
                result = pojoSearchMappingConstructorNode;
            }
        }
        return result == null ? null : projectedType.constructor(result.parametersJavaTypes());
    }
}

