/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.search.projection.definition.spi.ProjectionRegistry;
import org.hibernate.search.engine.search.projection.spi.ProjectionMappedTypeContext;
import org.hibernate.search.engine.tenancy.spi.TenancyMode;
import org.hibernate.search.mapper.pojo.common.spi.PojoEntityReferenceFactoryDelegate;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContextProvider;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoEntityReferenceFactory;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoRawTypeIdentifierResolver;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeDelegateImpl;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeMappingContext;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeTypeExtendedContextProvider;
import org.hibernate.search.mapper.pojo.search.definition.impl.PojoSearchQueryElementRegistry;
import org.hibernate.search.mapper.pojo.work.SearchIndexingPlanFilter;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexerImpl;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexingPlanEventProcessingStrategy;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexingPlanEventSendingStrategy;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexingPlanImpl;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexingPlanLocalStrategy;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexingQueueEventProcessingPlanImpl;
import org.hibernate.search.mapper.pojo.work.impl.SearchIndexingPlanFilterContextImpl;
import org.hibernate.search.mapper.pojo.work.spi.ConfiguredSearchIndexingPlanFilter;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventProcessingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventSendingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;

public class PojoMappingDelegateImpl
implements PojoMappingDelegate {
    private final ThreadPoolProvider threadPoolProvider;
    private final FailureHandler failureHandler;
    private final TenancyMode tenancyMode;
    private final PojoTypeManagerContainer typeManagers;
    private final PojoSearchQueryElementRegistry searchQueryElementRegistry;

    public PojoMappingDelegateImpl(ThreadPoolProvider threadPoolProvider, FailureHandler failureHandler, TenancyMode tenancyMode, PojoTypeManagerContainer typeManagers, PojoSearchQueryElementRegistry searchQueryElementRegistry) {
        this.threadPoolProvider = threadPoolProvider;
        this.failureHandler = failureHandler;
        this.tenancyMode = tenancyMode;
        this.typeManagers = typeManagers;
        this.searchQueryElementRegistry = searchQueryElementRegistry;
    }

    @Override
    public void close() {
        this.typeManagers.close();
    }

    @Override
    public ThreadPoolProvider threadPoolProvider() {
        return this.threadPoolProvider;
    }

    @Override
    public FailureHandler failureHandler() {
        return this.failureHandler;
    }

    @Override
    public PojoRawTypeIdentifierResolver typeIdentifierResolver() {
        return this.typeManagers;
    }

    @Override
    public PojoLoadingTypeContextProvider typeContextProvider() {
        return this.typeManagers;
    }

    @Override
    public TenancyMode tenancyMode() {
        return this.tenancyMode;
    }

    @Override
    public ProjectionRegistry projectionRegistry() {
        return this.searchQueryElementRegistry;
    }

    @Override
    public ProjectionMappedTypeContext mappedTypeContext(String name) {
        return (ProjectionMappedTypeContext)this.typeManagers.indexedByEntityName().getOrFail((Object)name);
    }

    @Override
    public PojoEntityReferenceFactory createEntityReferenceFactory(PojoEntityReferenceFactoryDelegate delegate) {
        return new PojoEntityReferenceFactory(delegate, this.typeManagers);
    }

    @Override
    public <SR, R extends EntityReference, E, C> PojoScopeDelegate<SR, R, E, C> createPojoScopeForClasses(PojoScopeMappingContext mappingContext, Collection<? extends Class<? extends E>> classes, PojoScopeTypeExtendedContextProvider<E, C> indexedTypeExtendedContextProvider) {
        if (classes.isEmpty()) {
            throw MappingLog.INSTANCE.invalidEmptyTargetForScope();
        }
        return PojoScopeDelegateImpl.create(mappingContext, this.typeManagers, this.typeManagers.indexedForSuperTypeClasses(classes), indexedTypeExtendedContextProvider);
    }

    @Override
    public <SR, R extends EntityReference, E, C> PojoScopeDelegate<SR, R, E, C> createPojoScopeForEntityNames(PojoScopeMappingContext mappingContext, Class<E> expectedSuperType, Collection<String> entityNames, PojoScopeTypeExtendedContextProvider<E, C> indexedTypeExtendedContextProvider) {
        if (entityNames.isEmpty()) {
            throw MappingLog.INSTANCE.invalidEmptyTargetForScope();
        }
        Set<PojoIndexedTypeManager<?, ?>> typeContexts = this.typeManagers.indexedForSuperTypeEntityNames(entityNames);
        for (PojoIndexedTypeManager<?, ?> typeContext : typeContexts) {
            Class actualJavaType = typeContext.typeIdentifier().javaClass();
            if (expectedSuperType.isAssignableFrom(actualJavaType)) continue;
            throw MappingLog.INSTANCE.invalidEntitySuperType(typeContext.name(), expectedSuperType, actualJavaType);
        }
        return PojoScopeDelegateImpl.create(mappingContext, this.typeManagers, typeContexts, indexedTypeExtendedContextProvider);
    }

    @Override
    @Deprecated(since="7.1")
    public <SR, R extends EntityReference, E, C> PojoScopeDelegate<SR, R, E, C> createPojoScope(PojoScopeMappingContext mappingContext, Collection<? extends PojoRawTypeIdentifier<? extends E>> targetedTypes, PojoScopeTypeExtendedContextProvider<E, C> indexedTypeExtendedContextProvider) {
        if (targetedTypes.isEmpty()) {
            throw MappingLog.INSTANCE.invalidEmptyTargetForScope();
        }
        return PojoScopeDelegateImpl.create(mappingContext, this.typeManagers, this.typeManagers.indexedForSuperTypes(targetedTypes), indexedTypeExtendedContextProvider);
    }

    @Override
    public <SR, R extends EntityReference, C> Optional<PojoScopeDelegate<SR, R, Object, C>> createPojoAllScope(PojoScopeMappingContext mappingContext, PojoScopeTypeExtendedContextProvider<Object, C> indexedTypeExtendedContextProvider) {
        if (this.typeManagers.allIndexed().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(PojoScopeDelegateImpl.create(mappingContext, this.typeManagers, this.typeManagers.allIndexed(), indexedTypeExtendedContextProvider));
    }

    @Override
    public PojoIndexingPlan createIndexingPlan(PojoWorkSessionContext context, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return new PojoIndexingPlanImpl(this.typeManagers, context, new PojoIndexingPlanLocalStrategy(commitStrategy, refreshStrategy));
    }

    @Override
    public PojoIndexingPlan createIndexingPlan(PojoWorkSessionContext context, PojoIndexingQueueEventSendingPlan sendingPlan) {
        return new PojoIndexingPlanImpl(this.typeManagers, context, new PojoIndexingPlanEventSendingStrategy(sendingPlan));
    }

    @Override
    public PojoIndexingQueueEventProcessingPlan createEventProcessingPlan(PojoWorkSessionContext context, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy, PojoIndexingQueueEventSendingPlan sendingPlan) {
        return new PojoIndexingQueueEventProcessingPlanImpl(this.typeManagers, context, new PojoIndexingPlanImpl(this.typeManagers, context, new PojoIndexingPlanEventProcessingStrategy(commitStrategy, refreshStrategy, sendingPlan)));
    }

    @Override
    public PojoIndexer createIndexer(PojoWorkSessionContext context) {
        return new PojoIndexerImpl(this.typeManagers, context);
    }

    @Override
    public ConfiguredSearchIndexingPlanFilter configuredSearchIndexingPlanFilter(SearchIndexingPlanFilter filter, ConfiguredSearchIndexingPlanFilter fallback) {
        SearchIndexingPlanFilterContextImpl context = new SearchIndexingPlanFilterContextImpl(this.typeManagers);
        filter.apply(context);
        return context.createFilter(fallback);
    }
}

