/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.mapper.pojo.logging.impl.ProjectionLog;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.path.spi.ProjectionConstructorPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.search.definition.impl.ConstructorProjectionApplicationException;
import org.hibernate.search.mapper.pojo.search.definition.impl.PojoConstructorProjectionDefinition;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter;
import org.hibernate.search.util.common.logging.impl.ToStringTreeMultilineFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;

public class ProjectionLog_$logger
implements ProjectionLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ProjectionLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public ProjectionLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String invalidObjectClassForProjection$str() {
        return "HSEARCH700112: Invalid object class for projection: %1$s. Make sure that this class is mapped correctly, either through annotations (@ProjectionConstructor) or programmatic mapping. If it is, make sure the class is included in a Jandex index made available to Hibernate Search.";
    }

    @Override
    public final SearchException invalidObjectClassForProjection(Class<?> objectClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidObjectClassForProjection$str(), new ClassFormatter(objectClass)));
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String invalidAbstractTypeForProjectionConstructor$str() {
        return "HSEARCH700113: Invalid declaring type for projection constructor: type '%1$s' is abstract. Projection constructors can only be declared on concrete types.";
    }

    @Override
    public final SearchException invalidAbstractTypeForProjectionConstructor(PojoRawTypeModel<?> typeModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAbstractTypeForProjectionConstructor$str(), new PojoTypeModelFormatter(typeModel)));
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingParameterNameForInferredProjection$str() {
        return "HSEARCH700114: Missing parameter names in Java metadata for projection constructor. When inferring inner projections from constructor parameters, constructor parameter names must be known. Either make sure this class was compiled with the '-parameters' compiler flag, or set the path explicitly with '@FieldProjection(path = ...)' or '@ObjectProjection(path = ...)'.";
    }

    @Override
    public final SearchException missingParameterNameForInferredProjection() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingParameterNameForInferredProjection$str(), new Object[0]));
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidMultiValuedParameterTypeForProjectionConstructor$str() {
        return "HSEARCH700115: Invalid parameter type for projection constructor: %1$s. When inferring the cardinality of inner projections from constructor parameters, multi-valued constructor parameters must be lists/sets (java.util.List<...>/java.util.Set<...>/java.util.SortedSet<...>), their supertypes (java.lang.Iterable<...>, java.util.Collection<...>) or arrays";
    }

    @Override
    public final SearchException invalidMultiValuedParameterTypeForProjectionConstructor(PojoTypeModel<?> parentTypeModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidMultiValuedParameterTypeForProjectionConstructor$str(), new PojoTypeModelFormatter(parentTypeModel)));
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleProjectionConstructorsForType$str() {
        return "HSEARCH700116: Multiple projection constructor are mapped for type '%1$s'. At most one projection constructor is allowed for each type.";
    }

    @Override
    public final SearchException multipleProjectionConstructorsForType(Class<?> instantiatedJavaClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleProjectionConstructorsForType$str(), instantiatedJavaClass));
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void constructorProjection(PojoRawTypeModel<?> typeModel, PojoConstructorProjectionDefinition<?> projectionDefinition) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.constructorProjection$str(), (Object)new PojoTypeModelFormatter(typeModel), (Object)new ToStringTreeMultilineFormatter(projectionDefinition));
    }

    protected String constructorProjection$str() {
        return "HSEARCH700117: Constructor projection for type '%1$s': %2$s";
    }

    protected String objectProjectionCyclicRecursion$str() {
        return "HSEARCH700118: Cyclic recursion starting from '%1$s' on %2$s. Index field path starting from that location and ending with a cycle: '%3$s'. A projection constructor cannot declare an unrestricted @ObjectProjection to itself, even indirectly. To break the cycle, you should consider adding filters to your @ObjectProjection: includePaths, includeDepth, excludePaths, ...";
    }

    @Override
    public final SearchException objectProjectionCyclicRecursion(MappingElement objectProjection, EventContext objectProjectionLocation, String cyclicRecursionIndexFieldPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.objectProjectionCyclicRecursion$str(), objectProjection, new EventContextNoPrefixFormatter(objectProjectionLocation), cyclicRecursionIndexFieldPath));
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorApplyingProjectionConstructor$str() {
        return "HSEARCH700123: Could not apply projection constructor: %1$s";
    }

    @Override
    public final ConstructorProjectionApplicationException errorApplyingProjectionConstructor(String causeMessage, Exception cause, ProjectionConstructorPath path) {
        ConstructorProjectionApplicationException result = new ConstructorProjectionApplicationException(String.format(this.getLoggingLocale(), this.errorApplyingProjectionConstructor$str(), causeMessage), cause, path);
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String multipleProjectionMappingsForParameter$str() {
        return "HSEARCH700134: Multiple projections are mapped for this parameter. At most one projection is allowed for each parameter.";
    }

    @Override
    public final SearchException multipleProjectionMappingsForParameter() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleProjectionMappingsForParameter$str(), new Object[0]));
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingProjectionDefinitionForBinder$str() {
        return "HSEARCH700135: Incorrect binder implementation: binder '%1$s' did not call context.definition(...).";
    }

    @Override
    public final SearchException missingProjectionDefinitionForBinder(Object binder) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingProjectionDefinitionForBinder$str(), binder));
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidOutputTypeForProjectionDefinition$str() {
        return "HSEARCH700136: Invalid projection definition for constructor parameter type '%2$s': '%1$s'. This projection results in values of type '%3$s'.";
    }

    @Override
    public final SearchException invalidOutputTypeForProjectionDefinition(Object definition, PojoTypeModel<?> typeModel, PojoTypeModel<?> expectedValueModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidOutputTypeForProjectionDefinition$str(), definition, new PojoTypeModelFormatter(typeModel), new PojoTypeModelFormatter(expectedValueModel)));
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidOutputTypeForMultiValuedProjectionDefinition$str() {
        return "HSEARCH700137: Invalid multi-valued projection definition for constructor parameter type '%2$s': '%1$s'. This projection results in values of type '%3$s'.";
    }

    @Override
    public final SearchException invalidOutputTypeForMultiValuedProjectionDefinition(Object definition, PojoTypeModel<?> typeModel, PojoTypeModel<?> expectedValueModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidOutputTypeForMultiValuedProjectionDefinition$str(), definition, new PojoTypeModelFormatter(typeModel), new PojoTypeModelFormatter(expectedValueModel)));
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingParameterNameForFieldProjectionInProjectionConstructor$str() {
        return "HSEARCH700138: Missing parameter names in Java metadata for projection constructor. When mapping a projection constructor parameter to a field projection without providing a field path, constructor parameter names must be known. Either make sure this class was compiled with the '-parameters' compiler flag, or set the path explicitly with '@FieldProjection(path = ...)'.";
    }

    @Override
    public final SearchException missingParameterNameForFieldProjectionInProjectionConstructor() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingParameterNameForFieldProjectionInProjectionConstructor$str(), new Object[0]));
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingParameterNameForObjectProjectionInProjectionConstructor$str() {
        return "HSEARCH700139: Missing parameter names in Java metadata for projection constructor. When mapping a projection constructor parameter to an object projection without providing a field path, constructor parameter names must be known. Either make sure this class was compiled with the '-parameters' compiler flag, or set the path explicitly with '@ObjectProjection(path = ...)'.";
    }

    @Override
    public final SearchException missingParameterNameForObjectProjectionInProjectionConstructor() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingParameterNameForObjectProjectionInProjectionConstructor$str(), new Object[0]));
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingParameterNameForHighlightProjectionInProjectionConstructor$str() {
        return "HSEARCH700140: Missing parameter names in Java metadata for projection constructor. When mapping a projection constructor parameter to a highlight projection without providing a field path, constructor parameter names must be known. Either make sure this class was compiled with the '-parameters' compiler flag, or set the path explicitly with '@HighlightProjection(path = ...)'.";
    }

    @Override
    public final SearchException missingParameterNameForHighlightProjectionInProjectionConstructor() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingParameterNameForHighlightProjectionInProjectionConstructor$str(), new Object[0]));
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidParameterTypeForHighlightProjectionInProjectionConstructor$str() {
        return "HSEARCH700141: Invalid constructor parameter type: '%1$s'. The highlight projection results in values of type '%2$s'.";
    }

    @Override
    public final SearchException invalidParameterTypeForHighlightProjectionInProjectionConstructor(Class<?> rawClass, String expectedClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidParameterTypeForHighlightProjectionInProjectionConstructor$str(), new ClassFormatter(rawClass), expectedClass));
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidParameterTypeForDistanceProjectionInProjectionConstructor$str() {
        return "HSEARCH700159: Invalid constructor parameter type: '%1$s'. The distance projection results in values of type '%2$s'.";
    }

    @Override
    public final SearchException invalidParameterTypeForDistanceProjectionInProjectionConstructor(Class<?> rawClass, String expectedClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidParameterTypeForDistanceProjectionInProjectionConstructor$str(), new ClassFormatter(rawClass), expectedClass));
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotBindSortedSetWithNonComparableElements$str() {
        return "HSEARCH700171: Implicit binding of a java.util.SortedSet<%1$s> constructor parameter is not possible since %1$s is not implementing java.lang.Comparable. Either make %1$s implement java.lang.Comparable or create a custom @ProjectionBinding and use the ProjectionCollector.sortedSet(comparator) collector provider in it.";
    }

    @Override
    public final SearchException cannotBindSortedSetWithNonComparableElements(Class<?> elementType, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotBindSortedSetWithNonComparableElements$str(), new ClassFormatter(elementType)), eventContext);
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullEnclosingParameterInProjectionConstructorNotAllowed$str() {
        return "HSEARCH700179: An enclosing instance constructor parameter on a projection constructor is not allowed. Make the projection class either static, or a top-level class to remove the enclosing instance constructor parameter.";
    }

    @Override
    public final SearchException nullEnclosingParameterInProjectionConstructorNotAllowed(EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullEnclosingParameterInProjectionConstructorNotAllowed$str(), new Object[0]), eventContext);
        ProjectionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

