/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.mapper.pojo.logging.impl.IndexingLog;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.SearchIndexingPlanFilterContext;
import org.hibernate.search.mapper.pojo.work.spi.ConfiguredSearchIndexingPlanFilter;

public class SearchIndexingPlanFilterContextImpl
implements SearchIndexingPlanFilterContext {
    private final PojoScopeTypeContextProvider contextProvider;
    private final Set<PojoRawTypeIdentifier<?>> includes = new HashSet();
    private final Set<PojoRawTypeIdentifier<?>> excludes = new HashSet();

    public SearchIndexingPlanFilterContextImpl(PojoScopeTypeContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public SearchIndexingPlanFilterContext include(String name) {
        this.addIfNotPresentInOther((PojoRawTypeIdentifier)this.contextProvider.nonInterfaceSuperTypeIdentifierByEntityName().getOrFail((Object)name), this.includes, this.excludes);
        return this;
    }

    @Override
    public SearchIndexingPlanFilterContext include(Class<?> clazz) {
        this.addIfNotPresentInOther(this.contextProvider.nonInterfaceSuperTypeIdentifierForClass(clazz), this.includes, this.excludes);
        return this;
    }

    @Override
    public SearchIndexingPlanFilterContext exclude(String name) {
        this.addIfNotPresentInOther((PojoRawTypeIdentifier)this.contextProvider.nonInterfaceSuperTypeIdentifierByEntityName().getOrFail((Object)name), this.excludes, this.includes);
        return this;
    }

    @Override
    public SearchIndexingPlanFilterContext exclude(Class<?> clazz) {
        this.addIfNotPresentInOther(this.contextProvider.nonInterfaceSuperTypeIdentifierForClass(clazz), this.excludes, this.includes);
        return this;
    }

    public ConfiguredSearchIndexingPlanFilter createFilter(ConfiguredSearchIndexingPlanFilter fallback) {
        HashSet allIncludes = new HashSet();
        HashSet allExcludes = new HashSet();
        HashSet processedByThisContext = new HashSet();
        Set<PojoRawTypeIdentifier<?>> allIndexedAndContainedTypes = this.contextProvider.allIndexedAndContainedTypes();
        for (PojoRawTypeIdentifier<?> typeIdentifier : this.contextProvider.allNonInterfaceSuperTypes()) {
            if (this.includes.contains(typeIdentifier)) {
                this.include(allIncludes, allExcludes, processedByThisContext, typeIdentifier);
                continue;
            }
            if (!this.excludes.contains(typeIdentifier)) continue;
            this.exclude(allIncludes, allExcludes, processedByThisContext, typeIdentifier);
        }
        for (PojoRawTypeIdentifier<?> typeIdentifier : allIndexedAndContainedTypes) {
            if (processedByThisContext.contains(typeIdentifier)) continue;
            if (fallback == null || fallback.isIncluded(typeIdentifier)) {
                allIncludes.add(typeIdentifier);
                continue;
            }
            allExcludes.add(typeIdentifier);
        }
        return ConfiguredSearchIndexingPlanFilter.create(Collections.unmodifiableSet(allIncludes), Collections.unmodifiableSet(allExcludes));
    }

    private void exclude(Set<PojoRawTypeIdentifier<?>> allIncludes, Set<PojoRawTypeIdentifier<?>> allExcludes, Set<PojoRawTypeIdentifier<?>> processed, PojoRawTypeIdentifier<?> typeIdentifier) {
        this.contextProvider.forNonInterfaceSuperType(typeIdentifier).forEach(typeContext -> {
            PojoRawTypeIdentifier identifier = typeContext.typeIdentifier();
            allIncludes.remove(identifier);
            allExcludes.add(identifier);
            processed.add(identifier);
        });
    }

    private void include(Set<PojoRawTypeIdentifier<?>> allIncludes, Set<PojoRawTypeIdentifier<?>> allExcludes, Set<PojoRawTypeIdentifier<?>> processed, PojoRawTypeIdentifier<?> typeIdentifier) {
        this.contextProvider.forNonInterfaceSuperType(typeIdentifier).forEach(typeContext -> {
            PojoRawTypeIdentifier identifier = typeContext.typeIdentifier();
            allIncludes.add(identifier);
            allExcludes.remove(identifier);
            processed.add(identifier);
        });
    }

    private boolean addIfNotPresentInOther(PojoRawTypeIdentifier<?> typeIdentifier, Set<PojoRawTypeIdentifier<?>> a, Set<PojoRawTypeIdentifier<?>> b) {
        if (b.contains(typeIdentifier)) {
            throw IndexingLog.INSTANCE.indexingPlanFilterCannotIncludeExcludeSameType(typeIdentifier, this.includes, this.excludes);
        }
        return a.add(typeIdentifier);
    }
}

