/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.mapper.pojo.logging.impl.MassIndexingLog;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingEntityFailureContext;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingFailureContext;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingFailureHandler;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingMonitor;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingTypeGroupMonitor;
import org.hibernate.search.mapper.pojo.massindexing.impl.MassIndexingTypeGroupContext;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeGroup;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingSessionContext;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoMassIndexerMessages;

public class PojoMassIndexingNotifier {
    private final MassIndexingFailureHandler failureHandler;
    private final MassIndexingMonitor monitor;
    private final AtomicReference<RecordedFailure> firstFailure = new AtomicReference<Object>(null);
    private final LongAdder failureCount = new LongAdder();
    private final Map<String, AtomicLong> failureCounts = Collections.synchronizedMap(new HashMap());
    private final long failureFloodingThreshold;

    public PojoMassIndexingNotifier(MassIndexingFailureHandler failureHandler, MassIndexingMonitor monitor, Long failureFloodingThreshold) {
        this.failureHandler = failureHandler;
        this.monitor = monitor;
        this.failureFloodingThreshold = Optional.ofNullable(failureFloodingThreshold).orElseGet(failureHandler::failureFloodingThreshold);
    }

    MassIndexingTypeGroupMonitor typeGroupMonitor(MassIndexingTypeGroupContext<?> context) {
        return this.monitor.typeGroupMonitor(context);
    }

    void reportError(Error error) {
        RecordedFailure recordedFailure = new RecordedFailure(error);
        this.firstFailure.compareAndSet(null, recordedFailure);
    }

    void reportInterrupted(InterruptedException exception) {
        RecordedFailure recordedFailure = new RecordedFailure(exception);
        boolean isFirst = this.firstFailure.compareAndSet(null, recordedFailure);
        if (isFirst) {
            MassIndexingLog.INSTANCE.interruptedBatchIndexing();
        }
    }

    void reportRunnableFailure(Exception exception, String operation) {
        this.recordFailure(exception, true);
        MassIndexingFailureContext.Builder contextBuilder = MassIndexingFailureContext.builder();
        contextBuilder.throwable(exception);
        contextBuilder.failingOperation(operation);
        this.failureHandler.handle(contextBuilder.build());
    }

    void reportEntitiesLoaded(int size) {
        this.monitor.entitiesLoaded(size);
    }

    void reportDocumentBuilt() {
        this.monitor.documentsBuilt(1L);
    }

    void reportDocumentsAdded(int size) {
        this.monitor.documentsAdded(size);
    }

    void reportEntityIndexingFailure(PojoMassIndexingIndexedTypeGroup<?> typeGroup, PojoMassIndexingSessionContext sessionContext, Object entity, Exception exception) {
        String failingOperation = PojoMassIndexerMessages.INSTANCE.massIndexerIndexingInstance(typeGroup.notifiedGroupName());
        RecordedFailure recordedFailure = this.recordFailure(exception, false);
        if (this.shouldNotBeReported(failingOperation)) {
            return;
        }
        MassIndexingEntityFailureContext.Builder contextBuilder = MassIndexingEntityFailureContext.builder();
        contextBuilder.throwable(exception);
        contextBuilder.failingOperation(failingOperation);
        EntityReference entityReference = this.extractReferenceOrSuppress(typeGroup, sessionContext, entity, exception);
        if (entityReference != null) {
            contextBuilder.failingEntityReference(entityReference);
            recordedFailure.entityReference = entityReference;
        }
        this.failureHandler.handle(contextBuilder.build());
    }

    void reportEntitiesLoadingFailure(PojoMassIndexingIndexedTypeGroup<?> typeGroup, List<?> idList, Exception exception) {
        String failingOperation = PojoMassIndexerMessages.INSTANCE.massIndexingLoadingAndExtractingEntityData(typeGroup.notifiedGroupName());
        this.recordFailure(exception, false);
        if (this.shouldNotBeReported(failingOperation)) {
            return;
        }
        MassIndexingEntityFailureContext.Builder contextBuilder = MassIndexingEntityFailureContext.builder();
        contextBuilder.throwable(exception);
        contextBuilder.failingOperation(failingOperation);
        for (Object id : idList) {
            try {
                contextBuilder.failingEntityReference(typeGroup.makeSuperTypeReference(id));
            }
            catch (Exception e) {
                exception.addSuppressed(e);
            }
        }
        this.failureHandler.handle(contextBuilder.build());
    }

    private boolean shouldNotBeReported(String operation) {
        long failuresSoFar = this.failureCounts.computeIfAbsent(operation, s -> new AtomicLong(0L)).incrementAndGet();
        return this.failureFloodingThreshold < failuresSoFar;
    }

    void reportIndexingCompleted() {
        this.monitor.indexingCompleted();
        RecordedFailure firstFailure = this.firstFailure.get();
        if (firstFailure == null) {
            return;
        }
        for (Map.Entry<String, AtomicLong> entry : this.failureCounts.entrySet()) {
            long unreported = entry.getValue().get() - this.failureFloodingThreshold;
            if (unreported <= 0L) continue;
            MassIndexingFailureContext.Builder builder = MassIndexingFailureContext.builder();
            builder.throwable((Throwable)MassIndexingLog.INSTANCE.notReportedFailures(unreported));
            builder.failingOperation(entry.getKey());
            this.failureHandler.handle(builder.build());
        }
        if (firstFailure.throwable instanceof InterruptedException) {
            throw MassIndexingLog.INSTANCE.massIndexingThreadInterrupted((InterruptedException)firstFailure.throwable);
        }
        if (firstFailure.entityReference != null) {
            throw MassIndexingLog.INSTANCE.massIndexingFirstFailureOnEntity(this.failureCount.longValue(), firstFailure.entityReference, firstFailure.throwable.getMessage(), firstFailure.throwable);
        }
        throw MassIndexingLog.INSTANCE.massIndexingFirstFailure(this.failureCount.longValue(), firstFailure.throwable.getMessage(), firstFailure.throwable);
    }

    private RecordedFailure recordFailure(Exception exception, boolean recordSuppressed) {
        RecordedFailure recordedFailure = new RecordedFailure(exception);
        boolean isFirst = this.firstFailure.compareAndSet(null, recordedFailure);
        this.failureCount.increment();
        if (!isFirst && recordSuppressed) {
            this.firstFailure.get().throwable.addSuppressed(exception);
        }
        return recordedFailure;
    }

    private EntityReference extractReferenceOrSuppress(PojoMassIndexingIndexedTypeGroup<?> typeGroup, PojoMassIndexingSessionContext sessionContext, Object entity, Throwable throwable) {
        try {
            return typeGroup.extractReference(sessionContext, entity);
        }
        catch (RuntimeException e) {
            throwable.addSuppressed(e);
            return null;
        }
    }

    private static class RecordedFailure {
        private final Throwable throwable;
        private volatile Object entityReference;

        RecordedFailure(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

