/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.models.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.ModelsConfiguration;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.DefaultClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.mapper.pojo.model.models.spi.PojoModelsClassOrdering;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.StreamHelper;
import org.hibernate.search.util.common.reflect.spi.ValueCreateHandle;
import org.hibernate.search.util.common.reflect.spi.ValueHandleFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;
import org.jboss.jandex.IndexView;

public abstract class AbstractPojoModelsBootstrapIntrospector
implements PojoBootstrapIntrospector {
    private static final String INDEX_MODELS_CONFIG_PARAM = "hibernate.models.jandex.index";
    private final PojoModelsClassOrdering typeOrdering;
    protected final ValueHandleFactory valueHandleFactory;
    private final ClassDetailsRegistry classDetailsRegistry;

    protected AbstractPojoModelsBootstrapIntrospector(ClassResolver classResolver, ResourceResolver resourceResolver, IndexView indexView, ValueHandleFactory valueHandleFactory) {
        this(AbstractPojoModelsBootstrapIntrospector.simpleClassDetailsRegistry(classResolver, resourceResolver, indexView), valueHandleFactory);
    }

    protected AbstractPojoModelsBootstrapIntrospector(ClassDetailsRegistry classDetailsRegistry, ValueHandleFactory valueHandleFactory) {
        this.classDetailsRegistry = classDetailsRegistry;
        this.typeOrdering = new PojoModelsClassOrdering(classDetailsRegistry);
        this.valueHandleFactory = valueHandleFactory;
    }

    private static ClassDetailsRegistry simpleClassDetailsRegistry(ClassResolver classResolver, ResourceResolver resourceResolver, IndexView indexView) {
        ModelsConfiguration configuration = new ModelsConfiguration();
        configuration.setClassLoading((ClassLoading)new HibernateSearchClassLoading(classResolver, resourceResolver));
        configuration.setConfigValue((Object)INDEX_MODELS_CONFIG_PARAM, (Object)indexView);
        return configuration.bootstrap().getClassDetailsRegistry();
    }

    @Override
    public ValueHandleFactory annotationValueHandleFactory() {
        return this.valueHandleFactory;
    }

    public Stream<? extends Annotation> annotations(AnnotationTarget annotationTarget) {
        return annotationTarget.getDirectAnnotationUsages().stream();
    }

    public ClassDetails toModelsClass(Class<?> type) {
        return this.classDetailsRegistry.resolveClassDetails(type.getName());
    }

    public Map<String, MemberDetails> declaredFieldAccessPropertiesByName(ClassDetails classDetails) {
        return classDetails.getFields().stream().filter(Predicate.not(MemberDetails::isStatic)).collect(AbstractPojoModelsBootstrapIntrospector.propertiesByNameNoDuplicate());
    }

    public Map<String, List<MemberDetails>> declaredMethodAccessPropertiesByName(ClassDetails classDetails) {
        return classDetails.getMethods().stream().filter(methodDetails -> methodDetails.getMethodKind().equals((Object)MethodDetails.MethodKind.GETTER) && !methodDetails.isSynthetic()).collect(AbstractPojoModelsBootstrapIntrospector.propertiesByName());
    }

    public Stream<Class<?>> ascendingSuperClasses(ClassDetails classDetails) {
        return this.typeOrdering.ascendingSuperTypes(classDetails).map(this::toClass);
    }

    public Stream<Class<?>> descendingSuperClasses(ClassDetails classDetails) {
        return this.typeOrdering.descendingSuperTypes(classDetails).map(this::toClass);
    }

    protected <T> ValueCreateHandle<T> createValueCreateHandle(Constructor<T> constructor) throws IllegalAccessException {
        throw new AssertionFailure(String.valueOf(this) + " doesn't support constructor handles. '" + this.getClass().getName() + " should be updated to implement createValueCreateHandle(Constructor).");
    }

    protected ValueReadHandle<?> createValueReadHandle(Member member) throws IllegalAccessException {
        if (member instanceof Method) {
            Method method = (Method)member;
            return this.valueHandleFactory.createForMethod(method);
        }
        if (member instanceof Field) {
            Field field = (Field)member;
            return this.valueHandleFactory.createForField(field);
        }
        throw new AssertionFailure("Unexpected type for a " + Member.class.getName() + ": " + String.valueOf(member));
    }

    public Class<?> toClass(ClassDetails xClass) {
        return xClass.toJavaClass();
    }

    private static Collector<MemberDetails, ?, Map<String, MemberDetails>> propertiesByNameNoDuplicate() {
        return StreamHelper.toMap(MemberDetails::getName, Function.identity(), TreeMap::new);
    }

    private static Collector<MemberDetails, ?, Map<String, List<MemberDetails>>> propertiesByName() {
        return Collectors.groupingBy(AbstractPojoModelsBootstrapIntrospector::noPrefix, TreeMap::new, Collectors.toList());
    }

    private static String noPrefix(MemberDetails details) {
        return PojoBootstrapIntrospector.noPrefix(details.getName());
    }

    private record HibernateSearchClassLoading(ClassResolver classResolver, ResourceResolver resourceResolver) implements ClassLoading
    {
        public <T> Class<T> classForName(String name) {
            return this.classResolver.classForName(name);
        }

        public <T> Class<T> findClassForName(String name) {
            try {
                return this.classResolver.classForName(name);
            }
            catch (ClassLoadingException e) {
                return null;
            }
        }

        public URL locateResource(String resourceName) {
            return this.resourceResolver.locateResource(resourceName);
        }

        public <S> Collection<S> loadJavaServices(Class<S> serviceType) {
            ServiceLoader<S> loadedServices;
            ClassResolver classResolver = this.classResolver;
            if (classResolver instanceof DefaultClassResolver) {
                DefaultClassResolver dcr = (DefaultClassResolver)classResolver;
                loadedServices = ServiceLoader.load(serviceType, (ClassLoader)dcr.aggregatedClassLoader());
            } else {
                loadedServices = ServiceLoader.load(serviceType);
            }
            Iterator<S> iterator = loadedServices.iterator();
            HashSet<S> services = new HashSet<S>();
            while (iterator.hasNext()) {
                services.add(iterator.next());
            }
            return services;
        }
    }
}

