/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.projection.definition.spi.CompositeProjectionDefinition;
import org.hibernate.search.mapper.pojo.logging.impl.ProjectionLog;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoSearchMappingConstructorNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.mapper.pojo.search.definition.binding.impl.ProjectionConstructorBinder;
import org.hibernate.search.mapper.pojo.search.definition.impl.PojoConstructorProjectionDefinition;
import org.hibernate.search.mapper.pojo.search.definition.impl.PojoSearchQueryElementRegistry;
import org.hibernate.search.util.common.impl.Closer;

public final class PojoSearchQueryElementRegistryBuilder {
    private final PojoMappingHelper mappingHelper;
    private final Map<Class<?>, CompositeProjectionDefinition<?>> projectionDefinitions = new LinkedHashMap();

    public PojoSearchQueryElementRegistryBuilder(PojoMappingHelper mappingHelper) {
        this.mappingHelper = mappingHelper;
    }

    public void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.pushAll(CompositeProjectionDefinition::close, this.projectionDefinitions.values());
        }
    }

    public void process(PojoRawTypeModel<?> type) {
        try {
            for (PojoTypeMetadataContributor contributor : this.mappingHelper.contributorProvider().getIgnoringInheritance(type)) {
                for (PojoSearchMappingConstructorNode pojoSearchMappingConstructorNode : contributor.constructors().values()) {
                    this.processProjectionConstructors(type, pojoSearchMappingConstructorNode);
                }
            }
        }
        catch (RuntimeException e) {
            this.mappingHelper.failureCollector().withContext(EventContexts.fromType(type)).add((Throwable)e);
        }
    }

    private <T> void processProjectionConstructors(PojoRawTypeModel<T> type, PojoSearchMappingConstructorNode constructorMapping) {
        PojoConstructorModel<T> constructor = type.constructor(constructorMapping.parametersJavaTypes());
        try {
            this.processProjectionConstructors(type, constructor, constructorMapping);
        }
        catch (RuntimeException e) {
            this.mappingHelper.failureCollector().withContext(PojoEventContexts.fromType(type)).withContext(PojoEventContexts.fromConstructor(constructor)).add((Throwable)e);
        }
    }

    private <T> void processProjectionConstructors(PojoRawTypeModel<T> type, PojoConstructorModel<T> constructor, PojoSearchMappingConstructorNode constructorMapping) {
        if (constructorMapping.isProjectionConstructor()) {
            Class<T> instantiatedJavaClass = type.typeIdentifier().javaClass();
            ProjectionConstructorBinder<T> binder = new ProjectionConstructorBinder<T>(this.mappingHelper, constructor);
            PojoConstructorProjectionDefinition<T> definition = binder.bind();
            CompositeProjectionDefinition existing = this.projectionDefinitions.putIfAbsent(instantiatedJavaClass, definition);
            ProjectionLog.INSTANCE.constructorProjection(type, definition);
            if (existing != null) {
                throw ProjectionLog.INSTANCE.multipleProjectionConstructorsForType(instantiatedJavaClass);
            }
        }
    }

    public PojoSearchQueryElementRegistry build() {
        return new PojoSearchQueryElementRegistry(this.projectionDefinitions);
    }
}

