/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.mapping.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultBigDecimalBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultBigIntegerBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultBooleanBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultByteArrayBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultByteBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultCharacterBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultDoubleBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultDurationBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultEnumBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultFloatArrayBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultFloatBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultGeoPointBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultInstantBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultIntegerBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaNetURIBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaNetURLBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaSqlDateBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaSqlTimeBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaSqlTimestampBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaUtilCalendarBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaUtilDateBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultLocalDateBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultLocalDateTimeBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultLocalTimeBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultLongBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultMonthDayBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultOffsetDateTimeBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultOffsetTimeBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultPeriodBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultShortBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultStringBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultUUIDBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultYearBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultYearMonthBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultZoneIdBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultZoneOffsetBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultZonedDateTimeBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgesConfigurationContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.DefaultBinderDefinitionStep;
import org.hibernate.search.mapper.pojo.bridge.mapping.DefaultBridgeDefinitionStep;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.StaticIdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.StaticValueBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcher;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcherFactory;

public final class BridgeResolver {
    private final Map<PojoRawTypeIdentifier<?>, IdentifierBinder> exactRawTypeIdentifierBridgeMappings;
    private final Map<PojoRawTypeIdentifier<?>, ValueBinder> exactRawTypeValueBridgeMappings;
    private final List<TypePatternBinderMapping<IdentifierBinder>> typePatternIdentifierBridgeMappings;
    private final List<TypePatternBinderMapping<ValueBinder>> typePatternValueBridgeMappings;

    private BridgeResolver(Builder builder) {
        this.exactRawTypeIdentifierBridgeMappings = new HashMap(builder.exactRawTypeIdentifierBridgeMappings);
        this.exactRawTypeValueBridgeMappings = new HashMap(builder.exactRawTypeValueBridgeMappings);
        this.typePatternIdentifierBridgeMappings = new ArrayList<TypePatternBinderMapping<IdentifierBinder>>(builder.typePatternIdentifierBridgeMappings);
        this.typePatternValueBridgeMappings = new ArrayList<TypePatternBinderMapping<ValueBinder>>(builder.typePatternValueBridgeMappings);
        Collections.reverse(this.typePatternIdentifierBridgeMappings);
        Collections.reverse(this.typePatternValueBridgeMappings);
    }

    public IdentifierBinder resolveIdentifierBinderForType(PojoTypeModel<?> sourceType) {
        IdentifierBinder result = BridgeResolver.getBinderOrNull(sourceType, this.exactRawTypeIdentifierBridgeMappings, this.typePatternIdentifierBridgeMappings);
        if (result == null) {
            throw MappingLog.INSTANCE.unableToResolveDefaultIdentifierBridgeFromSourceType(sourceType);
        }
        return result;
    }

    public ValueBinder resolveValueBinderForType(PojoTypeModel<?> sourceType) {
        ValueBinder result = BridgeResolver.getBinderOrNull(sourceType, this.exactRawTypeValueBridgeMappings, this.typePatternValueBridgeMappings);
        if (result == null) {
            throw MappingLog.INSTANCE.unableToResolveDefaultValueBridgeFromSourceType(sourceType);
        }
        return result;
    }

    private static <B> B getBinderOrNull(PojoTypeModel<?> sourceType, Map<PojoRawTypeIdentifier<?>, B> exactRawTypeBridgeMappings, List<TypePatternBinderMapping<B>> typePatternBinderMappings) {
        PojoRawTypeIdentifier<?> rawType = sourceType.rawType().typeIdentifier();
        B result = exactRawTypeBridgeMappings.get(rawType);
        if (result == null) {
            Iterator<TypePatternBinderMapping<B>> mappingIterator = typePatternBinderMappings.iterator();
            while (result == null && mappingIterator.hasNext()) {
                result = mappingIterator.next().getBinderIfMatching(sourceType);
            }
        }
        return result;
    }

    public static class Builder
    implements BridgesConfigurationContext {
        private final PojoBootstrapIntrospector introspector;
        private final TypePatternMatcherFactory typePatternMatcherFactory;
        private final Map<PojoRawTypeIdentifier<?>, IdentifierBinder> exactRawTypeIdentifierBridgeMappings = new HashMap();
        private final Map<PojoRawTypeIdentifier<?>, ValueBinder> exactRawTypeValueBridgeMappings = new HashMap();
        private final List<TypePatternBinderMapping<IdentifierBinder>> typePatternIdentifierBridgeMappings = new ArrayList<TypePatternBinderMapping<IdentifierBinder>>();
        private final List<TypePatternBinderMapping<ValueBinder>> typePatternValueBridgeMappings = new ArrayList<TypePatternBinderMapping<ValueBinder>>();

        public Builder(PojoBootstrapIntrospector introspector, TypePatternMatcherFactory typePatternMatcherFactory) {
            this.introspector = introspector;
            this.typePatternMatcherFactory = typePatternMatcherFactory;
            this.addDefaults();
        }

        @Override
        public <T> DefaultBridgeDefinitionStep<?, T> exactType(Class<T> clazz) {
            return new ExactTypeDefaultBridgeDefinitionStep<T>(this.introspector.typeModel(clazz).typeIdentifier());
        }

        @Override
        public <T> DefaultBinderDefinitionStep<?> subTypesOf(Class<T> clazz) {
            TypePatternMatcher subTypesMatcher = this.typePatternMatcherFactory.createRawSuperTypeMatcher(clazz);
            return new TypePatternDefaultBinderDefinitionStep(subTypesMatcher);
        }

        @Override
        public <T> DefaultBinderDefinitionStep<?> strictSubTypesOf(Class<T> clazz) {
            TypePatternMatcher strictSubTypesMatcher = this.typePatternMatcherFactory.createRawSuperTypeMatcher(clazz).and(this.typePatternMatcherFactory.createExactRawTypeMatcher(clazz).negate());
            return new TypePatternDefaultBinderDefinitionStep(strictSubTypesMatcher);
        }

        public BridgeResolver build() {
            return new BridgeResolver(this);
        }

        private void addDefaults() {
            this.exactType(String.class).valueBridge(DefaultStringBridge.INSTANCE).identifierBridge(DefaultStringBridge.INSTANCE);
            this.exactType(Character.class).valueBridge(DefaultCharacterBridge.INSTANCE).identifierBridge(DefaultCharacterBridge.INSTANCE);
            this.exactType(Boolean.class).valueBridge(DefaultBooleanBridge.INSTANCE).identifierBridge(DefaultBooleanBridge.INSTANCE);
            this.exactType(Byte.class).valueBridge(DefaultByteBridge.INSTANCE).identifierBridge(DefaultByteBridge.INSTANCE);
            this.exactType(Short.class).valueBridge(DefaultShortBridge.INSTANCE).identifierBridge(DefaultShortBridge.INSTANCE);
            this.exactType(Integer.class).valueBridge(DefaultIntegerBridge.INSTANCE).identifierBridge(DefaultIntegerBridge.INSTANCE);
            this.exactType(Long.class).valueBridge(DefaultLongBridge.INSTANCE).identifierBridge(DefaultLongBridge.INSTANCE);
            this.exactType(Float.class).valueBridge(DefaultFloatBridge.INSTANCE).identifierBridge(DefaultFloatBridge.INSTANCE);
            this.exactType(Double.class).valueBridge(DefaultDoubleBridge.INSTANCE).identifierBridge(DefaultDoubleBridge.INSTANCE);
            this.strictSubTypesOf(Enum.class).valueBinder(DefaultEnumBridge.Binder.INSTANCE).identifierBinder(DefaultEnumBridge.Binder.INSTANCE);
            this.exactType(BigInteger.class).valueBridge(DefaultBigIntegerBridge.INSTANCE).identifierBridge(DefaultBigIntegerBridge.INSTANCE);
            this.exactType(BigDecimal.class).valueBridge(DefaultBigDecimalBridge.INSTANCE).identifierBridge(DefaultBigDecimalBridge.INSTANCE);
            this.exactType(LocalDate.class).valueBridge(DefaultLocalDateBridge.INSTANCE).identifierBridge(DefaultLocalDateBridge.INSTANCE);
            this.exactType(Instant.class).valueBridge(DefaultInstantBridge.INSTANCE).identifierBridge(DefaultInstantBridge.INSTANCE);
            this.exactType(LocalDateTime.class).valueBridge(DefaultLocalDateTimeBridge.INSTANCE).identifierBridge(DefaultLocalDateTimeBridge.INSTANCE);
            this.exactType(LocalTime.class).valueBridge(DefaultLocalTimeBridge.INSTANCE).identifierBridge(DefaultLocalTimeBridge.INSTANCE);
            this.exactType(ZonedDateTime.class).valueBridge(DefaultZonedDateTimeBridge.INSTANCE).identifierBridge(DefaultZonedDateTimeBridge.INSTANCE);
            this.exactType(Year.class).valueBridge(DefaultYearBridge.INSTANCE).identifierBridge(DefaultYearBridge.INSTANCE);
            this.exactType(YearMonth.class).valueBridge(DefaultYearMonthBridge.INSTANCE).identifierBridge(DefaultYearMonthBridge.INSTANCE);
            this.exactType(MonthDay.class).valueBridge(DefaultMonthDayBridge.INSTANCE).identifierBridge(DefaultMonthDayBridge.INSTANCE);
            this.exactType(OffsetDateTime.class).valueBridge(DefaultOffsetDateTimeBridge.INSTANCE).identifierBridge(DefaultOffsetDateTimeBridge.INSTANCE);
            this.exactType(OffsetTime.class).valueBridge(DefaultOffsetTimeBridge.INSTANCE).identifierBridge(DefaultOffsetTimeBridge.INSTANCE);
            this.exactType(ZoneOffset.class).valueBridge(DefaultZoneOffsetBridge.INSTANCE).identifierBridge(DefaultZoneOffsetBridge.INSTANCE);
            this.exactType(ZoneId.class).valueBridge(DefaultZoneIdBridge.INSTANCE).identifierBridge(DefaultZoneIdBridge.INSTANCE);
            this.exactType(Period.class).valueBridge(DefaultPeriodBridge.INSTANCE).identifierBridge(DefaultPeriodBridge.INSTANCE);
            this.exactType(Duration.class).valueBridge(DefaultDurationBridge.INSTANCE).identifierBridge(DefaultDurationBridge.INSTANCE);
            this.exactType(UUID.class).valueBridge(DefaultUUIDBridge.INSTANCE).identifierBridge(DefaultUUIDBridge.INSTANCE);
            this.exactType(Date.class).valueBridge(DefaultJavaUtilDateBridge.INSTANCE).identifierBridge(DefaultJavaUtilDateBridge.INSTANCE);
            this.exactType(Calendar.class).valueBridge(DefaultJavaUtilCalendarBridge.INSTANCE).identifierBridge(DefaultJavaUtilCalendarBridge.INSTANCE);
            this.exactType(java.sql.Date.class).valueBridge(DefaultJavaSqlDateBridge.INSTANCE).identifierBridge(DefaultJavaSqlDateBridge.INSTANCE);
            this.exactType(Timestamp.class).valueBridge(DefaultJavaSqlTimestampBridge.INSTANCE).identifierBridge(DefaultJavaSqlTimestampBridge.INSTANCE);
            this.exactType(Time.class).valueBridge(DefaultJavaSqlTimeBridge.INSTANCE).identifierBridge(DefaultJavaSqlTimeBridge.INSTANCE);
            this.exactType(URI.class).valueBridge(DefaultJavaNetURIBridge.INSTANCE).identifierBridge(DefaultJavaNetURIBridge.INSTANCE);
            this.exactType(URL.class).valueBridge(DefaultJavaNetURLBridge.INSTANCE).identifierBridge(DefaultJavaNetURLBridge.INSTANCE);
            this.subTypesOf(GeoPoint.class).valueBinder(new StaticValueBinder<GeoPoint>(GeoPoint.class, DefaultGeoPointBridge.INSTANCE));
            this.exactType(GeoPoint.class).identifierBridge(DefaultGeoPointBridge.INSTANCE);
            this.exactType(byte[].class).valueBridge(DefaultByteArrayBridge.INSTANCE);
            this.exactType(float[].class).valueBridge(DefaultFloatArrayBridge.INSTANCE);
        }

        private class ExactTypeDefaultBridgeDefinitionStep<T>
        implements DefaultBridgeDefinitionStep<ExactTypeDefaultBridgeDefinitionStep<T>, T> {
            private final PojoRawTypeIdentifier<T> typeIdentifier;

            private ExactTypeDefaultBridgeDefinitionStep(PojoRawTypeIdentifier<T> typeIdentifier) {
                this.typeIdentifier = typeIdentifier;
            }

            @Override
            public ExactTypeDefaultBridgeDefinitionStep<T> identifierBinder(IdentifierBinder binder) {
                Builder.this.exactRawTypeIdentifierBridgeMappings.put(this.typeIdentifier, binder);
                return this;
            }

            @Override
            public ExactTypeDefaultBridgeDefinitionStep<T> valueBinder(ValueBinder binder) {
                Builder.this.exactRawTypeValueBridgeMappings.put(this.typeIdentifier, binder);
                return this;
            }

            @Override
            public ExactTypeDefaultBridgeDefinitionStep<T> identifierBridge(IdentifierBridge<T> bridge) {
                return this.identifierBinder(new StaticIdentifierBinder<T>(this.typeIdentifier.javaClass(), bridge));
            }

            @Override
            public ExactTypeDefaultBridgeDefinitionStep<T> valueBridge(ValueBridge<T, ?> bridge) {
                return this.valueBinder(new StaticValueBinder<T>(this.typeIdentifier.javaClass(), bridge));
            }
        }

        private class TypePatternDefaultBinderDefinitionStep
        implements DefaultBinderDefinitionStep<TypePatternDefaultBinderDefinitionStep> {
            private final TypePatternMatcher typePatternMatcher;

            private TypePatternDefaultBinderDefinitionStep(TypePatternMatcher typePatternMatcher) {
                this.typePatternMatcher = typePatternMatcher;
            }

            @Override
            public TypePatternDefaultBinderDefinitionStep identifierBinder(IdentifierBinder binder) {
                Builder.this.typePatternIdentifierBridgeMappings.add(new TypePatternBinderMapping<IdentifierBinder>(this.typePatternMatcher, binder));
                return this;
            }

            @Override
            public TypePatternDefaultBinderDefinitionStep valueBinder(ValueBinder binder) {
                Builder.this.typePatternValueBridgeMappings.add(new TypePatternBinderMapping<ValueBinder>(this.typePatternMatcher, binder));
                return this;
            }
        }
    }

    private static final class TypePatternBinderMapping<B> {
        private final TypePatternMatcher matcher;
        private final B binder;

        TypePatternBinderMapping(TypePatternMatcher matcher, B binder) {
            this.matcher = matcher;
            this.binder = binder;
        }

        B getBinderIfMatching(PojoTypeModel<?> typeModel) {
            if (this.matcher.matches(typeModel)) {
                return this.binder;
            }
            return null;
        }
    }
}

