/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl;

import java.util.Map;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.BeanBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexMappingCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoPropertyMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.DelegatingPropertyMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.PojoCompositeFieldModelContributor;

abstract class AbstractPropertyMappingFieldOptionsStep<S extends PropertyMappingFieldOptionsStep<?>>
extends DelegatingPropertyMappingStep
implements PojoPropertyMetadataContributor,
PropertyMappingFieldOptionsStep<S> {
    protected final String relativeFieldName;
    final PojoCompositeFieldModelContributor fieldModelContributor;
    private ValueBinder binder;
    private Map<String, Object> params;
    private ContainerExtractorPath extractorPath = ContainerExtractorPath.defaultExtractors();

    AbstractPropertyMappingFieldOptionsStep(PropertyMappingStep delegate, String relativeFieldName, PojoCompositeFieldModelContributor.DefaultInitiator fieldTypeDefaultInitiator, PojoCompositeFieldModelContributor.Contributor fieldTypeChecker) {
        super(delegate);
        this.relativeFieldName = relativeFieldName;
        if (relativeFieldName != null && relativeFieldName.contains(FieldPaths.PATH_SEPARATOR_STRING)) {
            throw MappingLog.INSTANCE.invalidFieldNameDotNotAllowed(relativeFieldName);
        }
        this.fieldModelContributor = new PojoCompositeFieldModelContributor(fieldTypeDefaultInitiator);
        this.fieldModelContributor.add(fieldTypeChecker);
    }

    @Override
    public void contributeIndexMapping(PojoIndexMappingCollectorPropertyNode collector) {
        collector.value(this.extractorPath).valueBinder(this.binder, this.params, this.relativeFieldName, this.fieldModelContributor);
    }

    @Override
    public S valueBridge(Class<? extends ValueBridge<?, ?>> bridgeClass) {
        return this.valueBridge(BeanReference.of(bridgeClass));
    }

    @Override
    public S valueBridge(BeanReference<? extends ValueBridge<?, ?>> bridgeReference) {
        return this.valueBinder(new BeanBinder(bridgeReference));
    }

    @Override
    public S valueBinder(ValueBinder binder, Map<String, Object> params) {
        this.binder = binder;
        this.params = params;
        return this.thisAsS();
    }

    @Override
    public S extractors(ContainerExtractorPath extractorPath) {
        this.extractorPath = extractorPath;
        return this.thisAsS();
    }

    abstract S thisAsS();
}

