package org.hibernate.search.mapper.pojo.standalone.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.jboss.logging.BasicLogger;
import java.util.Collection;
import java.lang.Class;
import java.util.List;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-02-28T09:57:40+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String errorRetrievingTypeModel$str() {
        return "HSEARCH750003: Unable to retrieve type model for class '%1$s'.";
    }
    @Override
    public final SearchException errorRetrievingTypeModel(final Class<?> clazz, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorRetrievingTypeModel$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(clazz)), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String namedTypesNotSupported$str() {
        return "HSEARCH750007: Type with name '%1$s' does not exist: the standalone POJO mapper does not support named types.";
    }
    @Override
    public final SearchException namedTypesNotSupported(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), namedTypesNotSupported$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownClassForIndexedEntityType$str() {
        return "HSEARCH750009: No matching indexed entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not indexed in Hibernate Search. Valid classes for indexed entity types are: %2$s";
    }
    @Override
    public final SearchException unknownClassForIndexedEntityType(final Class<?> invalidClass, final Collection<Class<?>> validClasses) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownClassForIndexedEntityType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(invalidClass), new org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter(validClasses)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownEntityNameForIndexedEntityType$str() {
        return "HSEARCH750010: No matching indexed entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not indexed in Hibernate Search. Valid names for indexed entity types are: %2$s";
    }
    @Override
    public final SearchException unknownEntityNameForIndexedEntityType(final String invalidName, final Collection<String> validNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownEntityNameForIndexedEntityType$str(), invalidName, validNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidStringForBeanProvider$str() {
        return "HSEARCH750011: Invalid String value for the bean provider: '%s'. The bean provider must be an instance of '%s'.";
    }
    @Override
    public final SearchException invalidStringForBeanProvider(final String value, final Class<org.hibernate.search.engine.environment.bean.spi.BeanProvider> expectedType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidStringForBeanProvider$str(), value, expectedType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String hibernateSessionAccessError$str() {
        return "HSEARCH750014: Unable to access search session: %1$s";
    }
    @Override
    public final SearchException hibernateSessionAccessError(final String causeMessage) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSessionAccessError$str(), causeMessage));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSchemaManagementStrategyName$str() {
        return "HSEARCH750015: Invalid schema management strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidSchemaManagementStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSchemaManagementStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownTypeIdentifierForMappedEntityType$str() {
        return "HSEARCH750016: No matching entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not mapped in Hibernate Search. Valid identifiers for mapped entity types are: %2$s";
    }
    @Override
    public final SearchException unknownTypeIdentifierForMappedEntityType(final PojoRawTypeIdentifier<?> invalidTypeId, final Collection<PojoRawTypeIdentifier<?>> validTypeIds) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownTypeIdentifierForMappedEntityType$str(), invalidTypeId, validTypeIds));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownTypeIdentifierForIndexedEntityType$str() {
        return "HSEARCH750017: No matching indexed entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not indexed in Hibernate Search. Valid identifiers for indexed entity types are: %2$s";
    }
    @Override
    public final SearchException unknownTypeIdentifierForIndexedEntityType(final PojoRawTypeIdentifier<?> invalidTypeId, final Collection<PojoRawTypeIdentifier<?>> validTypeIds) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownTypeIdentifierForIndexedEntityType$str(), invalidTypeId, validTypeIds));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownClassForMappedEntityType$str() {
        return "HSEARCH750018: No matching entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not mapped in Hibernate Search. Valid classes for mapped entity types are: %2$s";
    }
    @Override
    public final SearchException unknownClassForMappedEntityType(final Class<?> invalidClass, final Collection<Class<?>> validClasses) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownClassForMappedEntityType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(invalidClass), new org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter(validClasses)));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
