/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.bootstrap.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.AllAwareConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertyChecker;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.common.spi.SearchIntegrationEnvironment;
import org.hibernate.search.engine.common.spi.SearchIntegrationPartialBuildState;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingInitiator;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingKey;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotatedTypeSource;
import org.hibernate.search.mapper.pojo.standalone.bootstrap.impl.StandalonePojoIntegrationPartialBuildState;
import org.hibernate.search.mapper.pojo.standalone.bootstrap.spi.StandalonePojoIntegrationBooter;
import org.hibernate.search.mapper.pojo.standalone.bootstrap.spi.StandalonePojoIntegrationBooterBehavior;
import org.hibernate.search.mapper.pojo.standalone.logging.impl.Log;
import org.hibernate.search.mapper.pojo.standalone.mapping.impl.StandalonePojoMapping;
import org.hibernate.search.mapper.pojo.standalone.mapping.impl.StandalonePojoMappingInitiator;
import org.hibernate.search.mapper.pojo.standalone.mapping.impl.StandalonePojoMappingKey;
import org.hibernate.search.mapper.pojo.standalone.model.impl.StandalonePojoBootstrapIntrospector;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueHandleFactory;

public class StandalonePojoIntegrationBooterImpl
implements StandalonePojoIntegrationBooter {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final OptionalConfigurationProperty<BeanProvider> BEAN_PROVIDER = ConfigurationProperty.forKey((String)"hibernate.search.bean_provider").as(BeanProvider.class, value -> {
        throw log.invalidStringForBeanProvider((String)value, BeanProvider.class);
    }).build();
    private final List<AnnotatedTypeSource> annotatedTypeSources;
    private final ConfigurationPropertyChecker propertyChecker;
    private final ValueHandleFactory valueHandleFactory;
    private final ConfigurationPropertySource propertySource;

    private StandalonePojoIntegrationBooterImpl(BuilderImpl builder) {
        this.annotatedTypeSources = builder.annotatedTypeSources;
        this.propertyChecker = ConfigurationPropertyChecker.create();
        this.valueHandleFactory = builder.valueHandleFactory;
        this.propertySource = this.propertyChecker.wrap(AllAwareConfigurationPropertySource.fromMap(builder.properties));
    }

    @Override
    public void preBoot(BiConsumer<String, Object> propertyCollector) {
        this.doBootFirstPhase().set(propertyCollector);
    }

    private StandalonePojoIntegrationPartialBuildState getPartialBuildStateOrDoBootFirstPhase() {
        Optional<StandalonePojoIntegrationPartialBuildState> partialBuildState = StandalonePojoIntegrationPartialBuildState.get(this.propertySource);
        if (partialBuildState.isPresent()) {
            return partialBuildState.get();
        }
        return StandalonePojoIntegrationBooterBehavior.bootFirstPhase(this::doBootFirstPhase);
    }

    private StandalonePojoIntegrationPartialBuildState doBootFirstPhase() {
        StandalonePojoBootstrapIntrospector introspector = StandalonePojoBootstrapIntrospector.create(this.valueHandleFactory != null ? this.valueHandleFactory : ValueHandleFactory.usingMethodHandle((MethodHandles.Lookup)MethodHandles.publicLookup()));
        StandalonePojoMappingKey mappingKey = new StandalonePojoMappingKey();
        StandalonePojoMappingInitiator mappingInitiator = new StandalonePojoMappingInitiator(introspector);
        for (AnnotatedTypeSource source : this.annotatedTypeSources) {
            source.apply(mappingInitiator.annotationMapping());
        }
        SearchIntegrationEnvironment environment = null;
        SearchIntegrationPartialBuildState integrationPartialBuildState = null;
        try {
            environment = this.createEnvironment();
            SearchIntegration.Builder integrationBuilder = SearchIntegration.builder((SearchIntegrationEnvironment)environment);
            integrationBuilder.addMappingInitiator((MappingKey)mappingKey, (MappingInitiator)mappingInitiator);
            integrationPartialBuildState = integrationBuilder.prepareBuild();
            return new StandalonePojoIntegrationPartialBuildState(integrationPartialBuildState, mappingKey);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)environment).push(SearchIntegrationPartialBuildState::closeOnFailure, integrationPartialBuildState);
            throw e;
        }
    }

    private SearchIntegrationEnvironment createEnvironment() {
        SearchIntegrationEnvironment.Builder environmentBuilder = SearchIntegrationEnvironment.builder((ConfigurationPropertySource)this.propertySource, (ConfigurationPropertyChecker)this.propertyChecker);
        ((Optional)BEAN_PROVIDER.get(this.propertySource)).ifPresent(arg_0 -> ((SearchIntegrationEnvironment.Builder)environmentBuilder).beanProvider(arg_0));
        return environmentBuilder.build();
    }

    @Override
    public StandalonePojoMapping boot() {
        StandalonePojoIntegrationPartialBuildState partialBuildState = this.getPartialBuildStateOrDoBootFirstPhase();
        try {
            return partialBuildState.doBootSecondPhase(this.propertySource, this.propertyChecker);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(StandalonePojoIntegrationPartialBuildState::closeOnFailure, (Object)partialBuildState);
            throw e;
        }
    }

    public static class BuilderImpl
    implements StandalonePojoIntegrationBooter.Builder {
        private final List<AnnotatedTypeSource> annotatedTypeSources = new ArrayList<AnnotatedTypeSource>();
        private ValueHandleFactory valueHandleFactory;
        private final Map<String, Object> properties = new HashMap<String, Object>();

        @Override
        public BuilderImpl annotatedTypeSource(AnnotatedTypeSource source) {
            this.annotatedTypeSources.add(source);
            return this;
        }

        @Override
        public BuilderImpl valueReadHandleFactory(ValueHandleFactory valueHandleFactory) {
            this.valueHandleFactory = valueHandleFactory;
            return this;
        }

        @Override
        public BuilderImpl property(String name, Object value) {
            this.properties.put(name, value);
            return this;
        }

        @Override
        public BuilderImpl properties(Map<String, ?> map) {
            this.properties.putAll(map);
            return this;
        }

        @Override
        public StandalonePojoIntegrationBooterImpl build() {
            return new StandalonePojoIntegrationBooterImpl(this);
        }
    }
}

