/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.scope.impl;

import java.util.Collections;
import java.util.Set;
import org.hibernate.search.engine.backend.scope.IndexScopeExtension;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.search.aggregation.dsl.SearchAggregationFactory;
import org.hibernate.search.engine.search.highlighter.dsl.SearchHighlighterFactory;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContextBuilder;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexer;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingContext;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeSessionContext;
import org.hibernate.search.mapper.pojo.standalone.entity.SearchIndexedEntity;
import org.hibernate.search.mapper.pojo.standalone.loading.impl.StandalonePojoLoadingContext;
import org.hibernate.search.mapper.pojo.standalone.massindexing.MassIndexer;
import org.hibernate.search.mapper.pojo.standalone.massindexing.impl.StandalonePojoMassIndexer;
import org.hibernate.search.mapper.pojo.standalone.schema.management.SearchSchemaManager;
import org.hibernate.search.mapper.pojo.standalone.schema.management.impl.SearchSchemaManagerImpl;
import org.hibernate.search.mapper.pojo.standalone.scope.SearchScope;
import org.hibernate.search.mapper.pojo.standalone.scope.impl.StandalonePojoScopeMappingContext;
import org.hibernate.search.mapper.pojo.standalone.work.SearchWorkspace;
import org.hibernate.search.mapper.pojo.standalone.work.impl.SearchWorkspaceImpl;
import org.hibernate.search.util.common.impl.Contracts;

public class SearchScopeImpl<E>
implements SearchScope<E> {
    private final StandalonePojoScopeMappingContext mappingContext;
    private final PojoScopeDelegate<EntityReference, E, SearchIndexedEntity<? extends E>> delegate;

    public SearchScopeImpl(StandalonePojoScopeMappingContext mappingContext, PojoScopeDelegate<EntityReference, E, SearchIndexedEntity<? extends E>> delegate) {
        this.mappingContext = mappingContext;
        this.delegate = delegate;
    }

    @Override
    public SearchPredicateFactory predicate() {
        return this.delegate.predicate();
    }

    @Override
    public SearchSortFactory sort() {
        return this.delegate.sort();
    }

    @Override
    public SearchProjectionFactory<EntityReference, ?> projection() {
        return this.delegate.projection();
    }

    @Override
    public SearchAggregationFactory aggregation() {
        return this.delegate.aggregation();
    }

    @Override
    public SearchHighlighterFactory highlighter() {
        return this.delegate.highlighter();
    }

    @Override
    public SearchSchemaManager schemaManager() {
        return new SearchSchemaManagerImpl(this.schemaManagerDelegate());
    }

    @Override
    public SearchWorkspace workspace() {
        return this.workspace(null);
    }

    @Override
    public SearchWorkspace workspace(String tenantId) {
        return new SearchWorkspaceImpl(this.delegate.workspace(tenantId));
    }

    @Override
    public Set<? extends SearchIndexedEntity<? extends E>> includedTypes() {
        return this.delegate.includedIndexedTypes();
    }

    @Override
    public <T> T extension(IndexScopeExtension<T> extension) {
        return (T)this.delegate.extension(extension);
    }

    public SearchQuerySelectStep<?, EntityReference, E, ?, ?, ?> search(PojoScopeSessionContext sessionContext, PojoSelectionLoadingContextBuilder<?> loadingContextBuilder) {
        return this.delegate.search(sessionContext, loadingContextBuilder);
    }

    @Override
    public MassIndexer massIndexer() {
        return this.massIndexer(Collections.emptySet());
    }

    @Override
    public MassIndexer massIndexer(String tenantId) {
        Contracts.assertNotNull((Object)tenantId, (String)"tenant identifier");
        return this.massIndexer(Collections.singleton(tenantId));
    }

    @Override
    public MassIndexer massIndexer(Set<String> tenantIds) {
        StandalonePojoLoadingContext context = this.mappingContext.loadingContextBuilder().build();
        PojoMassIndexer massIndexerDelegate = this.delegate.massIndexer((PojoMassIndexingContext)context, tenantIds);
        return new StandalonePojoMassIndexer(massIndexerDelegate, context);
    }

    public PojoScopeSchemaManager schemaManagerDelegate() {
        return this.delegate.schemaManager();
    }
}

