/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.standalone.logging.impl.Log;
import org.hibernate.search.mapper.pojo.standalone.mapping.impl.AbstractStandalonePojoTypeContext;
import org.hibernate.search.mapper.pojo.standalone.mapping.impl.StandalonePojoContainedTypeContext;
import org.hibernate.search.mapper.pojo.standalone.mapping.impl.StandalonePojoIndexedTypeContext;
import org.hibernate.search.mapper.pojo.standalone.session.impl.StandalonePojoSearchSessionTypeContextProvider;
import org.hibernate.search.util.common.data.spi.KeyValueProvider;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class StandalonePojoTypeContextContainer
implements StandalonePojoSearchSessionTypeContextProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final KeyValueProvider<PojoRawTypeIdentifier<?>, AbstractStandalonePojoTypeContext<?>> byTypeIdentifier;
    private final KeyValueProvider<PojoRawTypeIdentifier<?>, StandalonePojoIndexedTypeContext<?>> indexedByTypeIdentifier;
    private final KeyValueProvider<Class<?>, AbstractStandalonePojoTypeContext<?>> byExactClass;
    private final KeyValueProvider<Class<?>, StandalonePojoIndexedTypeContext<?>> indexedByExactClass;
    private final KeyValueProvider<String, StandalonePojoIndexedTypeContext<?>> indexedByEntityName;

    private StandalonePojoTypeContextContainer(Builder builder) {
        PojoRawTypeIdentifier typeIdentifier;
        AbstractStandalonePojoTypeContext typeContext;
        LinkedHashMap byTypeIdentifierContent = new LinkedHashMap();
        LinkedHashMap indexedByTypeIdentifierContent = new LinkedHashMap();
        LinkedHashMap byExactClassContent = new LinkedHashMap();
        LinkedHashMap indexedByExactClassContent = new LinkedHashMap();
        LinkedHashMap<String, AbstractStandalonePojoTypeContext> indexedByEntityNameContent = new LinkedHashMap<String, AbstractStandalonePojoTypeContext>();
        for (StandalonePojoIndexedTypeContext.Builder<?> builder2 : builder.indexedTypeContextBuilders) {
            typeContext = builder2.build();
            typeIdentifier = typeContext.typeIdentifier();
            byTypeIdentifierContent.put(typeIdentifier, typeContext);
            indexedByTypeIdentifierContent.put(typeIdentifier, typeContext);
            byExactClassContent.put(typeContext.javaClass(), typeContext);
            indexedByExactClassContent.put(typeContext.javaClass(), typeContext);
            indexedByEntityNameContent.put(typeContext.name(), typeContext);
        }
        for (StandalonePojoContainedTypeContext.Builder builder3 : builder.containedTypeContextBuilders) {
            typeContext = builder3.build();
            typeIdentifier = typeContext.typeIdentifier();
            byTypeIdentifierContent.put(typeIdentifier, typeContext);
            byExactClassContent.put(typeContext.javaClass(), typeContext);
        }
        this.byTypeIdentifier = new KeyValueProvider(byTypeIdentifierContent, log::unknownTypeIdentifierForMappedEntityType);
        this.indexedByTypeIdentifier = new KeyValueProvider(indexedByTypeIdentifierContent, log::unknownTypeIdentifierForIndexedEntityType);
        this.byExactClass = new KeyValueProvider(byExactClassContent, log::unknownClassForMappedEntityType);
        this.indexedByExactClass = new KeyValueProvider(indexedByExactClassContent, log::unknownClassForIndexedEntityType);
        this.indexedByEntityName = new KeyValueProvider(indexedByEntityNameContent, log::unknownEntityNameForIndexedEntityType);
    }

    public <E> AbstractStandalonePojoTypeContext<E> forExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return (AbstractStandalonePojoTypeContext)this.byTypeIdentifier.getOrFail(typeIdentifier);
    }

    public <E> StandalonePojoIndexedTypeContext<E> indexedForExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return (StandalonePojoIndexedTypeContext)this.indexedByTypeIdentifier.getOrFail(typeIdentifier);
    }

    public <E> AbstractStandalonePojoTypeContext<E> forExactClass(Class<E> clazz) {
        return (AbstractStandalonePojoTypeContext)this.byExactClass.getOrFail(clazz);
    }

    public <E> StandalonePojoIndexedTypeContext<E> indexedForExactClass(Class<E> clazz) {
        return (StandalonePojoIndexedTypeContext)this.indexedByExactClass.getOrFail(clazz);
    }

    public KeyValueProvider<String, StandalonePojoIndexedTypeContext<?>> indexedByEntityName() {
        return this.indexedByEntityName;
    }

    public Collection<? extends StandalonePojoIndexedTypeContext<?>> allIndexed() {
        return this.indexedByTypeIdentifier.values();
    }

    static class Builder {
        private final List<StandalonePojoIndexedTypeContext.Builder<?>> indexedTypeContextBuilders = new ArrayList();
        private final List<StandalonePojoContainedTypeContext.Builder<?>> containedTypeContextBuilders = new ArrayList();

        Builder() {
        }

        <E> StandalonePojoIndexedTypeContext.Builder<E> addIndexed(PojoRawTypeModel<E> typeModel, String entityName) {
            StandalonePojoIndexedTypeContext.Builder builder = new StandalonePojoIndexedTypeContext.Builder(typeModel.typeIdentifier(), entityName);
            this.indexedTypeContextBuilders.add(builder);
            return builder;
        }

        <E> StandalonePojoContainedTypeContext.Builder<E> addContained(PojoRawTypeModel<E> typeModel, String entityName) {
            StandalonePojoContainedTypeContext.Builder builder = new StandalonePojoContainedTypeContext.Builder(typeModel.typeIdentifier(), entityName);
            this.containedTypeContextBuilders.add(builder);
            return builder;
        }

        StandalonePojoTypeContextContainer build() {
            return new StandalonePojoTypeContextContainer(this);
        }
    }
}

