/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.cfg;

import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingDefaultCleanOperation;
import org.hibernate.search.mapper.pojo.standalone.schema.management.SchemaManagementStrategyName;
import org.hibernate.search.mapper.pojo.tenancy.TenantIdentifierConverter;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategy;
import org.hibernate.search.util.common.annotation.Incubating;

@Incubating
public final class StandalonePojoMapperSettings {
    public static final String PREFIX = "hibernate.search.";
    public static final String SCHEMA_MANAGEMENT_STRATEGY = "hibernate.search.schema_management.strategy";
    public static final String MAPPING_BUILD_MISSING_DISCOVERED_JANDEX_INDEXES = "hibernate.search.mapping.build_missing_discovered_jandex_indexes";
    public static final String MAPPING_DISCOVER_ANNOTATED_TYPES_FROM_ROOT_MAPPING_ANNOTATIONS = "hibernate.search.mapping.discover_annotated_types_from_root_mapping_annotations";
    public static final String MAPPING_CONFIGURER = "hibernate.search.mapping.configurer";
    public static final String MULTI_TENANCY_ENABLED = "hibernate.search.mapping.multi_tenancy.enabled";
    public static final String MULTI_TENANCY_TENANT_IDENTIFIER_CONVERTER = "hibernate.search.mapping.multi_tenancy.tenant_identifier_converter";
    public static final String INDEXING_PLAN_SYNCHRONIZATION_STRATEGY = "hibernate.search.indexing.plan.synchronization.strategy";
    public static final String INDEXING_MASS_DEFAULT_CLEAN_OPERATION = "hibernate.search.indexing.mass.default_clean_operation";

    private StandalonePojoMapperSettings() {
    }

    public static class Radicals {
        public static final String SCHEMA_MANAGEMENT_STRATEGY = "schema_management.strategy";
        public static final String MAPPING_PREFIX = "mapping.";
        public static final String MAPPING_BUILD_MISSING_DISCOVERED_JANDEX_INDEXES = "mapping.build_missing_discovered_jandex_indexes";
        public static final String MAPPING_DISCOVER_ANNOTATED_TYPES_FROM_ROOT_MAPPING_ANNOTATIONS = "mapping.discover_annotated_types_from_root_mapping_annotations";
        public static final String MAPPING_CONFIGURER = "mapping.configurer";
        public static final String MULTI_TENANCY_ENABLED = "mapping.multi_tenancy.enabled";
        public static final String MULTI_TENANCY_TENANT_IDENTIFIER_CONVERTER = "mapping.multi_tenancy.tenant_identifier_converter";
        public static final String INDEXING_PLAN_SYNCHRONIZATION_PREFIX = "indexing.plan.synchronization.";
        public static final String INDEXING_PLAN_SYNCHRONIZATION_STRATEGY = "indexing.plan.synchronization.strategy";
        public static final String INDEXING_MASS_DEFAULT_CLEAN_OPERATION = "indexing.mass.default_clean_operation";

        private Radicals() {
        }
    }

    public static final class Defaults {
        public static final SchemaManagementStrategyName SCHEMA_MANAGEMENT_STRATEGY = SchemaManagementStrategyName.CREATE_OR_VALIDATE;
        public static final boolean MAPPING_BUILD_MISSING_DISCOVERED_JANDEX_INDEXES = true;
        public static final boolean MAPPING_DISCOVER_ANNOTATED_TYPES_FROM_ROOT_MAPPING_ANNOTATIONS = true;
        public static final boolean MULTI_TENANCY_ENABLED = false;
        public static final BeanReference<IndexingPlanSynchronizationStrategy> INDEXING_PLAN_SYNCHRONIZATION_STRATEGY = BeanReference.of(IndexingPlanSynchronizationStrategy.class, (String)"write-sync");
        public static final BeanReference<TenantIdentifierConverter> MULTI_TENANCY_TENANT_IDENTIFIER_CONVERTER = BeanReference.of(TenantIdentifierConverter.class, (String)"string-tenant-identifier-converter");
        public static final MassIndexingDefaultCleanOperation INDEXING_MASS_DEFAULT_CLEAN_OPERATION = MassIndexingDefaultCleanOperation.PURGE;

        private Defaults() {
        }
    }
}

