/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.mapping.impl;

import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.mapper.mapping.spi.MappingStartContext;
import org.hibernate.search.mapper.pojo.standalone.cfg.StandalonePojoMapperSettings;
import org.hibernate.search.mapper.pojo.standalone.session.impl.StandalonePojoSearchSessionMappingContext;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategyConfigurationContext;
import org.hibernate.search.mapper.pojo.work.spi.ConfiguredIndexingPlanSynchronizationStrategy;
import org.hibernate.search.util.common.impl.Closer;

public class ConfiguredIndexingPlanSynchronizationStrategyHolder {
    private static final OptionalConfigurationProperty<BeanReference<? extends IndexingPlanSynchronizationStrategy>> INDEXING_PLAN_SYNCHRONIZATION_STRATEGY = ConfigurationProperty.forKey((String)"indexing.plan.synchronization.strategy").asBeanReference(IndexingPlanSynchronizationStrategy.class).build();
    private final StandalonePojoSearchSessionMappingContext mappingContext;
    private BeanHolder<? extends IndexingPlanSynchronizationStrategy> defaultSynchronizationStrategyHolder;
    private ConfiguredIndexingPlanSynchronizationStrategy defaultSynchronizationStrategy;

    public ConfiguredIndexingPlanSynchronizationStrategyHolder(StandalonePojoSearchSessionMappingContext mappingContext) {
        this.mappingContext = mappingContext;
    }

    public void start(MappingStartContext context) {
        this.defaultSynchronizationStrategyHolder = (BeanHolder)INDEXING_PLAN_SYNCHRONIZATION_STRATEGY.getAndTransform(context.configurationPropertySource(), referenceOptional -> context.beanResolver().resolve(referenceOptional.orElse(StandalonePojoMapperSettings.Defaults.INDEXING_PLAN_SYNCHRONIZATION_STRATEGY)));
        this.defaultSynchronizationStrategy = this.configure((IndexingPlanSynchronizationStrategy)this.defaultSynchronizationStrategyHolder.get());
    }

    public ConfiguredIndexingPlanSynchronizationStrategy defaultSynchronizationStrategy() {
        return this.defaultSynchronizationStrategy;
    }

    public ConfiguredIndexingPlanSynchronizationStrategy configureOverriddenSynchronizationStrategy(IndexingPlanSynchronizationStrategy synchronizationStrategy) {
        if (synchronizationStrategy == null) {
            return this.defaultSynchronizationStrategy();
        }
        return this.configure(synchronizationStrategy);
    }

    private ConfiguredIndexingPlanSynchronizationStrategy configure(IndexingPlanSynchronizationStrategy synchronizationStrategy) {
        ConfiguredIndexingPlanSynchronizationStrategy.Builder builder = new ConfiguredIndexingPlanSynchronizationStrategy.Builder(this.mappingContext.failureHandler());
        synchronizationStrategy.apply((IndexingPlanSynchronizationStrategyConfigurationContext)builder);
        return builder.build();
    }

    public void close() {
        try (Closer closer = new Closer();){
            closer.push(BeanHolder::close, this.defaultSynchronizationStrategyHolder);
        }
    }
}

