/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.session;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.search.common.NonStaticMetamodelScope;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.mapper.pojo.standalone.massindexing.MassIndexer;
import org.hibernate.search.mapper.pojo.standalone.schema.management.SearchSchemaManager;
import org.hibernate.search.mapper.pojo.standalone.scope.SearchScope;
import org.hibernate.search.mapper.pojo.standalone.scope.SearchScopeProvider;
import org.hibernate.search.mapper.pojo.standalone.scope.StandalonePojoRootReferenceScope;
import org.hibernate.search.mapper.pojo.standalone.scope.TypedSearchScope;
import org.hibernate.search.mapper.pojo.standalone.work.SearchIndexer;
import org.hibernate.search.mapper.pojo.standalone.work.SearchIndexingPlan;
import org.hibernate.search.mapper.pojo.standalone.work.SearchWorkspace;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategy;
import org.hibernate.search.util.common.annotation.Incubating;

@Incubating
public interface SearchSession
extends SearchScopeProvider,
AutoCloseable {
    @Override
    public void close();

    public boolean isOpen();

    default public MassIndexer massIndexer() {
        return this.massIndexer(Object.class);
    }

    default public MassIndexer massIndexer(Class<?> ... classes) {
        return this.massIndexer(Arrays.asList(classes));
    }

    public MassIndexer massIndexer(Collection<? extends Class<?>> var1);

    default public <T> SearchQuerySelectStep<NonStaticMetamodelScope, ?, EntityReference, T, ?, ?, ?> search(Class<T> clazz) {
        return this.search(Collections.singleton(clazz));
    }

    public <T> SearchQuerySelectStep<NonStaticMetamodelScope, ?, EntityReference, T, ?, ?, ?> search(Collection<? extends Class<? extends T>> var1);

    public <T> SearchQuerySelectStep<?, ?, EntityReference, T, ?, ?, ?> search(SearchScope<T> var1);

    public <SR, T> SearchQuerySelectStep<SR, ?, EntityReference, T, ?, ?, ?> search(TypedSearchScope<SR, T> var1);

    @Incubating
    public <SR, T> SearchQuerySelectStep<SR, ?, EntityReference, T, ?, ?, ?> search(StandalonePojoRootReferenceScope<SR, T> var1);

    default public SearchSchemaManager schemaManager() {
        return this.schemaManager(Collections.singleton(Object.class));
    }

    default public SearchSchemaManager schemaManager(Class<?> ... classes) {
        return this.schemaManager(Arrays.asList(classes));
    }

    public SearchSchemaManager schemaManager(Collection<? extends Class<?>> var1);

    default public SearchWorkspace workspace() {
        return this.workspace(Collections.singleton(Object.class));
    }

    default public SearchWorkspace workspace(Class<?> ... classes) {
        return this.workspace(Arrays.asList(classes));
    }

    public SearchWorkspace workspace(Collection<? extends Class<?>> var1);

    public SearchIndexingPlan indexingPlan();

    public SearchIndexer indexer();

    @Deprecated(since="7.2", forRemoval=true)
    public String tenantIdentifier();

    public Object tenantIdentifierValue();

    public void indexingPlanSynchronizationStrategy(IndexingPlanSynchronizationStrategy var1);
}

