/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.mapping;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotatedTypeSource;
import org.hibernate.search.mapper.pojo.standalone.bootstrap.spi.StandalonePojoIntegrationBooter;
import org.hibernate.search.mapper.pojo.standalone.mapping.CloseableSearchMapping;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.reflect.spi.ValueHandleFactory;

@Incubating
public final class SearchMappingBuilder {
    private final StandalonePojoIntegrationBooter.Builder booterBuilder;

    SearchMappingBuilder(AnnotatedTypeSource annotatedTypeSource) {
        this.booterBuilder = StandalonePojoIntegrationBooter.builder().annotatedTypeSource(annotatedTypeSource);
    }

    SearchMappingBuilder valueReadHandleFactory(ValueHandleFactory valueHandleFactory) {
        this.booterBuilder.valueReadHandleFactory(valueHandleFactory);
        return this;
    }

    public SearchMappingBuilder property(String name, Object value) {
        this.booterBuilder.property(name, value);
        return this;
    }

    public SearchMappingBuilder properties(Map<String, ?> map) {
        this.booterBuilder.properties(map);
        return this;
    }

    public SearchMappingBuilder properties(Reader propertiesReader) throws IOException {
        Properties loaded = new Properties();
        loaded.load(propertiesReader);
        this.properties(loaded.entrySet().stream().collect(Collectors.toMap(e -> Objects.toString(e.getKey()), Map.Entry::getValue)));
        return this;
    }

    public CloseableSearchMapping build() {
        return this.booterBuilder.build().boot();
    }
}

