/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.mapping.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.reporting.spi.BackendMappingHints;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.mapper.mapping.spi.MappingPreStopContext;
import org.hibernate.search.engine.mapper.mapping.spi.MappingStartContext;
import org.hibernate.search.engine.search.common.NonStaticMetamodelScope;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingImplementor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingDefaultCleanOperation;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexerAgent;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexerAgentCreateContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeMappingContext;
import org.hibernate.search.mapper.pojo.standalone.entity.SearchIndexedEntity;
import org.hibernate.search.mapper.pojo.standalone.loading.impl.StandalonePojoLoadingContext;
import org.hibernate.search.mapper.pojo.standalone.mapping.CloseableSearchMapping;
import org.hibernate.search.mapper.pojo.standalone.mapping.impl.ConfiguredIndexingPlanSynchronizationStrategyHolder;
import org.hibernate.search.mapper.pojo.standalone.mapping.impl.StandalonePojoTypeContextContainer;
import org.hibernate.search.mapper.pojo.standalone.massindexing.impl.StandalonePojoMassIndexingSessionContext;
import org.hibernate.search.mapper.pojo.standalone.reporting.impl.StandalonePojoMappingHints;
import org.hibernate.search.mapper.pojo.standalone.schema.management.impl.SchemaManagementListener;
import org.hibernate.search.mapper.pojo.standalone.scope.SearchScope;
import org.hibernate.search.mapper.pojo.standalone.scope.TypedSearchScope;
import org.hibernate.search.mapper.pojo.standalone.scope.impl.SearchScopeImpl;
import org.hibernate.search.mapper.pojo.standalone.session.SearchSession;
import org.hibernate.search.mapper.pojo.standalone.session.SearchSessionBuilder;
import org.hibernate.search.mapper.pojo.standalone.session.impl.StandalonePojoSearchSession;
import org.hibernate.search.mapper.pojo.standalone.session.impl.StandalonePojoSearchSessionMappingContext;
import org.hibernate.search.mapper.pojo.standalone.tenancy.impl.TenancyConfiguration;
import org.hibernate.search.util.common.impl.Closer;

public class StandalonePojoMapping
extends AbstractPojoMappingImplementor<StandalonePojoMapping>
implements CloseableSearchMapping,
StandalonePojoSearchSessionMappingContext {
    private final StandalonePojoTypeContextContainer typeContextContainer;
    private final SchemaManagementListener schemaManagementListener;
    private final ConfiguredIndexingPlanSynchronizationStrategyHolder configuredIndexingPlanSynchronizationStrategyHolder;
    private final MassIndexingDefaultCleanOperation massIndexingDefaultCleanOperation;
    private SearchIntegration.Handle integrationHandle;
    private TenancyConfiguration tenancyConfiguration;
    private boolean active;

    StandalonePojoMapping(PojoMappingDelegate mappingDelegate, StandalonePojoTypeContextContainer typeContextContainer, SchemaManagementListener schemaManagementListener, MassIndexingDefaultCleanOperation massIndexingDefaultCleanOperation) {
        super(mappingDelegate);
        this.typeContextContainer = typeContextContainer;
        this.schemaManagementListener = schemaManagementListener;
        this.configuredIndexingPlanSynchronizationStrategyHolder = new ConfiguredIndexingPlanSynchronizationStrategyHolder(this);
        this.active = true;
        this.massIndexingDefaultCleanOperation = massIndexingDefaultCleanOperation;
    }

    public CompletableFuture<?> start(MappingStartContext context) {
        this.integrationHandle = context.integrationHandle();
        this.configuredIndexingPlanSynchronizationStrategyHolder.start(context);
        Optional<SearchScopeImpl<?, Object>> scopeOptional = this.createAllScope();
        if (!scopeOptional.isPresent()) {
            return CompletableFuture.completedFuture(null);
        }
        SearchScopeImpl<?, Object> scope = scopeOptional.get();
        PojoScopeSchemaManager schemaManager = scope.schemaManagerDelegate();
        this.tenancyConfiguration = TenancyConfiguration.create(context.beanResolver(), this.delegate().tenancyMode(), context.configurationPropertySource());
        return this.schemaManagementListener.onStart(context, schemaManager);
    }

    public CompletableFuture<?> preStop(MappingPreStopContext context) {
        Optional<SearchScopeImpl<?, Object>> scope = this.createAllScope();
        if (!scope.isPresent()) {
            return CompletableFuture.completedFuture(null);
        }
        PojoScopeSchemaManager schemaManager = scope.get().schemaManagerDelegate();
        return this.schemaManagementListener.onStop(context, schemaManager);
    }

    @Override
    public void close() {
        if (!this.active) {
            return;
        }
        try (Closer closer = new Closer();){
            closer.push(SearchIntegration::close, (Object)this.integrationHandle, SearchIntegration.Handle::getOrNull);
            closer.push(ConfiguredIndexingPlanSynchronizationStrategyHolder::close, (Object)this.configuredIndexingPlanSynchronizationStrategyHolder);
            closer.push(TenancyConfiguration::close, (Object)this.tenancyConfiguration);
            this.integrationHandle = null;
            this.active = false;
        }
    }

    public BackendMappingHints hints() {
        return StandalonePojoMappingHints.INSTANCE;
    }

    @Override
    public PojoRuntimeIntrospector runtimeIntrospector() {
        return PojoRuntimeIntrospector.simple();
    }

    @Override
    public MassIndexingDefaultCleanOperation massIndexingDefaultCleanOperation() {
        return this.massIndexingDefaultCleanOperation;
    }

    @Override
    public <T> SearchScope<T> scope(Collection<? extends Class<? extends T>> targetedTypes) {
        return this.createScope(NonStaticMetamodelScope.class, targetedTypes);
    }

    @Override
    public <T> SearchScope<T> scope(Class<T> expectedSuperType, Collection<String> entityNames) {
        return this.createScope(NonStaticMetamodelScope.class, expectedSuperType, entityNames);
    }

    @Override
    public <SR, T> TypedSearchScope<SR, T> typedScope(Class<SR> rootScope, Collection<? extends Class<? extends T>> classes) {
        return this.createScope(rootScope, classes);
    }

    public StandalonePojoMapping toConcreteType() {
        return this;
    }

    @Override
    public SearchSession createSession() {
        return this.createSessionBuilder().build();
    }

    @Override
    public SearchSessionBuilder createSessionWithOptions() {
        return this.createSessionBuilder();
    }

    @Override
    public <SR, T> SearchScopeImpl<SR, T> createScope(Class<SR> rootScope, Collection<? extends Class<? extends T>> classes) {
        PojoScopeDelegate scopeDelegate = this.delegate().createPojoScopeForClasses((PojoScopeMappingContext)this, rootScope, classes, this.typeContextContainer::indexedForExactType);
        return new SearchScopeImpl(this, this.tenancyConfiguration, scopeDelegate);
    }

    @Override
    public <SR, T> SearchScopeImpl<SR, T> createScope(Class<SR> rootScope, Class<T> expectedSuperType, Collection<String> entityNames) {
        PojoScopeDelegate scopeDelegate = this.delegate().createPojoScopeForEntityNames((PojoScopeMappingContext)this, rootScope, expectedSuperType, entityNames, this.typeContextContainer::indexedForExactType);
        return new SearchScopeImpl(this, this.tenancyConfiguration, scopeDelegate);
    }

    @Override
    public <E> SearchIndexedEntity<E> indexedEntity(Class<E> entityType) {
        return this.typeContextContainer.indexedForExactClass(entityType);
    }

    @Override
    public SearchIndexedEntity<?> indexedEntity(String entityName) {
        return (SearchIndexedEntity)this.typeContextContainer.indexedByEntityName().getOrFail((Object)entityName);
    }

    public Collection<SearchIndexedEntity<?>> allIndexedEntities() {
        return Collections.unmodifiableCollection(this.typeContextContainer.allIndexed());
    }

    @Override
    public IndexManager indexManager(String indexName) {
        return this.searchIntegration().indexManager(indexName);
    }

    @Override
    public Backend backend() {
        return this.searchIntegration().backend();
    }

    @Override
    public Backend backend(String backendName) {
        return this.searchIntegration().backend(backendName);
    }

    @Override
    public StandalonePojoLoadingContext.Builder loadingContextBuilder() {
        return new StandalonePojoLoadingContext.Builder(this);
    }

    public PojoMassIndexerAgent createMassIndexerAgent(PojoMassIndexerAgentCreateContext context) {
        return PojoMassIndexerAgent.noOp();
    }

    @Override
    public StandalonePojoMassIndexingSessionContext createSession(String tenantIdentifier) {
        return this.createSessionBuilder().tenantId(tenantIdentifier).build();
    }

    @Override
    public TenancyConfiguration tenancyConfiguration() {
        return this.tenancyConfiguration;
    }

    private SearchIntegration searchIntegration() {
        return this.integrationHandle.getOrFail();
    }

    private Optional<SearchScopeImpl<?, Object>> createAllScope() {
        return this.delegate().createPojoAllScope((PojoScopeMappingContext)this, NonStaticMetamodelScope.class, this.typeContextContainer::indexedForExactType).map(scopeDelegate -> new SearchScopeImpl(this, this.tenancyConfiguration, scopeDelegate));
    }

    private StandalonePojoSearchSession.Builder createSessionBuilder() {
        return new StandalonePojoSearchSession.Builder(this, this.configuredIndexingPlanSynchronizationStrategyHolder, this.typeContextContainer);
    }
}

