/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class DefaultDurationValueBridge
implements ValueBridge<Duration, Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public StandardIndexFieldTypeContext<?, Long> bind(ValueBridgeBindingContext<Duration> context) {
        return (StandardIndexFieldTypeContext)context.getTypeFactory().asLong().projectionConverter((FromDocumentFieldValueConverter)PojoDefaultZoneOffsetFromDocumentFieldValueConverter.INSTANCE);
    }

    @Override
    public Long toIndexedValue(Duration value, ValueBridgeToIndexedValueContext context) {
        return this.toIndexedValue(value);
    }

    @Override
    public Duration cast(Object value) {
        return (Duration)value;
    }

    @Override
    public Long parse(String value) {
        return this.toIndexedValue(ParseUtils.parseDuration((String)value));
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    private Long toIndexedValue(Duration value) {
        if (value == null) {
            return null;
        }
        try {
            return value.toNanos();
        }
        catch (ArithmeticException ae) {
            throw log.valueTooLargeForConversionException(Duration.class, value, ae);
        }
    }

    private static class PojoDefaultZoneOffsetFromDocumentFieldValueConverter
    implements FromDocumentFieldValueConverter<Long, Duration> {
        private static final PojoDefaultZoneOffsetFromDocumentFieldValueConverter INSTANCE = new PojoDefaultZoneOffsetFromDocumentFieldValueConverter();

        private PojoDefaultZoneOffsetFromDocumentFieldValueConverter() {
        }

        public boolean isConvertedTypeAssignableTo(Class<?> superTypeCandidate) {
            return superTypeCandidate.isAssignableFrom(Duration.class);
        }

        public Duration convert(Long value, FromDocumentFieldValueConvertContext context) {
            return value == null ? null : Duration.ofNanos(value);
        }

        public boolean isCompatibleWith(FromDocumentFieldValueConverter<?, ?> other) {
            return INSTANCE.equals(other);
        }
    }
}

