/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.sql.Date;
import java.time.Instant;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultJavaSqlDateValueBridge
implements ValueBridge<Date, Instant> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public StandardIndexFieldTypeContext<?, Instant> bind(ValueBridgeBindingContext<Date> context) {
        return (StandardIndexFieldTypeContext)context.getTypeFactory().asInstant().projectionConverter((FromDocumentFieldValueConverter)PojoDefaultSqlDateFromDocumentFieldValueConverter.INSTANCE);
    }

    @Override
    public Instant toIndexedValue(Date value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : Instant.ofEpochMilli(value.getTime());
    }

    @Override
    public Date cast(Object value) {
        return (Date)value;
    }

    @Override
    public Instant parse(String value) {
        return ParseUtils.parseInstant((String)value);
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    private static class PojoDefaultSqlDateFromDocumentFieldValueConverter
    implements FromDocumentFieldValueConverter<Instant, Date> {
        private static final PojoDefaultSqlDateFromDocumentFieldValueConverter INSTANCE = new PojoDefaultSqlDateFromDocumentFieldValueConverter();

        private PojoDefaultSqlDateFromDocumentFieldValueConverter() {
        }

        public boolean isConvertedTypeAssignableTo(Class<?> superTypeCandidate) {
            return superTypeCandidate.isAssignableFrom(Date.class);
        }

        public Date convert(Instant value, FromDocumentFieldValueConvertContext context) {
            return value == null ? null : new Date(value.toEpochMilli());
        }

        public boolean isCompatibleWith(FromDocumentFieldValueConverter<?, ?> other) {
            return INSTANCE.equals(other);
        }
    }
}

