/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.util.function.Function;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.PassThroughFromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;
import org.hibernate.search.util.common.impl.Contracts;

public final class PassThroughValueBridge<F>
implements ValueBridge<F, F> {
    private final Class<F> fieldType;
    private final Function<String, F> parsingFunction;

    public PassThroughValueBridge(Class<F> fieldType, Function<String, F> parsingFunction) {
        Contracts.assertNotNull(fieldType, (String)"fieldType");
        this.fieldType = fieldType;
        this.parsingFunction = parsingFunction;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.fieldType.getName() + "]";
    }

    @Override
    public StandardIndexFieldTypeContext<?, F> bind(ValueBridgeBindingContext<F> context) {
        return (StandardIndexFieldTypeContext)context.getTypeFactory().as(this.fieldType).projectionConverter((FromDocumentFieldValueConverter)new PassThroughFromDocumentFieldValueConverter(this.fieldType));
    }

    @Override
    public F cast(Object value) {
        return this.fieldType.cast(value);
    }

    @Override
    public F parse(String value) {
        return this.parsingFunction.apply(value);
    }

    @Override
    public F toIndexedValue(F value, ValueBridgeToIndexedValueContext context) {
        return value;
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        PassThroughValueBridge castedOther = (PassThroughValueBridge)other;
        return this.fieldType.equals(castedOther.fieldType);
    }
}

