/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.impl;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hibernate.search.engine.cfg.spi.ConvertUtils;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultBigIntegerIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultCharacterValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultDurationValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultEnumIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultEnumValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultIntegerIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaNetURIValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaNetURLValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaSqlDateValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaSqlTimeValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaSqlTimestampValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaUtilCalendarValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaUtilDateValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultLongIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultPeriodValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultShortIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultUUIDIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultUUIDValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultZoneIdValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultZoneOffsetValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.PassThroughValueBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuilder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcher;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcherFactory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class BridgeResolver {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<Class<?>, BridgeBuilder<? extends IdentifierBridge<?>>> exactRawTypeIdentifierBridgeMappings = new HashMap();
    private final Map<Class<?>, BridgeBuilder<? extends ValueBridge<?, ?>>> exactRawTypeValueBridgeMappings = new HashMap();
    private final List<TypePatternBridgeMapping<? extends IdentifierBridge<?>>> typePatternIdentifierBridgeMappings = new ArrayList();
    private final List<TypePatternBridgeMapping<? extends ValueBridge<?, ?>>> typePatternValueBridgeMappings = new ArrayList();

    public BridgeResolver(TypePatternMatcherFactory typePatternMatcherFactory) {
        TypePatternMatcher concreteEnumPattern = typePatternMatcherFactory.createRawSuperTypeMatcher(Enum.class).and(typePatternMatcherFactory.createExactRawTypeMatcher(Enum.class).negate());
        this.addIdentifierBridgeForExactRawType(Integer.class, ignored -> BeanHolder.of((Object)new DefaultIntegerIdentifierBridge()));
        this.addIdentifierBridgeForExactRawType(Long.class, ignored -> BeanHolder.of((Object)new DefaultLongIdentifierBridge()));
        this.addIdentifierBridgeForTypePattern(concreteEnumPattern, ignored -> BeanHolder.of(new DefaultEnumIdentifierBridge()));
        this.addIdentifierBridgeForExactRawType(Short.class, ignored -> BeanHolder.of((Object)new DefaultShortIdentifierBridge()));
        this.addIdentifierBridgeForExactRawType(BigInteger.class, ignored -> BeanHolder.of((Object)new DefaultBigIntegerIdentifierBridge()));
        this.addIdentifierBridgeForExactRawType(UUID.class, ignored -> BeanHolder.of((Object)new DefaultUUIDIdentifierBridge()));
        this.addValueBridgeForExactRawType(Integer.class, ignored -> BeanHolder.of(new PassThroughValueBridge<Integer>(Integer.class, ConvertUtils::convertInteger)));
        this.addValueBridgeForExactRawType(Long.class, ignored -> BeanHolder.of(new PassThroughValueBridge<Long>(Long.class, ConvertUtils::convertLong)));
        this.addValueBridgeForExactRawType(Boolean.class, ignored -> BeanHolder.of(new PassThroughValueBridge<Boolean>(Boolean.class, ConvertUtils::convertBoolean)));
        this.addValueBridgeForExactRawType(String.class, ignored -> BeanHolder.of(new PassThroughValueBridge<String>(String.class, ParseUtils::parseString)));
        this.addValueBridgeForExactRawType(LocalDate.class, ignored -> BeanHolder.of(new PassThroughValueBridge<LocalDate>(LocalDate.class, ParseUtils::parseLocalDate)));
        this.addValueBridgeForExactRawType(Instant.class, ignored -> BeanHolder.of(new PassThroughValueBridge<Instant>(Instant.class, ParseUtils::parseInstant)));
        this.addValueBridgeForExactRawType(java.util.Date.class, ignored -> BeanHolder.of((Object)new DefaultJavaUtilDateValueBridge()));
        this.addValueBridgeForExactRawType(Calendar.class, ignored -> BeanHolder.of((Object)new DefaultJavaUtilCalendarValueBridge()));
        this.addValueBridgeForTypePattern(concreteEnumPattern, ignored -> BeanHolder.of(new DefaultEnumValueBridge()));
        this.addValueBridgeForExactRawType(Character.class, ignored -> BeanHolder.of((Object)new DefaultCharacterValueBridge()));
        this.addValueBridgeForExactRawType(Byte.class, ignored -> BeanHolder.of(new PassThroughValueBridge<Byte>(Byte.class, ConvertUtils::convertByte)));
        this.addValueBridgeForExactRawType(Short.class, ignored -> BeanHolder.of(new PassThroughValueBridge<Short>(Short.class, ConvertUtils::convertShort)));
        this.addValueBridgeForExactRawType(Float.class, ignored -> BeanHolder.of(new PassThroughValueBridge<Float>(Float.class, ConvertUtils::convertFloat)));
        this.addValueBridgeForExactRawType(Double.class, ignored -> BeanHolder.of(new PassThroughValueBridge<Double>(Double.class, ConvertUtils::convertDouble)));
        this.addValueBridgeForExactRawType(BigDecimal.class, ignored -> BeanHolder.of(new PassThroughValueBridge<BigDecimal>(BigDecimal.class, ConvertUtils::convertBigDecimal)));
        this.addValueBridgeForExactRawType(BigInteger.class, ignored -> BeanHolder.of(new PassThroughValueBridge<BigInteger>(BigInteger.class, ConvertUtils::convertBigInteger)));
        this.addValueBridgeForExactRawType(UUID.class, ignored -> BeanHolder.of((Object)new DefaultUUIDValueBridge()));
        this.addValueBridgeForExactRawType(LocalDateTime.class, ignored -> BeanHolder.of(new PassThroughValueBridge<LocalDateTime>(LocalDateTime.class, ParseUtils::parseLocalDateTime)));
        this.addValueBridgeForExactRawType(LocalTime.class, ignored -> BeanHolder.of(new PassThroughValueBridge<LocalTime>(LocalTime.class, ParseUtils::parseLocalTime)));
        this.addValueBridgeForExactRawType(ZonedDateTime.class, ignored -> BeanHolder.of(new PassThroughValueBridge<ZonedDateTime>(ZonedDateTime.class, ParseUtils::parseZonedDateTime)));
        this.addValueBridgeForExactRawType(Year.class, ignored -> BeanHolder.of(new PassThroughValueBridge<Year>(Year.class, ParseUtils::parseYear)));
        this.addValueBridgeForExactRawType(YearMonth.class, ignored -> BeanHolder.of(new PassThroughValueBridge<YearMonth>(YearMonth.class, ParseUtils::parseYearMonth)));
        this.addValueBridgeForExactRawType(MonthDay.class, ignored -> BeanHolder.of(new PassThroughValueBridge<MonthDay>(MonthDay.class, ParseUtils::parseMonthDay)));
        this.addValueBridgeForExactRawType(OffsetDateTime.class, ignored -> BeanHolder.of(new PassThroughValueBridge<OffsetDateTime>(OffsetDateTime.class, ParseUtils::parseOffsetDateTime)));
        this.addValueBridgeForExactRawType(OffsetTime.class, ignored -> BeanHolder.of(new PassThroughValueBridge<OffsetTime>(OffsetTime.class, ParseUtils::parseOffsetTime)));
        this.addValueBridgeForExactRawType(ZoneOffset.class, ignored -> BeanHolder.of((Object)new DefaultZoneOffsetValueBridge()));
        this.addValueBridgeForExactRawType(ZoneId.class, ignored -> BeanHolder.of((Object)new DefaultZoneIdValueBridge()));
        this.addValueBridgeForExactRawType(Period.class, ignored -> BeanHolder.of((Object)new DefaultPeriodValueBridge()));
        this.addValueBridgeForExactRawType(Duration.class, ignored -> BeanHolder.of((Object)new DefaultDurationValueBridge()));
        this.addValueBridgeForExactRawType(URI.class, ignored -> BeanHolder.of((Object)new DefaultJavaNetURIValueBridge()));
        this.addValueBridgeForExactRawType(URL.class, ignored -> BeanHolder.of((Object)new DefaultJavaNetURLValueBridge()));
        this.addValueBridgeForExactRawType(Date.class, ignored -> BeanHolder.of((Object)new DefaultJavaSqlDateValueBridge()));
        this.addValueBridgeForExactRawType(Timestamp.class, ignored -> BeanHolder.of((Object)new DefaultJavaSqlTimestampValueBridge()));
        this.addValueBridgeForExactRawType(Time.class, ignored -> BeanHolder.of((Object)new DefaultJavaSqlTimeValueBridge()));
    }

    public BridgeBuilder<? extends IdentifierBridge<?>> resolveIdentifierBridgeForType(PojoGenericTypeModel<?> sourceType) {
        BridgeBuilder result = BridgeResolver.getBridgeBuilderOrNull(sourceType, this.exactRawTypeIdentifierBridgeMappings, this.typePatternIdentifierBridgeMappings);
        if (result == null) {
            throw log.unableToResolveDefaultIdentifierBridgeFromSourceType(sourceType);
        }
        return result;
    }

    public BridgeBuilder<? extends ValueBridge<?, ?>> resolveValueBridgeForType(PojoGenericTypeModel<?> sourceType) {
        BridgeBuilder result = BridgeResolver.getBridgeBuilderOrNull(sourceType, this.exactRawTypeValueBridgeMappings, this.typePatternValueBridgeMappings);
        if (result == null) {
            throw log.unableToResolveDefaultValueBridgeFromSourceType(sourceType);
        }
        return result;
    }

    private <I> void addIdentifierBridgeForExactRawType(Class<I> type, BridgeBuilder<? extends IdentifierBridge<I>> builder) {
        this.exactRawTypeIdentifierBridgeMappings.put(type, builder);
    }

    private void addIdentifierBridgeForTypePattern(TypePatternMatcher typePatternMatcher, BridgeBuilder<? extends IdentifierBridge<?>> builder) {
        this.typePatternIdentifierBridgeMappings.add(new TypePatternBridgeMapping(typePatternMatcher, builder));
    }

    private <V> void addValueBridgeForExactRawType(Class<V> type, BridgeBuilder<? extends ValueBridge<? super V, ?>> builder) {
        this.exactRawTypeValueBridgeMappings.put(type, builder);
    }

    private void addValueBridgeForTypePattern(TypePatternMatcher typePatternMatcher, BridgeBuilder<? extends ValueBridge<?, ?>> builder) {
        this.typePatternValueBridgeMappings.add(new TypePatternBridgeMapping(typePatternMatcher, builder));
    }

    private static <B> BridgeBuilder<? extends B> getBridgeBuilderOrNull(PojoGenericTypeModel<?> sourceType, Map<Class<?>, BridgeBuilder<? extends B>> exactRawTypeBridgeMappings, List<TypePatternBridgeMapping<? extends B>> typePatternBridgeMappings) {
        Class rawType = sourceType.getRawType().getJavaClass();
        BridgeBuilder<? extends B> result = exactRawTypeBridgeMappings.get(rawType);
        if (result == null) {
            Iterator<TypePatternBridgeMapping<B>> mappingIterator = typePatternBridgeMappings.iterator();
            while (result == null && mappingIterator.hasNext()) {
                result = mappingIterator.next().getBuilderIfMatching(sourceType);
            }
        }
        return result;
    }

    private static final class TypePatternBridgeMapping<B> {
        private final TypePatternMatcher matcher;
        private final BridgeBuilder<B> builder;

        TypePatternBridgeMapping(TypePatternMatcher matcher, BridgeBuilder<B> builder) {
            this.matcher = matcher;
            this.builder = builder;
        }

        BridgeBuilder<B> getBuilderIfMatching(PojoGenericTypeModel<?> typeModel) {
            if (this.matcher.matches(typeModel)) {
                return this.builder;
            }
            return null;
        }
    }
}

