/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.extractor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.BuiltinContainerExtractor;

public class ContainerExtractorPath {
    private static final ContainerExtractorPath DEFAULT = new ContainerExtractorPath(true, Collections.emptyList());
    private static final ContainerExtractorPath NONE = new ContainerExtractorPath(false, Collections.emptyList());
    private final boolean applyDefaultExtractors;
    private final List<? extends Class<? extends ContainerExtractor>> explicitExtractorClasses;

    public static ContainerExtractorPath defaultExtractors() {
        return DEFAULT;
    }

    public static ContainerExtractorPath noExtractors() {
        return NONE;
    }

    public static ContainerExtractorPath explicitExtractor(Class<? extends ContainerExtractor> extractorClass) {
        return new ContainerExtractorPath(false, Collections.singletonList(extractorClass));
    }

    public static ContainerExtractorPath explicitExtractor(BuiltinContainerExtractor extractor) {
        return ContainerExtractorPath.explicitExtractor(extractor.getType());
    }

    public static ContainerExtractorPath explicitExtractors(List<? extends Class<? extends ContainerExtractor>> extractorClasses) {
        if (extractorClasses.isEmpty()) {
            return ContainerExtractorPath.noExtractors();
        }
        return new ContainerExtractorPath(false, Collections.unmodifiableList(new ArrayList<Class<? extends ContainerExtractor>>(extractorClasses)));
    }

    private ContainerExtractorPath(boolean applyDefaultExtractors, List<? extends Class<? extends ContainerExtractor>> explicitExtractorClasses) {
        this.applyDefaultExtractors = applyDefaultExtractors;
        this.explicitExtractorClasses = explicitExtractorClasses;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContainerExtractorPath)) {
            return false;
        }
        ContainerExtractorPath other = (ContainerExtractorPath)obj;
        return this.applyDefaultExtractors == other.applyDefaultExtractors && Objects.equals(this.explicitExtractorClasses, other.explicitExtractorClasses);
    }

    public int hashCode() {
        return Objects.hash(this.applyDefaultExtractors, this.explicitExtractorClasses);
    }

    public String toString() {
        if (this.isDefault()) {
            return "<default value extractors>";
        }
        if (this.explicitExtractorClasses.isEmpty()) {
            return "<no value extractors>";
        }
        StringJoiner joiner = new StringJoiner(", ", "<", ">");
        for (Class<? extends ContainerExtractor> clazz : this.explicitExtractorClasses) {
            joiner.add(clazz.getName());
        }
        return joiner.toString();
    }

    public boolean isDefault() {
        return this.applyDefaultExtractors;
    }

    public boolean isEmpty() {
        return !this.isDefault() && this.explicitExtractorClasses.isEmpty();
    }

    public List<? extends Class<? extends ContainerExtractor>> getExplicitExtractorClasses() {
        return this.explicitExtractorClasses;
    }
}

